/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.LargeMessageController;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;
import org.apache.activemq.artemis.utils.InflaterReader;
import org.apache.activemq.artemis.utils.InflaterWriter;
import org.apache.activemq.artemis.utils.UTF8Util;

final class CompressedLargeMessageControllerImpl
implements LargeMessageController {
    private static final String OPERATION_NOT_SUPPORTED = "Operation not supported";
    private final LargeMessageController bufferDelegate;
    DataInputStream dataInput = null;

    CompressedLargeMessageControllerImpl(LargeMessageController bufferDelegate) {
        this.bufferDelegate = bufferDelegate;
    }

    @Override
    public void discardUnusedPackets() {
        this.bufferDelegate.discardUnusedPackets();
    }

    @Override
    public void addPacket(byte[] chunk, int flowControlSize, boolean isContinues) {
        this.bufferDelegate.addPacket(chunk, flowControlSize, isContinues);
    }

    @Override
    public synchronized void cancel() {
        this.bufferDelegate.cancel();
    }

    @Override
    public synchronized void close() {
        this.bufferDelegate.cancel();
    }

    @Override
    public void setOutputStream(OutputStream output) throws ActiveMQException {
        this.bufferDelegate.setOutputStream(new InflaterWriter(output));
    }

    @Override
    public synchronized void saveBuffer(OutputStream output) throws ActiveMQException {
        this.setOutputStream(output);
        this.waitCompletion(0L);
    }

    @Override
    public synchronized boolean waitCompletion(long timeWait) throws ActiveMQException {
        return this.bufferDelegate.waitCompletion(timeWait);
    }

    public int capacity() {
        return -1;
    }

    private DataInputStream getStream() {
        if (this.dataInput == null) {
            try {
                ActiveMQBufferInputStream input = new ActiveMQBufferInputStream(this.bufferDelegate);
                this.dataInput = new DataInputStream(new InflaterReader(input));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.dataInput;
    }

    private void positioningNotSupported() {
        throw new IllegalStateException("Position not supported over compressed large messages");
    }

    public byte readByte() {
        try {
            return this.getStream().readByte();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte getByte(int index) {
        this.positioningNotSupported();
        return 0;
    }

    public void getBytes(int index, ActiveMQBuffer dst, int dstIndex, int length) {
        this.positioningNotSupported();
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.positioningNotSupported();
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.positioningNotSupported();
    }

    public int getInt(int index) {
        this.positioningNotSupported();
        return 0;
    }

    public long getLong(int index) {
        this.positioningNotSupported();
        return 0L;
    }

    public short getShort(int index) {
        this.positioningNotSupported();
        return 0;
    }

    public void setByte(int index, byte value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setBytes(int index, ActiveMQBuffer src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setBytes(int index, ByteBuffer src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setInt(int index, int value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setLong(int index, long value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setShort(int index, short value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void release() {
    }

    public int readerIndex() {
        return 0;
    }

    public void readerIndex(int readerIndex) {
    }

    public int writerIndex() {
        return 0;
    }

    @Override
    public long getSize() {
        return this.bufferDelegate.getSize();
    }

    public void writerIndex(int writerIndex) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.positioningNotSupported();
    }

    public void clear() {
    }

    public boolean readable() {
        return true;
    }

    public boolean writable() {
        return false;
    }

    public int readableBytes() {
        return 1;
    }

    public int writableBytes() {
        return 0;
    }

    public void markReaderIndex() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void resetReaderIndex() {
    }

    public void markWriterIndex() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void resetWriterIndex() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void discardReadBytes() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public void getBytes(int index, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = this.getByte(index++);
        }
    }

    public void getBytes(int index, ActiveMQBuffer dst) {
        this.getBytes(index, dst, dst.writableBytes());
    }

    public void getBytes(int index, ActiveMQBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    public void setBytes(int index, byte[] src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setBytes(int index, ActiveMQBuffer src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setBytes(int index, ActiveMQBuffer src, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public int readUnsignedByte() {
        try {
            return this.getStream().readUnsignedByte();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public short readShort() {
        try {
            return this.getStream().readShort();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int readUnsignedShort() {
        try {
            return this.getStream().readUnsignedShort();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int readInt() {
        try {
            return this.getStream().readInt();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() {
        try {
            return this.getStream().readLong();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        try {
            int nReadBytes = this.getStream().read(dst, dstIndex, length);
            if (nReadBytes < length) {
                ActiveMQClientLogger.LOGGER.compressedLargeMessageError(length, nReadBytes);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    public void readBytes(ActiveMQBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    public void readBytes(ActiveMQBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    public void readBytes(ActiveMQBuffer dst, int dstIndex, int length) {
        byte[] destBytes = new byte[length];
        this.readBytes(destBytes);
        dst.setBytes(dstIndex, destBytes);
    }

    public void readBytes(ByteBuffer dst) {
        byte[] bytesToGet = new byte[dst.remaining()];
        this.readBytes(bytesToGet);
        dst.put(bytesToGet);
    }

    public int skipBytes(int length) {
        try {
            for (int i = 0; i < length; ++i) {
                this.getStream().read();
            }
            return length;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.readBytes(b, off, len);
    }

    public String readLine() throws IOException {
        return this.getStream().readLine();
    }

    public void writeByte(byte value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeShort(short value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeInt(int value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeLong(long value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeBytes(byte[] src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeBytes(ActiveMQBuffer src, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeBytes(ByteBuffer src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeBytes(ByteBuf src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public ByteBuffer toByteBuffer() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public Object getUnderlyingBuffer() {
        return this;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public ActiveMQBuffer readBytes(int length) {
        byte[] bytesToGet = new byte[length];
        this.readBytes(bytesToGet);
        return ActiveMQBuffers.wrappedBuffer((byte[])bytesToGet);
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public SimpleString readNullableSimpleString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleString();
    }

    public String readNullableString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readString();
    }

    public SimpleString readSimpleString() {
        int len = this.readInt();
        byte[] data = new byte[len];
        this.readBytes(data);
        return new SimpleString(data);
    }

    public String readString() {
        int len = this.readInt();
        if (len < 9) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.readShort();
            }
            return new String(chars);
        }
        if (len < 4095) {
            return this.readUTF();
        }
        return this.readSimpleString().toString();
    }

    public String readUTF() {
        return UTF8Util.readUTF((ActiveMQBuffer)this);
    }

    public void writeBoolean(boolean val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeChar(char val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeDouble(double val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeFloat(float val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeNullableSimpleString(SimpleString val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeNullableString(String val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeSimpleString(SimpleString val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeString(String val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeUTF(String utf) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public ActiveMQBuffer copy() {
        throw new UnsupportedOperationException();
    }

    public ActiveMQBuffer slice(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf byteBuf() {
        return null;
    }

    public ActiveMQBuffer copy(int index, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public ActiveMQBuffer duplicate() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public ActiveMQBuffer readSlice(int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setChar(int index, char value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setDouble(int index, double value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void setFloat(int index, float value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public ActiveMQBuffer slice() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public void writeBytes(ActiveMQBuffer src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }
}

