/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.Serializable;
import java.net.InetAddress;

public class ClientMapping
implements Serializable {
    private final InetAddress sourceNetworkAddress;
    private final byte sourceNetworkMaskBits;
    private final String destinationAddress;
    private volatile int destinationPort = -1;

    public ClientMapping(InetAddress sourceNetworkAddress, int sourceNetworkMaskBits, String destinationAddress, int destinationPort) {
        this.sourceNetworkAddress = sourceNetworkAddress;
        this.sourceNetworkMaskBits = (byte)sourceNetworkMaskBits;
        this.destinationAddress = destinationAddress;
        this.destinationPort = destinationPort;
    }

    public InetAddress getSourceNetworkAddress() {
        return this.sourceNetworkAddress;
    }

    public int getSourceNetworkMaskBits() {
        return this.sourceNetworkMaskBits & 0xFF;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    void updatePortIfUnknown(int port) {
        if (this.destinationPort == -1) {
            this.destinationPort = port;
        }
    }
}

