/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.wrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenCollectionType;
import org.picketlink.identity.federation.ws.trust.RequestSecurityTokenType;

public class RequestSecurityTokenCollection
implements BaseRequestSecurityToken {
    private final RequestSecurityTokenCollectionType delegate;
    private final List<RequestSecurityToken> requestSecurityTokens;

    public RequestSecurityTokenCollection() {
        this.requestSecurityTokens = new ArrayList<RequestSecurityToken>();
        this.delegate = new RequestSecurityTokenCollectionType();
    }

    public RequestSecurityTokenCollection(RequestSecurityTokenCollectionType delegate) {
        this.delegate = delegate;
        this.requestSecurityTokens = new ArrayList<RequestSecurityToken>();
        for (RequestSecurityTokenType request : delegate.getRequestSecurityToken()) {
            this.requestSecurityTokens.add(new RequestSecurityToken(request));
        }
    }

    public List<RequestSecurityToken> getRequestSecurityTokens() {
        return Collections.unmodifiableList(this.requestSecurityTokens);
    }

    public void addRequestSecurityToken(RequestSecurityToken request) {
        this.delegate.add(request.getDelegate());
        this.requestSecurityTokens.add(request);
    }

    public void removeRequestSecurityToken(RequestSecurityToken request) {
        this.delegate.remove(request.getDelegate());
        this.requestSecurityTokens.remove(request);
    }

    public RequestSecurityTokenCollectionType getDelegate() {
        return this.delegate;
    }
}

