/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.QueryCustomization;

class QueryCustomizer
implements QueryCustomization<QueryCustomizer> {
    private float boost = 1.0f;
    private boolean constantScore;
    private Query wrappedQuery;
    private Query filter;

    QueryCustomizer() {
    }

    @Override
    public QueryCustomizer boostedTo(float boost) {
        this.boost = boost * this.boost;
        return this;
    }

    @Override
    public QueryCustomizer withConstantScore() {
        this.constantScore = true;
        return this;
    }

    @Override
    public QueryCustomizer filteredBy(Query filter) {
        this.filter = filter;
        return this;
    }

    public QueryCustomizer setWrappedQuery(Query wrappedQuery) {
        this.wrappedQuery = wrappedQuery;
        return this;
    }

    public float getBoost() {
        return this.boost;
    }

    public Query createQuery() {
        Query finalQuery = this.wrappedQuery;
        if (this.wrappedQuery == null) {
            throw new AssertionFailure("wrapped query not set");
        }
        finalQuery.setBoost(this.boost * finalQuery.getBoost());
        if (this.filter != null) {
            finalQuery = new BooleanQuery.Builder().add(finalQuery, BooleanClause.Occur.MUST).add(this.filter, BooleanClause.Occur.FILTER).build();
        }
        if (this.constantScore) {
            finalQuery = new ConstantScoreQuery(finalQuery);
        }
        return finalQuery;
    }
}

