/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.MetricsRequestHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricsContextService;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;
import org.wildfly.extension.microprofile.metrics.MicroProfileVendorMetricRegistry;

public class MicroProfileMetricsContextService
implements Service {
    private final Supplier<MetricsContextService> metricsContextService;
    private final MetricsRequestHandler metricsRequestHandler = new MetricsRequestHandler();

    static void install(OperationContext context) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileMetricsSubsystemDefinition.MICROPROFILE_METRIC_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName());
        Supplier metricsContextService = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.extension.metrics.http-context", MetricsContextService.class));
        MicroProfileMetricsContextService microprofileMetricsContextService = new MicroProfileMetricsContextService(metricsContextService);
        serviceBuilder.setInstance((Service)microprofileMetricsContextService).install();
    }

    MicroProfileMetricsContextService(Supplier<MetricsContextService> metricsContextService) {
        this.metricsContextService = metricsContextService;
    }

    public void start(StartContext context) {
        this.metricsContextService.get().setOverrideableMetricHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String requestPath = exchange.getRequestPath();
                String method = exchange.getRequestMethod().toString();
                HeaderValues acceptHeaders = exchange.getRequestHeaders().get(Headers.ACCEPT);
                MicroProfileMetricsContextService.this.metricsRequestHandler.handleRequest(requestPath, method, acceptHeaders == null ? null : acceptHeaders.stream(), (status, message, headers) -> {
                    exchange.setStatusCode(status);
                    for (Map.Entry entry : headers.entrySet()) {
                        exchange.getResponseHeaders().put(new HttpString((String)entry.getKey()), (String)entry.getValue());
                    }
                    exchange.getResponseSender().send(message);
                });
            }
        });
    }

    public void stop(StopContext context) {
        this.metricsContextService.get().setOverrideableMetricHandler(null);
        MicroProfileVendorMetricRegistry.removeAllMetrics();
    }
}

