/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InvalidClassException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ClassResolver;

public class ModuleClassResolver
implements ClassResolver {
    private final ModuleLoader loader;

    public ModuleClassResolver(ModuleLoader loader) {
        this.loader = loader;
    }

    @Override
    public void annotate(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
        Module module = Module.forClass(targetClass);
        AnyField.STRING.writeTo(context, writer, module.getName());
    }

    @Override
    public Class<?> resolve(ImmutableSerializationContext context, RawProtoStreamReader reader, String className) throws IOException {
        String moduleName = (String)AnyField.STRING.cast(String.class).readFrom(context, reader);
        try {
            Module module = this.loader.loadModule(moduleName);
            return module.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            InvalidClassException exception = new InvalidClassException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }
}

