/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.parsing.Element;

public class GlobalSecurityConfiguration
implements ConfigurationInfo {
    private final GlobalAuthorizationConfiguration authorization;
    private final long securityCacheTimeout;
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SECURITY.getLocalName());
    private final List<ConfigurationInfo> subElements;

    GlobalSecurityConfiguration(GlobalAuthorizationConfiguration authorization, long securityCacheTimeout) {
        this.authorization = authorization;
        this.securityCacheTimeout = securityCacheTimeout;
        this.subElements = Collections.singletonList(authorization);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public GlobalAuthorizationConfiguration authorization() {
        return this.authorization;
    }

    public long securityCacheTimeout() {
        return this.securityCacheTimeout;
    }

    public String toString() {
        return "GlobalSecurityConfiguration [authorization=" + this.authorization + ", securityCacheTimeout=" + this.securityCacheTimeout + "]";
    }
}

