/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.common;

import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public abstract class CommonLoginModule
extends AbstractServerLoginModule {
    private Principal identity;
    private char[] credential;

    protected Principal getIdentity() {
        return this.identity;
    }

    protected void setIdentity(Principal identity) {
        this.identity = identity;
    }

    protected char[] getCredential() {
        return this.credential;
    }

    protected void processIdentityAndCredential() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Failed to create principal", (Throwable)e);
                    }
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
        } else {
            try {
                NameCallback nc = new NameCallback("User name: ", "guest");
                PasswordCallback pc = new PasswordCallback("Password: ", false);
                Callback[] callbacks = new Callback[]{nc, pc};
                this.callbackHandler.handle(callbacks);
                String username = nc.getName();
                this.identity = this.createIdentity(username);
                this.credential = pc.getPassword();
                pc.clearPassword();
            }
            catch (Exception e) {
                LoginException le = new LoginException("Unable to obtain username/credential");
                le.initCause(e);
                throw le;
            }
        }
    }
}

