/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.Signal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelPoolCloseEvent;
import org.infinispan.client.hotrod.impl.transport.netty.HintedReplayingDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.Util;

public class HeaderDecoder
extends HintedReplayingDecoder<State> {
    private static final Log log = LogFactory.getLog(HeaderDecoder.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final String NAME = "header-decoder";
    private final Codec codec;
    private final ChannelFactory channelFactory;
    private final Configuration configuration;
    private final ClientListenerNotifier listenerNotifier;
    private final ConcurrentMap<Long, HotRodOperation<?>> incomplete = new ConcurrentHashMap();
    private final List<byte[]> listeners = new ArrayList<byte[]>();
    private volatile boolean closing;
    private HotRodOperation<?> operation;
    private short status;
    private short receivedOpCode;

    public HeaderDecoder(Codec codec, ChannelFactory channelFactory, Configuration configuration, ClientListenerNotifier listenerNotifier) {
        super(State.READ_MESSAGE_ID);
        this.codec = codec;
        this.channelFactory = channelFactory;
        this.configuration = configuration;
        this.listenerNotifier = listenerNotifier;
    }

    public boolean isSharable() {
        return false;
    }

    public void registerOperation(Channel channel, HotRodOperation<?> operation) {
        if (trace) {
            log.tracef("Registering operation %s(%08X) with id %d on %s", new Object[]{operation, System.identityHashCode(operation), operation.header().messageId(), channel});
        }
        if (this.closing) {
            throw Log.HOTROD.noMoreOperationsAllowed();
        }
        HotRodOperation<?> prev = this.incomplete.put(operation.header().messageId(), operation);
        assert (prev == null) : "Already registered: " + prev + ", new: " + operation;
        operation.scheduleTimeout(channel);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        try {
            switch ((State)((Object)this.state())) {
                case READ_MESSAGE_ID: {
                    long messageId = this.codec.readMessageId(in);
                    this.receivedOpCode = this.codec.readOpCode(in);
                    switch (this.receivedOpCode) {
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: {
                            if (this.codec.allowOperationsAndEvents()) {
                                this.operation = messageId == 0L ? null : (HotRodOperation)this.incomplete.get(messageId);
                            } else if (this.incomplete.size() == 1) {
                                this.operation = (HotRodOperation)this.incomplete.values().iterator().next();
                                messageId = this.operation.header().messageId();
                            } else {
                                if (this.incomplete.size() > 1) {
                                    throw new IllegalStateException("Too many incomplete operations: " + this.incomplete);
                                }
                                this.operation = null;
                                messageId = 0L;
                            }
                            if (this.operation != null && !(this.operation instanceof AddClientListenerOperation)) {
                                throw Log.HOTROD.operationIsNotAddClientListener(messageId, this.operation.toString());
                            }
                            if (trace) {
                                log.tracef("Received event for request %d", messageId, this.operation);
                            }
                            this.checkpoint(State.READ_CACHE_EVENT);
                            return;
                        }
                        case 102: {
                            this.checkpoint(State.READ_COUNTER_EVENT);
                            return;
                        }
                    }
                    if (messageId == 0L) {
                        this.codec.readHeader(in, this.receivedOpCode, null, this.channelFactory, ctx.channel().remoteAddress());
                        throw new IllegalStateException("Should be never reached");
                    }
                    this.operation = (HotRodOperation)this.incomplete.remove(messageId);
                    if (this.operation == null) {
                        throw Log.HOTROD.unknownMessageId(messageId);
                    }
                    if (trace) {
                        log.tracef("Received response for request %d, %s", messageId, this.operation);
                    }
                    this.checkpoint(State.READ_HEADER);
                }
                case READ_HEADER: {
                    if (trace) {
                        log.tracef("Decoding header for message %s", HotRodConstants.Names.of(this.receivedOpCode));
                    }
                    this.status = this.codec.readHeader(in, this.receivedOpCode, this.operation.header(), this.channelFactory, ctx.channel().remoteAddress());
                    this.checkpoint(State.READ_PAYLOAD);
                }
                case READ_PAYLOAD: {
                    if (trace) {
                        log.tracef("Decoding payload for message %s", HotRodConstants.Names.of(this.receivedOpCode));
                    }
                    this.operation.acceptResponse(in, this.status, this);
                    this.checkpoint(State.READ_MESSAGE_ID);
                    break;
                }
                case READ_CACHE_EVENT: {
                    AbstractClientEvent cacheEvent;
                    if (trace) {
                        log.tracef("Decoding cache event %s", HotRodConstants.Names.of(this.receivedOpCode));
                    }
                    try {
                        cacheEvent = this.codec.readCacheEvent(in, this.listenerNotifier::getCacheDataFormat, this.receivedOpCode, this.configuration.getClassWhiteList(), ctx.channel().remoteAddress());
                    }
                    catch (Signal signal) {
                        throw signal;
                    }
                    catch (Throwable t) {
                        log.unableToReadEventFromServer(t, ctx.channel().remoteAddress());
                        throw t;
                    }
                    if (this.operation != null) {
                        ((AddClientListenerOperation)this.operation).postponeTimeout(ctx.channel());
                    }
                    this.invokeEvent(cacheEvent.getListenerId(), cacheEvent);
                    this.checkpoint(State.READ_MESSAGE_ID);
                    break;
                }
                case READ_COUNTER_EVENT: {
                    HotRodCounterEvent counterEvent;
                    if (trace) {
                        log.tracef("Decoding counter event %s", HotRodConstants.Names.of(this.receivedOpCode));
                    }
                    try {
                        counterEvent = this.codec.readCounterEvent(in);
                    }
                    catch (Signal signal) {
                        throw signal;
                    }
                    catch (Throwable t) {
                        Log.HOTROD.unableToReadEventFromServer(t, ctx.channel().remoteAddress());
                        throw t;
                    }
                    this.invokeEvent(counterEvent.getListenerId(), counterEvent);
                    this.checkpoint(State.READ_MESSAGE_ID);
                }
            }
        }
        catch (Signal signal) {
            throw signal;
        }
        catch (Exception e) {
            this.checkpoint(State.READ_MESSAGE_ID);
            throw e;
        }
    }

    private void invokeEvent(byte[] listenerId, Object cacheEvent) {
        try {
            this.listenerNotifier.invokeEvent(listenerId, cacheEvent);
        }
        catch (Exception e) {
            Log.HOTROD.unexpectedErrorConsumingEvent(cacheEvent, e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.operation != null) {
            this.operation.exceptionCaught(ctx.channel(), cause);
        } else {
            TransportException transportException = log.errorFromUnknownOperation(ctx.channel(), cause, ctx.channel().remoteAddress());
            for (HotRodOperation op : this.incomplete.values()) {
                try {
                    op.exceptionCaught(ctx.channel(), transportException);
                }
                catch (Throwable t) {
                    Log.HOTROD.errorf(t, "Failed to complete %s", op);
                }
            }
            if (trace) {
                log.tracef(cause, "Requesting %s close due to exception", ctx.channel());
            }
            ctx.close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        for (HotRodOperation op : this.incomplete.values()) {
            try {
                op.channelInactive(ctx.channel());
            }
            catch (Throwable t) {
                Log.HOTROD.errorf(t, "Failed to complete %s", op);
            }
        }
        this.failoverClientListeners();
    }

    public void failoverClientListeners() {
        for (byte[] listenerId : this.listeners) {
            this.listenerNotifier.failoverClientListener(listenerId);
        }
    }

    public CompletableFuture<Void> allCompleteFuture() {
        return CompletableFuture.allOf(this.incomplete.values().toArray(new CompletableFuture[0]));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof ChannelPoolCloseEvent) {
            this.closing = true;
            this.allCompleteFuture().whenComplete((nil, throwable) -> ctx.channel().close());
        } else if (evt instanceof IdleStateEvent && !this.incomplete.isEmpty()) {
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    @Override
    public void checkpoint() {
        super.checkpoint();
    }

    public int registeredOperations() {
        return this.incomplete.size();
    }

    public void addListener(byte[] listenerId) {
        if (trace) {
            log.tracef("Decoder %08X adding listener %s", ((Object)((Object)this)).hashCode(), Util.printArray((byte[])listenerId));
        }
        this.listeners.add(listenerId);
    }

    public void removeListener(byte[] listenerId) {
        boolean removed = this.listeners.removeIf(id -> Arrays.equals(id, listenerId));
        if (trace) {
            log.tracef("Decoder %08X removed? %s listener %s", ((Object)((Object)this)).hashCode(), Boolean.toString(removed), Util.printArray((byte[])listenerId));
        }
    }

    static enum State {
        READ_MESSAGE_ID,
        READ_HEADER,
        READ_PAYLOAD,
        READ_CACHE_EVENT,
        READ_COUNTER_EVENT;

    }
}

