/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

abstract class AbstractPlatformMBeanAttributeHandler
implements OperationStepHandler {
    private final ParametersValidator readAttributeValidator = new ParametersValidator();
    final ParametersValidator writeAttributeValidator = new ParametersValidator();

    protected AbstractPlatformMBeanAttributeHandler() {
        this.readAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.writeAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String op = operation.require("operation").asString();
        if ("read-attribute".equals(op)) {
            this.readAttributeValidator.validate(operation);
            context.addStep(this::executeReadAttribute, OperationContext.Stage.RUNTIME);
        } else if ("write-attribute".equals(op)) {
            this.writeAttributeValidator.validate(operation);
            context.addStep(this::executeWriteAttribute, OperationContext.Stage.RUNTIME);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected abstract void executeReadAttribute(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected abstract void executeWriteAttribute(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected static OperationFailedException unknownAttribute(ModelNode operation) {
        return PlatformMBeanLogger.ROOT_LOGGER.unknownAttribute(operation.require("name").asString());
    }
}

