/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class RedirectBypassInterceptor
implements Interceptor {
    private final String appBaseUrl;
    private final String bypassUrl;

    public RedirectBypassInterceptor(String appBaseUrl, String bypassUrl) {
        this.appBaseUrl = appBaseUrl;
        this.bypassUrl = bypassUrl;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String originalLocation;
        String newUrl;
        Response originalResponse = chain.proceed(chain.request());
        if (originalResponse.isRedirect() && null != (newUrl = RedirectBypassInterceptor.remapUrl(originalLocation = originalResponse.header("location"), this.bypassUrl, this.appBaseUrl))) {
            return originalResponse.newBuilder().header("Location", newUrl).build();
        }
        return originalResponse;
    }

    public static String remapUrl(String origUrl, String bypassUrl, String appBaseUrl) {
        if (origUrl.startsWith(bypassUrl)) {
            return appBaseUrl + origUrl.substring(bypassUrl.length());
        }
        return null;
    }
}

