/*
 * Decompiled with CFR 0.152.
 */
package JTrrntzip;

import JTrrntzip.LogCallback;
import JTrrntzip.SupportedFiles.ICompress;
import JTrrntzip.SupportedFiles.ZipFile.ZipFile;
import JTrrntzip.TrrntZipStatus;
import JTrrntzip.ZipReturn;
import JTrrntzip.ZippedFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.FilenameUtils;

public final class TorrentZipRebuild {
    public static final EnumSet<TrrntZipStatus> ReZipFiles(List<ZippedFile> zippedFiles, ICompress originalZipFile, byte[] buffer, LogCallback LogCallback2) {
        int bufferSize = buffer.length;
        File filename = new File(originalZipFile.ZipFilename());
        File tmpFilename = new File(filename.getParentFile(), FilenameUtils.getBaseName(filename.getName()) + ".tmp");
        File outfilename = new File(filename.getParentFile(), FilenameUtils.getBaseName(filename.getName()) + ".zip");
        if (tmpFilename.exists()) {
            tmpFilename.delete();
        }
        ZipFile zipFileOut = new ZipFile();
        try {
            zipFileOut.ZipFileCreate(tmpFilename);
            for (int i = 0; i < zippedFiles.size(); ++i) {
                long crc;
                LogCallback2.StatusCallBack((int)((double)(i + 1) / (double)zippedFiles.size() * 100.0));
                ZippedFile t2 = zippedFiles.get(i);
                if (LogCallback2.isVerboseLogging()) {
                    LogCallback2.StatusLogCallBack(String.format("%15s %s %s", t2.Size, t2.toString(), t2.Name));
                }
                AtomicReference<InputStream> readStream = new AtomicReference<InputStream>();
                AtomicReference<BigInteger> streamSize = new AtomicReference<BigInteger>();
                AtomicInteger compMethod = new AtomicInteger();
                ZipReturn zrInput = ZipReturn.ZipUntested;
                ZipFile z = null;
                if (originalZipFile instanceof ZipFile && (z = (ZipFile)originalZipFile) != null) {
                    zrInput = z.ZipFileOpenReadStream(t2.Index, false, readStream, streamSize, compMethod);
                }
                AtomicReference<OutputStream> writeStream = new AtomicReference<OutputStream>();
                ZipReturn zrOutput = zipFileOut.ZipFileOpenWriteStream(false, true, t2.Name, (BigInteger)streamSize.get(), (short)8, writeStream);
                if (zrInput != ZipReturn.ZipGood || zrOutput != ZipReturn.ZipGood) {
                    zipFileOut.ZipFileClose();
                    zipFileOut.close();
                    originalZipFile.ZipFileClose();
                    tmpFilename.delete();
                    return EnumSet.of(TrrntZipStatus.CorruptZip);
                }
                CheckedInputStream crcCs = new CheckedInputStream(readStream.get(), new CRC32());
                BufferedInputStream bcrcCs = new BufferedInputStream(crcCs, buffer.length);
                BufferedOutputStream bWriteStream = new BufferedOutputStream(writeStream.get(), buffer.length);
                BigInteger sizetogo = streamSize.get();
                while (sizetogo.compareTo(BigInteger.valueOf(0L)) > 0) {
                    int sizenow = sizetogo.compareTo(BigInteger.valueOf(bufferSize)) > 0 ? bufferSize : sizetogo.intValue();
                    bcrcCs.read(buffer, 0, sizenow);
                    bWriteStream.write(buffer, 0, sizenow);
                    sizetogo = sizetogo.subtract(BigInteger.valueOf(sizenow));
                }
                bWriteStream.flush();
                if (writeStream.get() instanceof DeflaterOutputStream) {
                    ((DeflaterOutputStream)writeStream.get()).finish();
                }
                if (z != null) {
                    originalZipFile.ZipFileCloseReadStream();
                }
                if ((int)(crc = crcCs.getChecksum().getValue()) != t2.CRC) {
                    return EnumSet.of(TrrntZipStatus.CorruptZip);
                }
                zipFileOut.ZipFileCloseWriteStream(t2.getCRC());
            }
            zipFileOut.ZipFileClose();
            zipFileOut.close();
            originalZipFile.ZipFileClose();
            originalZipFile.close();
            if (!filename.equals(outfilename)) {
                filename.delete();
            }
            Files.copy(tmpFilename.toPath(), outfilename.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            tmpFilename.delete();
            return EnumSet.of(TrrntZipStatus.ValidTrrntzip);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Optional.ofNullable(zipFileOut).ifPresent(t -> {
                try {
                    t.ZipFileCloseFailed();
                    t.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
            Optional.ofNullable(originalZipFile).ifPresent(t -> {
                try {
                    t.ZipFileClose();
                    t.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
            return EnumSet.of(TrrntZipStatus.CorruptZip);
        }
    }
}

