/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.Iterator;
import jrm.compressors.SevenZipArchive;
import jrm.compressors.ZipArchive;
import jrm.compressors.zipfs.ZipFileSystemProvider;
import jrm.compressors.zipfs.ZipLevel;
import jrm.compressors.zipfs.ZipTempThreshold;
import jrm.locale.Messages;
import jrm.misc.Settings;
import jrm.profile.data.Container;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.fix.actions.EntryAction;
import jrm.profile.scan.options.FormatOptions;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.text.StringEscapeUtils;

public class CreateContainer
extends ContainerAction {
    private final long dataSize;

    public CreateContainer(Container container, FormatOptions format, long dataSize) {
        super(container, format);
        this.dataSize = dataSize;
    }

    public static CreateContainer getInstance(CreateContainer action, Container container, FormatOptions format, long dataSize) {
        if (action == null) {
            action = new CreateContainer(container, format, dataSize);
        }
        return action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doAction(ProgressHandler handler) {
        handler.setProgress(this.toHTML(this.toNoBR(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("CreateContainer.Creating")), this.toBlue(this.container.m.getFullName(this.container.file.getName())), this.toPurple(this.container.m.getDescription())))));
        if (this.container.getType() == Container.Type.ZIP) {
            if (this.format == FormatOptions.ZIP || this.format == FormatOptions.TZIP) {
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("create", "true");
                env.put("useTempFile", this.dataSize > ZipTempThreshold.valueOf(Settings.getProperty("zip_temp_threshold", ZipTempThreshold._10MB.toString())).getThreshold());
                env.put("compressionLevel", this.format == FormatOptions.TZIP ? 1 : ZipLevel.valueOf(Settings.getProperty("zip_compression_level", ZipLevel.DEFAULT.toString())).getLevel());
                this.container.file.getParentFile().mkdirs();
                try (FileSystem fs = new ZipFileSystemProvider().newFileSystem(URI.create("zip:" + this.container.file.toURI()), env);){
                    int i2 = 0;
                    for (EntryAction action : this.entry_actions) {
                        if (action.doAction(fs, handler, ++i2, this.entry_actions.size())) continue;
                        System.err.println("action to " + this.container.file.getName() + "@" + action.entry.file + " failed");
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (this.format != FormatOptions.ZIPE) return false;
            this.container.file.getParentFile().mkdirs();
            try (ZipArchive archive = new ZipArchive(this.container.file);){
                int i = 0;
                for (EntryAction action : this.entry_actions) {
                    if (action.doAction(archive, handler, ++i, this.entry_actions.size())) continue;
                    System.err.println("action to " + this.container.file.getName() + "@" + action.entry.file + " failed");
                    boolean bl = false;
                    return bl;
                }
                boolean i2 = true;
                return i2;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.container.getType() == Container.Type.SEVENZIP) {
            this.container.file.getParentFile().mkdirs();
            try (SevenZipArchive archive = new SevenZipArchive(this.container.file);){
                int i = 0;
                for (EntryAction action : this.entry_actions) {
                    if (action.doAction(archive, handler, ++i, this.entry_actions.size())) continue;
                    System.err.println("action to " + this.container.file.getName() + "@" + action.entry.file + " failed");
                    boolean bl = false;
                    return bl;
                }
                boolean i2 = true;
                return i2;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.container.getType() != Container.Type.DIR) return false;
        try {
            EntryAction action;
            Path target = this.container.file.toPath();
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                Files.createDirectories(target, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x")));
            } else {
                Files.createDirectories(target, new FileAttribute[0]);
            }
            int i = 0;
            Iterator iterator = this.entry_actions.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while ((action = (EntryAction)iterator.next()).doAction(target, handler, ++i, this.entry_actions.size()));
            System.err.println("action to " + this.container.file.getName() + "@" + action.entry.file + " failed");
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public String toString() {
        String str = Messages.getString("CreateContainer.Create") + this.container;
        for (EntryAction action : this.entry_actions) {
            str = str + "\n\t" + action;
        }
        return str;
    }
}

