/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jrm.ui.basic.JFileDropMode;

public class JFileDropTextField
extends JTextField
implements FocusListener,
DropTargetListener {
    private final Color color;
    private final SetCallBack callback;
    private JFileDropMode mode = JFileDropMode.FILE;
    private FilenameFilter filter = null;

    public JFileDropTextField(SetCallBack callback) throws HeadlessException {
        this(null, "", 0, callback);
    }

    public JFileDropTextField(String text, SetCallBack callback) throws HeadlessException {
        this(null, text, 0, callback);
    }

    public JFileDropTextField(int columns, SetCallBack callback) throws HeadlessException {
        this(null, "", columns, callback);
    }

    public JFileDropTextField(String text, int columns, SetCallBack callback) throws HeadlessException {
        this(null, "", columns, callback);
    }

    public JFileDropTextField(Document doc, String text, int columns, SetCallBack callback) {
        super(doc, text, columns);
        this.callback = callback;
        this.color = this.getBackground();
        this.addFocusListener(this);
        new DropTarget(this, this);
    }

    public void setMode(JFileDropMode mode) {
        this.mode = mode;
    }

    public void setFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.callback != null) {
            this.callback.call(this.getText());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            this.setBackground(Color.decode("#DDFFDD"));
            dtde.acceptDrag(1);
        } else {
            this.setBackground(Color.decode("#FFDDDD"));
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setBackground(this.color);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.setBackground(this.color);
        try {
            Transferable transferable = dtde.getTransferable();
            if (this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                List files = ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().filter(f -> {
                    if (this.mode == JFileDropMode.DIRECTORY && !f.isDirectory()) {
                        return false;
                    }
                    if (this.mode == JFileDropMode.FILE && !f.isFile()) {
                        return false;
                    }
                    if (this.filter != null) {
                        return this.filter.accept(f.getParentFile(), f.getName());
                    }
                    return true;
                }).collect(Collectors.toList());
                if (files.size() == 1) {
                    this.setText(((File)files.get(0)).getAbsolutePath());
                    this.callback.call(this.getText());
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException e) {
            dtde.rejectDrop();
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    @FunctionalInterface
    public static interface SetCallBack {
        public void call(String var1);
    }
}

