/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import jrm.locale.Messages;

public class JRMFileChooser<V>
extends JFileChooser {
    public JRMFileChooser() {
        this(null, null, null, null, null, null, false);
    }

    public JRMFileChooser(int type, int mode) {
        this(type, mode, null, null, null, null, false);
    }

    public JRMFileChooser(int type, int mode, File currdir) {
        this(type, mode, currdir, null, null, null, false);
    }

    public JRMFileChooser(Integer type, Integer mode, File currdir, File selected, List<FileFilter> filters, String title, boolean multi) {
        this.setup(type, mode, currdir, selected, filters, title, multi);
    }

    public JRMFileChooser<V> setup(Integer type, Integer mode, File currdir, File selected, List<FileFilter> filters, String title, boolean multi) {
        if (type != null) {
            this.setDialogType(type);
        }
        if (mode != null) {
            this.setFileSelectionMode(mode);
        }
        if (selected != null) {
            this.setSelectedFile(selected);
        }
        if (currdir != null && currdir.exists()) {
            if (currdir.isFile()) {
                this.setSelectedFile(currdir);
            } else {
                this.setCurrentDirectory(currdir);
            }
        }
        if (filters != null) {
            if (filters.size() == 1) {
                this.setFileFilter(filters.get(0));
                this.setAcceptAllFileFilterUsed(false);
            } else {
                for (FileFilter filter : filters) {
                    this.addChoosableFileFilter(filter);
                    this.setAcceptAllFileFilterUsed(false);
                }
            }
        }
        if (title != null) {
            this.setDialogTitle(title);
        }
        if (multi) {
            this.setMultiSelectionEnabled(multi);
        }
        return this;
    }

    public JRMFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public V show(Component parent, CallBack<V> callback) {
        if (this.showOpenDialog(parent) == 0) {
            return callback.call(this);
        }
        return null;
    }

    public V showOpen(Component parent, CallBack<V> callback) {
        this.setDialogType(0);
        return this.show(parent, callback);
    }

    public V showSave(Component parent, CallBack<V> callback) {
        this.setDialogType(1);
        return this.show(parent, callback);
    }

    public static interface CallBack<V> {
        public V call(JRMFileChooser<V> var1);
    }

    public static class OneRootFileSystemView
    extends FileSystemView {
        File root;
        File[] roots = new File[1];

        public OneRootFileSystemView(File root) {
            try {
                this.roots[0] = this.root = root.getCanonicalFile();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, e1, "Exception", 0);
                e1.printStackTrace();
            }
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            File folder = new File(containingDir, Messages.getString("JRMFileChooser.NewFolder"));
            folder.mkdir();
            return folder;
        }

        @Override
        public File getDefaultDirectory() {
            return this.root;
        }

        @Override
        public File getHomeDirectory() {
            return this.root;
        }

        @Override
        public File[] getRoots() {
            return this.roots;
        }
    }
}

