/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.filter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import jrm.locale.Messages;
import jrm.ui.profile.ProfileViewer;

public class KeywordFilter
extends JDialog {
    private JList<String> KWSrc;
    private JList<String> KWDst;
    private DefaultListModel<String> dstmodel = new DefaultListModel();

    public KeywordFilter(Window owner, String[] src, final CallBack callback) {
        super(owner, Messages.getString("KeywordFilter.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ProfileViewer.class.getResource("/jrm/resources/rom.png")));
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{217, 217, 0};
        gbl_panel.rowHeights = new int[]{23, 0};
        gbl_panel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JButton btnCancel = new JButton(Messages.getString("KeywordFilter.Cancel"));
        btnCancel.addActionListener(e -> this.dispose());
        btnCancel.setHorizontalAlignment(10);
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.anchor = 17;
        gbc_btnCancel.fill = 3;
        gbc_btnCancel.insets = new Insets(5, 5, 5, 5);
        gbc_btnCancel.gridx = 0;
        gbc_btnCancel.gridy = 0;
        panel.add((Component)btnCancel, gbc_btnCancel);
        JButton btnFilter = new JButton(Messages.getString("KeywordFilter.Filter"));
        btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                callback.call(KeywordFilter.this);
                KeywordFilter.this.dispose();
            }
        });
        btnFilter.setHorizontalAlignment(11);
        GridBagConstraints gbc_btnFilter = new GridBagConstraints();
        gbc_btnFilter.insets = new Insets(5, 5, 5, 5);
        gbc_btnFilter.anchor = 13;
        gbc_btnFilter.fill = 3;
        gbc_btnFilter.gridx = 1;
        gbc_btnFilter.gridy = 0;
        panel.add((Component)btnFilter, gbc_btnFilter);
        JSplitPane KWSplitPane = new JSplitPane();
        KWSplitPane.setResizeWeight(0.5);
        KWSplitPane.setOneTouchExpandable(true);
        KWSplitPane.setContinuousLayout(true);
        this.getContentPane().add((Component)KWSplitPane, "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new TitledBorder(null, Messages.getString("KeywordFilter.Available"), 4, 2, null, new Color(0, 0, 0)));
        KWSplitPane.setLeftComponent(scrollPane);
        this.KWSrc = new JList();
        this.KWSrc.setVisibleRowCount(16);
        scrollPane.setViewportView(this.KWSrc);
        this.KWSrc.setDragEnabled(true);
        this.KWSrc.setDropMode(DropMode.INSERT);
        StringMoveHandler.createFor(this.KWSrc);
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String s : src) {
            model.addElement(s);
        }
        this.KWSrc.setModel(model);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBorder(new TitledBorder(null, Messages.getString("KeywordFilter.Used"), 4, 2, null, new Color(0, 0, 0)));
        KWSplitPane.setRightComponent(scrollPane_1);
        this.KWDst = new JList();
        this.KWDst.setVisibleRowCount(16);
        scrollPane_1.setViewportView(this.KWDst);
        this.KWDst.setDragEnabled(true);
        this.KWDst.setDropMode(DropMode.INSERT);
        StringMoveHandler.createFor(this.KWDst);
        this.KWDst.setModel(this.dstmodel);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public ArrayList<String> getFilter() {
        return Collections.list(this.dstmodel.elements());
    }

    private static class StringMoveHandler
    extends TransferHandler {
        private DataFlavor objectArrayFlavor = new ActivationDataFlavor(Object[].class, "application/x-java-jvm-local-objectref", "Array of items");
        private JList<String> list;

        private StringMoveHandler() {
        }

        public static StringMoveHandler createFor(JList<String> list) {
            StringMoveHandler handler = new StringMoveHandler();
            list.setTransferHandler(handler);
            handler.list = list;
            return handler;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(this.objectArrayFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Transferable t = transferSupport.getTransferable();
            boolean success = false;
            try {
                Object[] importedData = (Object[])t.getTransferData(this.objectArrayFlavor);
                this.addToListModel(importedData);
                success = true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
            return success;
        }

        private void addToListModel(Object[] importedData) {
            JList.DropLocation loc = this.list.getDropLocation();
            int dropIndex = loc.getIndex();
            DefaultListModel listModel = (DefaultListModel)this.list.getModel();
            for (int i = 0; i < importedData.length; ++i) {
                Object elem = importedData[i];
                if (elem instanceof String) {
                    listModel.add(dropIndex + i, (String)elem);
                    continue;
                }
                System.err.println("Imported data contained something else than strings: " + elem);
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent source) {
            Object[] valuesToTransfer = this.list.getSelectedValues();
            return new DataHandler((Object)valuesToTransfer, this.objectArrayFlavor.getMimeType());
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                try {
                    Object[] exportedData = (Object[])data.getTransferData(this.objectArrayFlavor);
                    this.removeFromListModel(exportedData);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void removeFromListModel(Object[] dataToRemove) {
            DefaultListModel listModel = (DefaultListModel)this.list.getModel();
            for (Object elemToRemove : dataToRemove) {
                boolean removedSuccessfully = listModel.removeElement(elemToRemove);
                if (removedSuccessfully) continue;
                System.err.println("Source model did not contain exported data");
            }
        }
    }

    public static interface CallBack {
        public void call(KeywordFilter var1);
    }
}

