/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.component;

import com.jgoodies.app.gui.basics.AppResources;
import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.application.Actions;
import com.jgoodies.application.Application;
import com.jgoodies.sandbox.util.AbstractOpenMonthViewPopupAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.SortedSet;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXMonthView;

public final class OpenMonthViewPopupAction
extends AbstractOpenMonthViewPopupAction {
    private JXMonthView monthView;

    public OpenMonthViewPopupAction(JFormattedTextField textField) {
        super(textField);
    }

    @Override
    protected void configurePopup(JPopupMenu popup) {
        popup.setBackground(this.monthView.getBackground());
        popup.add((Component)this.monthView);
    }

    @Override
    protected void configureAction() {
        Actions.configure(this, Application.getResourceMap(AppResources.class), "jgoodies.app.monthViewPopup");
    }

    @Override
    protected void initMonthView() {
        this.monthView = new JXMonthView();
        this.monthView.setShowingWeekNumber(true);
        this.monthView.setFirstDayOfWeek(2);
        this.monthView.getSelectionModel().setMinimalDaysInFirstWeek(4);
        this.monthView.setShowingWeekNumber(false);
        this.monthView.setMonthStringBackground(Color.GRAY);
        this.monthView.setMonthStringForeground(Color.WHITE);
        this.monthView.setTraversable(true);
        this.monthView.addActionListener((ActionListener)this.getHandler());
        this.monthView.addFocusListener((FocusListener)this.getHandler());
    }

    @Override
    protected void initializeSelection() {
        super.initializeSelection();
        if (this.monthView.isSelectionEmpty()) {
            this.setToday();
        }
    }

    @Override
    protected Date getDate() {
        SortedSet selection = this.monthView.getSelection();
        return selection.isEmpty() ? null : (Date)selection.first();
    }

    @Override
    protected void setDate(Date date) {
        this.monthView.setSelectionInterval(date, date);
        this.monthView.ensureDateVisible(date);
    }

    @Override
    protected void cleanup() {
        this.monthView.removeActionListener((ActionListener)this.getHandler());
        this.monthView.removeFocusListener((FocusListener)this.getHandler());
        this.monthView = null;
        super.cleanup();
    }

    @Override
    protected void postVisible() {
        this.monthView.requestFocusInWindow();
    }

    static {
        UIManager.put("JXMonthView.monthDownFileName", WindowsIcon.CHEVRON_LEFT.toIcon(12));
        UIManager.put("JXMonthView.monthUpFileName", WindowsIcon.CHEVRON_RIGHT.toIcon(12));
    }
}

