/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.resources;

import com.jgoodies.app.gui.basics.WindowsAccentColors;
import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.design.basics.ValueState;
import com.jgoodies.design.content.object_header.ObjectHeader;
import com.jgoodies.design.content.object_list.ListViewStyle;
import com.jgoodies.design.resources.DesignResources;
import com.jgoodies.design.resources.IDesignResources;
import com.jgoodies.layout.factories.Paddings;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIManager;

public final class WindowsDesignResources
implements IDesignResources {
    private static Font formSubsectionTitleFont;
    private static Font formGroupTitleFont;
    private static Color listReportHeaderBackground;
    private static Font listReportHeaderContentFont;
    private static Font objectHeaderTitleFontSmall;
    private static Font objectHeaderTitleFontMedium;
    private static Font objectHeaderSubtitleFontSmall;
    private static Font objectHeaderSubtitleFontMedium;
    private static Font objectHeaderOverlineFontSmall;
    private static Font objectHeaderOverlineFontMedium;
    private static Icon chevronDownIcon;
    private static Icon chevronUpIcon;
    private static Font instructionFont;
    private static Color instructionForeground;
    private static Font keyCaptionFont;
    private static Font listItemPrimaryFontSmall;
    private static Font listItemPrimaryFontMedium;
    private static Color listItemPrimaryForegroundSmall;
    private static Color listItemPrimaryForegroundMedium;
    private static Font listItemSecondaryFontSmall;
    private static Font listItemSecondaryFontMedium;
    private static Color listItemSecondaryForegroundSmall;
    private static Color listItemSecondaryForegroundMedium;
    private static Paddings.Padding listItemPadding;
    private static Font bodyLargeFont;
    private static Font bodyStrongFont;

    public static void install() {
        DesignResources.setInstance((IDesignResources)new WindowsDesignResources());
    }

    private static void setup() {
        bodyLargeFont = UIManager.getFont("jgoodies-fluent.bodyLarge.font");
        bodyStrongFont = UIManager.getFont("jgoodies-fluent.bodyStrong.font");
        chevronDownIcon = WindowsIcon.CHEVRON_DOWN_MED.toIcon(12);
        chevronUpIcon = WindowsIcon.CHEVRON_UP_MED.toIcon(12);
        instructionFont = UIManager.getFont("jgoodies-design.InitialPage.instruction.font");
        instructionForeground = UIManager.getColor("jgoodies-design.InitialPage.instruction.foreground");
        keyCaptionFont = UIManager.getFont("jgoodies-design.InitialPage.keyCaption.font");
        listReportHeaderBackground = UIManager.getColor("jgoodies-design.ListReport.header.background");
        listReportHeaderContentFont = UIManager.getFont("jgoodies-design.ListReport.headerContent.font");
        listItemPrimaryFontSmall = UIManager.getFont("jgoodies-design.ListItem.primary.font.small");
        listItemPrimaryFontMedium = UIManager.getFont("jgoodies-design.ListItem.primary.font.medium");
        listItemPrimaryForegroundSmall = UIManager.getColor("jgoodies-design.ListItem.primary.foreground.small");
        listItemPrimaryForegroundMedium = UIManager.getColor("jgoodies-design.ListItem.primary.foreground.medium");
        listItemSecondaryFontSmall = UIManager.getFont("jgoodies-design.ListItem.secondary.font.small");
        listItemSecondaryFontMedium = UIManager.getFont("jgoodies-design.ListItem.secondary.font.medium");
        listItemSecondaryForegroundSmall = UIManager.getColor("jgoodies-design.ListItem.secondary.foreground.small");
        listItemSecondaryForegroundMedium = UIManager.getColor("jgoodies-design.ListItem.secondary.foreground.medium");
        listItemPadding = Paddings.createPadding("6epx, 16epx, 6epx, 8epx", new Object[0]);
        formSubsectionTitleFont = UIManager.getFont("jgoodies-design.Form.subsection.title.font");
        formGroupTitleFont = UIManager.getFont("jgoodies-design.Form.group.title.font");
        objectHeaderTitleFontSmall = UIManager.getFont("jgoodies-design.ObjectHeader.title.font.small");
        objectHeaderTitleFontMedium = UIManager.getFont("jgoodies-design.ObjectHeader.title.font.medium");
        objectHeaderSubtitleFontSmall = UIManager.getFont("jgoodies-design.ObjectHeader.subtitle.font.small");
        objectHeaderSubtitleFontMedium = UIManager.getFont("jgoodies-design.ObjectHeader.subtitle.font.medium");
        objectHeaderOverlineFontSmall = UIManager.getFont("jgoodies-design.ObjectHeader.overline.font.small");
        objectHeaderOverlineFontMedium = UIManager.getFont("jgoodies-design.ObjectHeader.overline.font.medium");
    }

    protected WindowsDesignResources() {
    }

    public Icon getCollapseHeaderIcon() {
        return chevronUpIcon;
    }

    public Icon getExpandHeaderIcon() {
        return chevronDownIcon;
    }

    public Color getLinkForeground() {
        return new Color(0, 102, 204);
    }

    public Color toColor(ValueState state) {
        switch (state) {
            case ERROR: {
                return WindowsAccentColors.RED1;
            }
            case WARNING: {
                return WindowsAccentColors.YELLOW1;
            }
            case SUCCESS: {
                return WindowsAccentColors.GREEN1;
            }
            case NONE: {
                return new Color(51, 51, 51);
            }
        }
        throw new IllegalStateException("Unknown state " + state);
    }

    public Font getFormSubsectionTitleFont() {
        return formSubsectionTitleFont != null ? formSubsectionTitleFont : bodyLargeFont;
    }

    public Font getFormGroupTitleFont() {
        return formGroupTitleFont != null ? formGroupTitleFont : bodyStrongFont;
    }

    public Font getObjectHeaderTitleFont(ObjectHeader.HeaderStyle style) {
        return style == ObjectHeader.HeaderStyle.SMALL ? objectHeaderTitleFontSmall : objectHeaderTitleFontMedium;
    }

    public Font getObjectHeaderSubtitleFont(ObjectHeader.HeaderStyle style) {
        return style == ObjectHeader.HeaderStyle.SMALL ? objectHeaderSubtitleFontSmall : objectHeaderSubtitleFontMedium;
    }

    public Font getObjectHeaderOverlineFont(ObjectHeader.HeaderStyle style) {
        return style == ObjectHeader.HeaderStyle.SMALL ? objectHeaderOverlineFontSmall : objectHeaderOverlineFontMedium;
    }

    public Font getInitialPageInstructionFont() {
        return instructionFont != null ? instructionFont : bodyStrongFont;
    }

    public Color getInitialPageInstructionForeground() {
        return instructionForeground != null ? instructionForeground : Color.BLACK;
    }

    public Font getInitialPageKeyCaptionFont() {
        return keyCaptionFont != null ? keyCaptionFont : bodyStrongFont;
    }

    public Font getListItemPrimaryFont(ListViewStyle style) {
        return style == ListViewStyle.SMALL ? listItemPrimaryFontSmall : listItemPrimaryFontMedium;
    }

    public Font getListItemSecondaryFont(ListViewStyle style) {
        return style == ListViewStyle.SMALL ? listItemSecondaryFontSmall : listItemSecondaryFontMedium;
    }

    public Color getListItemPrimaryForeground(ListViewStyle style) {
        return style == ListViewStyle.SMALL ? listItemPrimaryForegroundSmall : listItemPrimaryForegroundMedium;
    }

    public Color getListItemSecondaryForeground(ListViewStyle style) {
        return style == ListViewStyle.SMALL ? listItemSecondaryForegroundSmall : listItemSecondaryForegroundMedium;
    }

    public Paddings.Padding getListItemPadding(ListViewStyle style) {
        return listItemPadding;
    }

    public Color getListReportHeaderBackground() {
        return listReportHeaderBackground;
    }

    public Font getListReportHeaderContentFont() {
        return listReportHeaderContentFont;
    }

    static {
        WindowsDesignResources.setup();
    }
}

