/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.regex;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jlibs.core.io.FileUtil;

public class TemplateMatcher {
    private Pattern pattern;

    public TemplateMatcher(String leftBrace, String rightBrace) {
        leftBrace = Pattern.quote(leftBrace);
        rightBrace = Pattern.quote(rightBrace);
        this.pattern = Pattern.compile(leftBrace + "(.*?)" + rightBrace);
    }

    public TemplateMatcher(String prefix) {
        prefix = Pattern.quote(prefix);
        this.pattern = Pattern.compile(prefix + "(\\w*)");
    }

    public String replace(CharSequence input, VariableResolver resolver) {
        StringBuilder buff = new StringBuilder();
        Matcher matcher = this.pattern.matcher(input);
        int cursor = 0;
        while (cursor < input.length() && matcher.find(cursor)) {
            buff.append(input.subSequence(cursor, matcher.start()));
            String value = resolver.resolve(matcher.group(1));
            buff.append(value != null ? value : matcher.group());
            cursor = matcher.end();
        }
        buff.append(input.subSequence(cursor, input.length()));
        return buff.toString();
    }

    public String replace(String input, Map<String, String> variables) {
        return this.replace((CharSequence)input, new MapVariableResolver(variables));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Reader reader, Writer writer, VariableResolver resolver) throws IOException {
        BufferedReader breader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        BufferedWriter bwriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        try {
            String line;
            boolean firstLine = true;
            while ((line = breader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    bwriter.newLine();
                }
                bwriter.write(this.replace((CharSequence)line, resolver));
            }
        }
        finally {
            try {
                breader.close();
            }
            finally {
                bwriter.close();
            }
        }
    }

    public void replace(Reader reader, Writer writer, Map<String, String> variables) throws IOException {
        this.replace(reader, writer, new MapVariableResolver(variables));
    }

    public void copyInto(File source, File targetDir, final VariableResolver resolver) throws IOException {
        FileUtil.copyInto(source, targetDir, new FileUtil.FileCreator(){

            @Override
            public void createFile(File sourceFile, File targetFile) throws IOException {
                TemplateMatcher.this.replace((Reader)new FileReader(sourceFile), (Writer)new FileWriter(targetFile), resolver);
            }

            @Override
            public String translate(String name) {
                return TemplateMatcher.this.replace((CharSequence)name, resolver);
            }
        });
    }

    public void copyInto(File source, File targetDir, Map<String, String> variables) throws IOException {
        this.copyInto(source, targetDir, new MapVariableResolver(variables));
    }

    public static void main(String[] args) {
        System.out.println(new TemplateMatcher("${", "}").replace((CharSequence)"this is ${santhosh}ghgjh\n ${kumar} sdf ${tekuri}abc", new VariableResolver(){

            @Override
            public String resolve(String variable) {
                if (variable.equals("santhosh")) {
                    return null;
                }
                return variable.toUpperCase();
            }
        }));
        System.out.println(new TemplateMatcher("$").replace((CharSequence)"this is $santhosh ghgjh\n $kumar sdf $tekuri\n$ abc", new VariableResolver(){

            @Override
            public String resolve(String variable) {
                return variable.toUpperCase();
            }
        }));
    }

    public static class MapVariableResolver
    implements VariableResolver {
        private Map<String, String> variables;

        public MapVariableResolver(Map<String, String> variables) {
            this.variables = variables;
        }

        @Override
        public String resolve(String variable) {
            return this.variables.get(variable);
        }
    }

    public static interface VariableResolver {
        public String resolve(String var1);
    }
}

