/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import util.LabelData;
import util.PlotData;
import util.SectionData;

class GCanvas
extends Canvas {
    private PlotData locplot;

    public GCanvas(PlotData curplot) {
        this.locplot = curplot;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < this.locplot.m_treePart.size()) {
            SectionData section = this.locplot.m_treePart.get(i);
            this.setStroke(g2D, section.strokewidth);
            int j = 0;
            while (j < section.lines.size()) {
                this.drawLine(g2D, section.lines.get(j));
                ++j;
            }
            j = 0;
            while (j < section.curves.size()) {
                this.drawCubic(g2D, section.curves.get(j));
                ++j;
            }
            j = 0;
            while (j < section.texts.size()) {
                this.showText(g2D, section.texts.get(j), this.locplot.m_plotwidth, this.locplot.m_plotheight);
                ++j;
            }
            ++i;
        }
    }

    public void setStroke(Graphics2D g2D, double width) {
        BasicStroke stroke1 = new BasicStroke((float)width, 1, 1);
        g2D.setStroke(stroke1);
    }

    public void drawLine(Graphics2D g2D, double x1, double y1, double x2, double y2) {
        Line2D.Double line1 = new Line2D.Double(x1, y1, x2, y2);
        g2D.draw(line1);
    }

    public void drawLine(Graphics2D g2D, Line2D.Double line1) {
        g2D.draw(line1);
    }

    public void drawArc(Graphics2D g2D, double x1, double y1, double x2, double y2, double sd, double rd, int cl) {
        Arc2D.Double arc1 = new Arc2D.Double(x1, y1, x2, y2, sd, rd, cl);
        g2D.fill(arc1);
    }

    public void drawEllipse(Graphics2D g2D, double x1, double y1, double x2, double y2) {
        Ellipse2D.Double oval1 = new Ellipse2D.Double(x1, y1, x2, y2);
        g2D.fill(oval1);
    }

    public void drawCubic(Graphics2D g2D, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        CubicCurve2D.Double curve1 = new CubicCurve2D.Double(x1, y1, x2, y2, x3, y3, x4, y4);
        g2D.fill(curve1);
    }

    public void drawCubic(Graphics2D g2D, CubicCurve2D.Double curve1) {
        g2D.draw(curve1);
    }

    public void showText(Graphics2D g2D, LabelData text, int dispWidth, int dispHeight) {
        AffineTransform oldat = g2D.getTransform();
        AffineTransform newat = new AffineTransform();
        newat.translate((int)text.m_translation.x, (int)text.m_translation.y);
        newat.rotate(Math.toRadians(text.m_rotation));
        g2D.setTransform(newat);
        g2D.setFont(text.m_useFont);
        g2D.drawString(text.m_displayText, 0, 0);
        g2D.setTransform(oldat);
    }
}

