/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Square.h"

Square::Square(){
	x=-1;
	y=-1;
}

Square::Square(int a,int b){
	x=a;
	y=b;
}

Square::~Square(void){;}
  
int Square::get_x(){
	return x;
}
  
int Square::get_y(){
	return y;
}
  
void Square::set_x(int a){
	x=a;
}
  
void Square::set_y(int a){
	y=a;
}
  
void Square::set_xy(int a,int b){
	x=a;
	y=b;
}
    
void Square::move(int x_diff,int y_diff){
    int x = get_x();
    int y = get_y();
    set_xy(x+x_diff,y+y_diff);
}

void Square::save_state(FILE *fd, int depth){
	char format[10];
	memset(format,0,10);
	for(int i=0;i<depth;i++)
		format[i] = ' ';
	format[depth-1] = '\0';

	fprintf(fd,"%s<x>%i</x>\n",format,x);
	fprintf(fd,"%s<y>%i</y>\n",format,y);
}

int operator == (Square & s1,Square & s2){
	return ((s1.get_x() == s2.get_x())&&(s1.get_y() == s2.get_y()));
}

