/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.KtBooleanValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirResolvedContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractConstantValues;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBufContractDeserializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0015H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBufContractDeserializer;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "c", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)V", "loadContract", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "owner", "extractType", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression;", "extractVariable", "Lorg/jetbrains/kotlin/contracts/description/KtValueParameterReference;", "valueParameterIndex", "", "loadConstant", "Lorg/jetbrains/kotlin/contracts/description/KtConstantReference;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "getNotNull", "getWildcard", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nFirContractDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractDeserializer.kt\norg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirResolvedContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirResolvedContractDescriptionBuilderKt\n*L\n1#1,85:1\n1563#2:86\n1634#2,3:87\n1563#2:91\n1634#2,3:92\n45#3:90\n*S KotlinDebug\n*F\n+ 1 FirContractDeserializer.kt\norg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer\n*L\n28#1:86\n28#1:87,3\n30#1:91\n30#1:92,3\n29#1:90\n*E\n"})
public final class FirContractDeserializer
extends ProtoBufContractDeserializer<ConeKotlinType, ConeDiagnostic, FirContractDescriptionOwner> {
    @NotNull
    private final FirDeserializationContext c;

    public FirContractDeserializer(@NotNull FirDeserializationContext c2) {
        Intrinsics.checkNotNullParameter(c2, "c");
        this.c = c2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirContractDescription loadContract(@NotNull ProtoBuf.Contract proto, @NotNull FirContractDescriptionOwner owner) {
        void $this$mapTo$iv$iv;
        FirResolvedContractDescriptionBuilder firResolvedContractDescriptionBuilder;
        Iterable it;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(owner, "owner");
        List<ProtoBuf.Effect> list = proto.getEffectList();
        Intrinsics.checkNotNullExpressionValue(list, "getEffectList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ProtoBuf.Effect effect = (ProtoBuf.Effect)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            KtEffectDeclaration ktEffectDeclaration = this.loadPossiblyConditionalEffect((ProtoBuf.Effect)((Object)it), owner);
            if (ktEffectDeclaration == null) {
                return null;
            }
            collection.add(ktEffectDeclaration);
        }
        List effects = (List)destination$iv$iv;
        boolean $i$f$buildResolvedContractDescription = false;
        FirResolvedContractDescriptionBuilder $this$loadContract_u24lambda_u242 = firResolvedContractDescriptionBuilder = new FirResolvedContractDescriptionBuilder();
        boolean bl = false;
        Collection collection = $this$loadContract_u24lambda_u242.getEffects();
        Iterable $this$map$iv2 = effects;
        boolean $i$f$map2 = false;
        it = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            KtEffectDeclaration ktEffectDeclaration = (KtEffectDeclaration)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(ContractUtilsKt.toFirElement$default((KtEffectDeclaration)it2, null, 1, null));
        }
        Iterable iterable2 = (List)destination$iv$iv2;
        CollectionsKt.addAll(collection, iterable2);
        return firResolvedContractDescriptionBuilder.build();
    }

    @Override
    @Nullable
    public ConeKotlinType extractType(@NotNull ProtoBuf.Expression proto) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        ProtoBuf.Type type = ProtoTypeTableUtilKt.isInstanceType(proto, this.c.getTypeTable());
        if (type == null) {
            return null;
        }
        return this.c.getTypeDeserializer().type(type);
    }

    @Override
    @Nullable
    public KtValueParameterReference<ConeKotlinType, ConeDiagnostic> extractVariable(int valueParameterIndex, @NotNull FirContractDescriptionOwner owner) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter(owner, "owner");
        String name2 = null;
        FirSimpleFunction ownerFunction = (FirSimpleFunction)owner;
        int n2 = valueParameterIndex;
        if (n2 == -1) {
            name2 = "this";
            FirReceiverParameter firReceiverParameter = ownerFunction.getReceiverParameter();
            firTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        } else {
            boolean bl = 0 <= n2 ? n2 < ((Collection)ownerFunction.getValueParameters()).size() : false;
            if (bl) {
                FirValueParameter firValueParameter = CollectionsKt.getOrNull(ownerFunction.getValueParameters(), valueParameterIndex);
                if (firValueParameter == null) {
                    return null;
                }
                FirValueParameter parameter = firValueParameter;
                String string = parameter.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                name2 = string;
                firTypeRef = parameter.getReturnTypeRef();
            } else {
                FirValueParameter firValueParameter = CollectionsKt.getOrNull(ownerFunction.getContextParameters(), valueParameterIndex - ownerFunction.getValueParameters().size());
                if (firValueParameter == null) {
                    return null;
                }
                FirValueParameter parameter = firValueParameter;
                String string = parameter.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                name2 = string;
                firTypeRef = parameter.getReturnTypeRef();
            }
        }
        if (firTypeRef == null) {
            return null;
        }
        FirTypeRef typeRef = firTypeRef;
        return !FirTypeUtilsKt.isBoolean(typeRef) ? new KtValueParameterReference(valueParameterIndex, name2) : (KtValueParameterReference)new KtBooleanValueParameterReference(valueParameterIndex, name2);
    }

    @Override
    @NotNull
    public KtConstantReference<ConeKotlinType, ConeDiagnostic> loadConstant(@NotNull ProtoBuf.Expression.ConstantValue value2) {
        KtConstantReference<ConeKotlinType, ConeDiagnostic> ktConstantReference;
        Intrinsics.checkNotNullParameter(value2, "value");
        switch (WhenMappings.$EnumSwitchMapping$0[value2.ordinal()]) {
            case 1: {
                ktConstantReference = ConeContractConstantValues.INSTANCE.getTRUE();
                break;
            }
            case 2: {
                ktConstantReference = ConeContractConstantValues.INSTANCE.getFALSE();
                break;
            }
            case 3: {
                ktConstantReference = ConeContractConstantValues.INSTANCE.getNULL();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktConstantReference;
    }

    @Override
    @NotNull
    public KtConstantReference<ConeKotlinType, ConeDiagnostic> getNotNull() {
        return ConeContractConstantValues.INSTANCE.getNOT_NULL();
    }

    @Override
    @NotNull
    public KtConstantReference<ConeKotlinType, ConeDiagnostic> getWildcard() {
        return ConeContractConstantValues.INSTANCE.getWILDCARD();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Expression.ConstantValue.values().length];
            try {
                nArray[ProtoBuf.Expression.ConstantValue.TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Expression.ConstantValue.FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Expression.ConstantValue.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

