/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.dirtyFiles;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalJvmCachesManager;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathChangesComputer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotBuildReporter;
import org.jetbrains.kotlin.incremental.classpathDiff.ProgramSymbolSet;
import org.jetbrains.kotlin.incremental.dirtyFiles.ClasspathSnapshotBasedImpactDeterminerKt;
import org.jetbrains.kotlin.incremental.dirtyFiles.ImpactedFilesDeterminer;
import org.jetbrains.kotlin.incremental.snapshots.LazyClasspathSnapshot;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/dirtyFiles/ClasspathSnapshotBasedImpactDeterminer;", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/ImpactedFilesDeterminer;", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges;", "lazyClasspathSnapshot", "Lorg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "<init>", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;Lorg/jetbrains/kotlin/incremental/ClasspathChanges;Lorg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot;Lorg/jetbrains/kotlin/build/report/BuildReporter;)V", "determineChangedAndImpactedSymbols", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nClasspathSnapshotBasedImpactDeterminer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshotBasedImpactDeterminer.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/ClasspathSnapshotBasedImpactDeterminer\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,80:1\n31#2,5:81\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshotBasedImpactDeterminer.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/ClasspathSnapshotBasedImpactDeterminer\n*L\n40#1:81,5\n*E\n"})
public final class ClasspathSnapshotBasedImpactDeterminer
implements ImpactedFilesDeterminer {
    @NotNull
    private final IncrementalJvmCachesManager caches;
    @NotNull
    private final ClasspathChanges classpathChanges;
    @NotNull
    private final LazyClasspathSnapshot lazyClasspathSnapshot;
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;

    public ClasspathSnapshotBasedImpactDeterminer(@NotNull IncrementalJvmCachesManager caches, @NotNull ClasspathChanges classpathChanges, @NotNull LazyClasspathSnapshot lazyClasspathSnapshot, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter) {
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(classpathChanges, "classpathChanges");
        Intrinsics.checkNotNullParameter(lazyClasspathSnapshot, "lazyClasspathSnapshot");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.caches = caches;
        this.classpathChanges = classpathChanges;
        this.lazyClasspathSnapshot = lazyClasspathSnapshot;
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ChangesEither determineChangedAndImpactedSymbols() {
        ChangesEither changesEither;
        ICReporterKt.debug(this.reporter, () -> ClasspathSnapshotBasedImpactDeterminer.determineChangedAndImpactedSymbols$lambda$0(this));
        ClasspathChanges classpathChanges = this.classpathChanges;
        if (classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.NoChanges) {
            changesEither = new ChangesEither.Known(SetsKt.emptySet(), SetsKt.emptySet());
        } else if (classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.ToBeComputedByIncrementalCompiler) {
            ChangesEither.Known known;
            void $this$measure$iv;
            BuildMetricsReporter buildMetricsReporter = this.reporter;
            BuildTime time$iv = GradleBuildTime.COMPUTE_CLASSPATH_CHANGES;
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv);
            try {
                boolean bl = false;
                this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.COMPUTE_CLASSPATH_CHANGES_EXECUTION_COUNT), 1L);
                ProgramSymbolSet classpathChanges2 = ClasspathChangesComputer.INSTANCE.computeClasspathChanges(this.caches.getLookupCache(), this.lazyClasspathSnapshot, new ClasspathSnapshotBuildReporter(this.reporter));
                known = ClasspathSnapshotBasedImpactDeterminerKt.access$toChangesEither(BuildUtilKt.getChangedAndImpactedSymbols(ClasspathSnapshotBasedImpactDeterminerKt.access$toChangeInfoList(classpathChanges2), (Iterable<? extends IncrementalCacheCommon>)CollectionsKt.listOf(this.caches.getPlatformCache()), (ICReporter)this.reporter));
            }
            finally {
                $this$measure$iv.endMeasure(time$iv);
            }
            changesEither = known;
        } else if (classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableDueToMissingClasspathSnapshot) {
            changesEither = new ChangesEither.Unknown(BuildAttribute.CLASSPATH_SNAPSHOT_NOT_FOUND);
        } else if (classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableForNonIncrementalRun) {
            changesEither = new ChangesEither.Unknown(BuildAttribute.UNKNOWN_CHANGES_IN_GRADLE_INPUTS);
        } else {
            if (classpathChanges instanceof ClasspathChanges.ClasspathSnapshotDisabled) {
                throw new IllegalStateException(("Unexpected ClasspathSnapshotDisabled for this code path: " + this.classpathChanges.getClass().getName() + '.').toString());
            }
            if (classpathChanges instanceof ClasspathChanges.NotAvailableForJSCompiler) {
                throw new IllegalStateException(("Unexpected NotAvailableForJSCompiler for this code path: " + this.classpathChanges.getClass().getName() + '.').toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return changesEither;
    }

    private static final String determineChangedAndImpactedSymbols$lambda$0(ClasspathSnapshotBasedImpactDeterminer this$0) {
        return "Classpath changes info passed from Gradle task: " + Reflection.getOrCreateKotlinClass(this$0.classpathChanges.getClass()).getSimpleName();
    }
}

