/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.gui.colour.ColourChooser;
import tim.prune.gui.colour.ColourPatch;
import tim.prune.gui.colour.ColourerSelectorPanel;
import tim.prune.gui.colour.PatchListener;
import tim.prune.gui.colour.PointColourer;

public class SetColours
extends GenericFunction {
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private ColourPatch[] _patches = null;
    private ColourerSelectorPanel _colourerSelector = null;
    private ColourChooser _colourChooser = null;
    private static final String[] LABEL_KEYS = new String[]{"background", "primary", "point", "secondary", "selection", "borders", "text", "lines"};
    private static final int[] INDICES;

    static {
        int[] nArray = new int[8];
        nArray[1] = 4;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 2;
        nArray[5] = 6;
        nArray[6] = 3;
        nArray[7] = 7;
        INDICES = nArray;
    }

    public SetColours(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.setcolours";
    }

    private Component makeContents() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.setcolours.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        this._patches = new ColourPatch[8];
        ColourScheme colourScheme = Config.getColourScheme();
        ColourPatch colourPatch = null;
        int n = 0;
        while (n < 4) {
            jComponent = new JPanel();
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            jComponent.add(new JLabel(I18nManager.getText("dialog.setcolours." + LABEL_KEYS[n * 2])));
            colourPatch = new ColourPatch(colourScheme.getColour(INDICES[n * 2]));
            colourPatch.addMouseListener(new PatchListener(colourPatch, this._colourChooser));
            jComponent.add(colourPatch);
            this._patches[n * 2] = colourPatch;
            jComponent.add(Box.createRigidArea(new Dimension(0, 5)));
            jComponent.add(new JLabel(I18nManager.getText("dialog.setcolours." + LABEL_KEYS[n * 2 + 1])));
            colourPatch = new ColourPatch(colourScheme.getColour(INDICES[n * 2 + 1]));
            colourPatch.addMouseListener(new PatchListener(colourPatch, this._colourChooser));
            jComponent.add(colourPatch);
            this._patches[n * 2 + 1] = colourPatch;
            jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jPanel3.add(jComponent);
            ++n;
        }
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(15));
        this._colourerSelector = new ColourerSelectorPanel(this._colourChooser);
        this._colourerSelector.setAlignmentX(0.0f);
        jPanel2.add(this._colourerSelector);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this.updateConfigColours());
        jComponent = new JButton(I18nManager.getText("button.cancel"));
        ((AbstractButton)jComponent).addActionListener(actionEvent -> this._dialog.dispose());
        JButton jButton = new JButton(I18nManager.getText("button.resettodefaults"));
        jButton.addActionListener(actionEvent -> this.resetPressed());
        jPanel4.add(jButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this._okButton);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(jComponent);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void resetPressed() {
        int n = 0;
        while (n < 8) {
            this._patches[n].setColour(ColourScheme.getDefaultColour(INDICES[n]));
            ++n;
        }
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, this.getName());
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._colourChooser = new ColourChooser(this._dialog);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        ColourScheme colourScheme = Config.getColourScheme();
        int n = 0;
        while (n < 8) {
            this._patches[n].setColour(colourScheme.getColour(INDICES[n]));
            ++n;
        }
        PointColourer pointColourer = Config.getPointColourer();
        this._colourerSelector.init(pointColourer, colourScheme.getColour(1));
        this._dialog.setVisible(true);
        this._okButton.requestFocus();
    }

    private void updateConfigColours() {
        ColourScheme colourScheme = Config.getColourScheme();
        int n = 0;
        while (n < this._patches.length) {
            colourScheme.setColour(INDICES[n], this._patches[n].getBackground());
            ++n;
        }
        Config.updateColourScheme();
        PointColourer pointColourer = this._colourerSelector.getSelectedColourer();
        Config.updatePointColourer(pointColourer);
        this._app.updatePointColourer();
        UpdateMessageBroker.informSubscribers();
        this._dialog.dispose();
    }
}

