/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBoundaryDecoration;

public abstract class SegmentedBoundaryDecoration
extends AbstractBoundaryDecoration {
    private static final float DEFAULT_STEP = 46.0f;
    protected float startX = 0.0f;
    protected float startY = 0.0f;
    protected int numHorizontal = 0;
    protected int numVertical = 0;
    protected float hstep = 0.0f;
    protected float vstep = 0.0f;

    public SegmentedBoundaryDecoration() {
    }

    public SegmentedBoundaryDecoration(String id) {
        super(id);
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        Insets ins = figure.getInsets();
        float marginAmount = this.getMarginAmount();
        float top = (float)ins.top * marginAmount;
        float left = (float)ins.left * marginAmount;
        float bottom = (float)ins.bottom * marginAmount;
        float right = (float)ins.right * marginAmount;
        Rectangle box = this.getOutlineBox(figure);
        float width = (float)box.width - left - right;
        float height = (float)box.height - top - bottom;
        this.numHorizontal = Math.max(1, (int)(width / this.getPreferredHorizontalStep()));
        this.numVertical = Math.max(1, (int)(height / this.getPreferredVerticalStep()));
        this.hstep = width / (float)this.numHorizontal;
        this.vstep = height / (float)this.numVertical;
        this.startX = left;
        this.startY = top;
    }

    protected abstract float getMarginAmount();

    protected float getPreferredHorizontalStep() {
        return 46.0f;
    }

    protected float getPreferredVerticalStep() {
        return 46.0f;
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        float x = this.startX + (float)box.x;
        float y = this.startY + (float)box.y;
        float top = box.y;
        float left = box.x;
        float bottom = box.y + box.height;
        float right = box.x + box.width;
        shape.moveTo(x, y);
        int i = 0;
        while (i < this.numHorizontal) {
            this.sketchTopSegment(figure, shape, x, y, top, i);
            x += this.hstep;
            ++i;
        }
        i = 0;
        while (i < this.numVertical) {
            this.sketchRightSegment(figure, shape, x, y, right, i);
            y += this.vstep;
            ++i;
        }
        i = 0;
        while (i < this.numHorizontal) {
            this.sketchBottomSegment(figure, shape, x, y, bottom, i);
            x -= this.hstep;
            ++i;
        }
        i = 0;
        while (i < this.numVertical) {
            this.sketchLeftSegment(figure, shape, x, y, left, i);
            y -= this.vstep;
            ++i;
        }
        shape.close();
    }

    protected abstract void sketchTopSegment(IFigure var1, Path var2, float var3, float var4, float var5, int var6);

    protected abstract void sketchRightSegment(IFigure var1, Path var2, float var3, float var4, float var5, int var6);

    protected abstract void sketchBottomSegment(IFigure var1, Path var2, float var3, float var4, float var5, int var6);

    protected abstract void sketchLeftSegment(IFigure var1, Path var2, float var3, float var4, float var5, int var6);
}

