/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.xmind.ui.internal.MindMapUIPlugin;

public class OpenPopoverHandler {
    @Inject
    private EModelService modelService;
    @Inject
    private IEclipseContext context;

    @Execute
    public void run() {
        if (this.modelService == null || this.context == null) {
            return;
        }
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ShowMarkerCount");
        MApplication appModel = (MApplication)this.context.get(MApplication.class);
        MUIElement markerDirectItem = this.modelService.find("org.xmind.ui.toolbar.mindmap.marker", (MUIElement)appModel);
        if (markerDirectItem instanceof MContribution) {
            MContribution mContri = (MContribution)markerDirectItem;
            IEclipseContext windowContext = this.modelService.getContainingContext(markerDirectItem);
            IEclipseContext staticContext = EclipseContextFactory.create((String)"MarkerPopover-Static-Context");
            OpenPopoverHandler.populateModelInterfaces(markerDirectItem, staticContext, markerDirectItem.getClass().getInterfaces());
            Object markerModelObject = mContri.getObject();
            if (markerModelObject == null) {
                mContri.setObject(((IContributionFactory)windowContext.get(IContributionFactory.class)).create(mContri.getContributionURI(), windowContext));
            }
            ContextInjectionFactory.invoke((Object)markerModelObject, Execute.class, (IEclipseContext)windowContext, (IEclipseContext)staticContext, (Object)windowContext);
        }
    }

    private static void populateModelInterfaces(Object modelObject, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            context.set(intf.getName(), modelObject);
            OpenPopoverHandler.populateModelInterfaces(modelObject, context, intf.getInterfaces());
            ++n2;
        }
    }

    @CanExecute
    public boolean canExecute(EModelService modelService, MApplication app) {
        List editors = modelService.findElements((MUIElement)app, null, MPart.class, Arrays.asList("Editor"));
        return !editors.isEmpty();
    }
}

