/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.ui.internal.svgsupport.LinearGradient;
import org.xmind.ui.internal.svgsupport.SVGDefinition;
import org.xmind.ui.internal.svgsupport.SVGShape;
import org.xmind.ui.util.XMLUtils;

public class SVGImageData {
    private boolean isInit;
    private boolean documentContainError = false;
    private String filePath;
    private Dimension size = new Dimension(-1, -1);
    private static final Dimension INVALID_DIMENSION = new Dimension(-1, -1);
    private List<SVGShape> list;

    public SVGImageData(String filePath) {
        this.filePath = filePath;
        this.isInit = false;
        this.list = new ArrayList<SVGShape>();
    }

    private void init() {
        try {
            Element ele;
            Node node;
            Element svg = this.getRootElement(this.filePath);
            int height = Integer.parseInt(svg.getAttribute("height").split("px")[0]);
            int width = Integer.parseInt(svg.getAttribute("width").split("px")[0]);
            this.size = new Dimension(width, height);
            NodeList nodeList = svg.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                if (node.getNodeType() == 1 && "defs".equals((ele = (Element)node).getTagName())) {
                    this.parseDefinition(ele);
                }
                ++i;
            }
            i = 0;
            while (i < nodeList.getLength()) {
                SVGShape shape;
                node = nodeList.item(i);
                if (node.getNodeType() == 1 && (shape = SVGShape.parseShape(ele = (Element)node, null)) != null) {
                    this.list.add(shape);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.documentContainError = true;
            e.printStackTrace();
            return;
        }
        this.isInit = true;
    }

    private Element getRootElement(String path) {
        InputStream stream = null;
        try {
            URL url = new URL(path);
            Element element = this.getRootElement(url.openStream());
            return element;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    stream = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private Element getRootElement(InputStream stream) throws Exception {
        Document document = XMLUtils.getSvgDocumentBuilder().parse(stream);
        Element element = document.getDocumentElement();
        return element;
    }

    private void parseDefinition(Element defs) {
        NodeList list = defs.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element ele;
            String tagName;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (tagName = (ele = (Element)node).getTagName()) != null && !"".equals(tagName)) {
                SVGDefinition def;
                String id = ele.getAttribute("id");
                if (tagName.equals("linearGradient")) {
                    def = LinearGradient.parseLinearGradient(ele);
                    SVGShape.idRefs.put(id, def);
                } else {
                    def = SVGShape.parseShape(ele, null);
                    if (def != null) {
                        SVGShape.idRefs.put(id, def);
                    }
                }
            }
            ++i;
        }
    }

    private void paint(Graphics graphics, Display device) {
        if (!this.isInit) {
            this.init();
        }
        if (this.documentContainError) {
            return;
        }
        try {
            for (SVGShape shape : this.list) {
                shape.paintImage(graphics, device);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ImageData createImage(Dimension imageSize, RGB background) {
        if (imageSize != null && imageSize.equals((Object)INVALID_DIMENSION)) {
            if (this.size.equals((Object)INVALID_DIMENSION)) {
                this.init();
            }
            imageSize = this.size;
        }
        Image image = new Image((Device)Display.getDefault(), imageSize.width, imageSize.height);
        Rectangle rect = new Rectangle(0, 0, imageSize.width, imageSize.height);
        this.paintImage(image, rect, background);
        ImageData imgData = image.getImageData();
        image.dispose();
        return imgData;
    }

    public void paintImage(Image image, Rectangle paintArea, RGB background) {
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        this.paintFigure((Graphics)graphics, paintArea, null, background);
        graphics.dispose();
        gc.dispose();
    }

    public void paintFigure(Graphics graphics, Rectangle paintArea, ResourceManager manager) {
        this.paintFigure(graphics, paintArea, manager, null);
    }

    public void paintFigure(Graphics graphics, Rectangle paintArea, ResourceManager manager, RGB background) {
        graphics.setAdvanced(true);
        graphics.setAntialias(1);
        graphics.translate(paintArea.x, paintArea.y);
        Dimension svgImageSize = this.getSize();
        graphics.scale((float)paintArea.width / (float)svgImageSize.width, (float)paintArea.height / (float)svgImageSize.height);
        boolean isNewManager = false;
        if (manager == null) {
            ResourceManager resources = JFaceResources.getResources();
            resources = resources == null ? JFaceResources.getResources((Display)Display.getDefault()) : resources;
            manager = new LocalResourceManager(resources);
            isNewManager = true;
        }
        if (background != null) {
            graphics.pushState();
            graphics.setBackgroundColor(manager.createColor(background));
            graphics.fillRectangle(0, 0, svgImageSize.width, svgImageSize.height);
            graphics.popState();
        }
        this.setResourceManager(manager);
        this.paint(graphics, Display.getDefault());
        graphics.scale(1.0);
        if (isNewManager) {
            manager.dispose();
        }
    }

    private void setResourceManager(ResourceManager manager) {
        for (SVGShape shape : this.list) {
            shape.setResourceManager(manager);
        }
    }

    public Dimension getSize() {
        if (!this.isInit) {
            this.init();
        }
        return this.size;
    }
}

