/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.session;

import java.io.Closeable;
import java.util.function.Function;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.session.BuildSessionScopeServices;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.internal.session.DefaultBuildSessionContext;

public class BuildSessionState
implements Closeable {
    private final GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry;
    private final ServiceRegistry userHomeServices;
    private final ServiceRegistry sessionScopeServices;
    private final DefaultBuildSessionContext context;

    public BuildSessionState(GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry, CrossBuildSessionState crossBuildSessionServices, StartParameterInternal startParameter, BuildRequestMetaData requestMetaData, ClassPath injectedPluginClassPath, BuildCancellationToken buildCancellationToken, BuildClientMetaData buildClientMetaData, BuildEventConsumer buildEventConsumer) {
        this.userHomeScopeServiceRegistry = userHomeScopeServiceRegistry;
        this.userHomeServices = userHomeScopeServiceRegistry.getServicesFor(startParameter.getGradleUserHomeDir());
        this.sessionScopeServices = ServiceRegistryBuilder.builder().scope(Scopes.BuildSession.class).displayName("build session services").parent(this.userHomeServices).parent(crossBuildSessionServices.getServices()).provider((Object)new BuildSessionScopeServices(startParameter, requestMetaData, injectedPluginClassPath, buildCancellationToken, buildClientMetaData, buildEventConsumer)).build();
        this.context = new DefaultBuildSessionContext(this.sessionScopeServices);
    }

    public ServiceRegistry getServices() {
        return this.sessionScopeServices;
    }

    public <T> T run(Function<? super BuildSessionContext, T> action) {
        return action.apply(this.context);
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.sessionScopeServices, () -> this.userHomeScopeServiceRegistry.release(this.userHomeServices)}).stop();
    }
}

