/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import com.google.common.base.Joiner;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.process.ArgWriter;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.GradleWorkerMain;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.child.BootstrapSecurityManager;
import org.gradle.process.internal.worker.messaging.WorkerConfig;
import org.gradle.process.internal.worker.messaging.WorkerConfigSerializer;

public class ApplicationClassesInSystemClassLoaderWorkerImplementationFactory {
    private final ClassPathRegistry classPathRegistry;
    private final TemporaryFileProvider temporaryFileProvider;
    private final File gradleUserHomeDir;

    public ApplicationClassesInSystemClassLoaderWorkerImplementationFactory(ClassPathRegistry classPathRegistry, TemporaryFileProvider temporaryFileProvider, File gradleUserHomeDir) {
        this.classPathRegistry = classPathRegistry;
        this.temporaryFileProvider = temporaryFileProvider;
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareJavaCommand(long workerId, String displayName, WorkerProcessBuilder processBuilder, List<URL> implementationClassPath, List<URL> implementationModulePath, Address serverAddress, JavaExecHandleBuilder execSpec, boolean publishProcessInfo, boolean useOptionsFile) {
        boolean runAsModule;
        Set<File> applicationClasspath = processBuilder.getApplicationClasspath();
        Set<File> applicationModulePath = processBuilder.getApplicationModulePath();
        LogLevel logLevel = processBuilder.getLogLevel();
        Set<String> sharedPackages = processBuilder.getSharedPackages();
        Object requestedSecurityManager = execSpec.getSystemProperties().get("java.security.manager");
        List workerMainClassPath = this.classPathRegistry.getClassPath("WORKER_MAIN").getAsFiles();
        boolean bl = runAsModule = !applicationModulePath.isEmpty() && (Boolean)execSpec.getModularity().getInferModulePath().get() != false;
        if (runAsModule) {
            execSpec.getMainModule().set((Object)"gradle.worker");
        }
        execSpec.getMainClass().set((Object)("worker." + GradleWorkerMain.class.getName()));
        if (useOptionsFile) {
            File optionsFile = this.temporaryFileProvider.createTemporaryFile("gradle-worker-classpath", "txt", new String[0]);
            List<String> jvmArgs = this.writeOptionsFile(runAsModule, workerMainClassPath, implementationModulePath, applicationClasspath, applicationModulePath, optionsFile);
            execSpec.jvmArgs(jvmArgs);
        } else {
            execSpec.classpath(workerMainClassPath);
            execSpec.systemProperty("java.security.manager", "worker." + BootstrapSecurityManager.class.getName());
        }
        StreamByteBuffer buffer = new StreamByteBuffer();
        try {
            DataOutputStream outstr = new DataOutputStream((OutputStream)new EncodedStream.EncodedOutput(buffer.getOutputStream()));
            if (!useOptionsFile) {
                outstr.writeInt(applicationClasspath.size());
                for (File file : applicationClasspath) {
                    outstr.writeUTF(file.getAbsolutePath());
                }
                outstr.writeUTF(requestedSecurityManager == null ? "" : requestedSecurityManager.toString());
            }
            outstr.writeInt(sharedPackages.size());
            for (String str : sharedPackages) {
                outstr.writeUTF(str);
            }
            if (runAsModule || implementationModulePath == null) {
                outstr.writeInt(implementationClassPath.size());
                for (URL entry : implementationClassPath) {
                    outstr.writeUTF(entry.toString());
                }
            } else {
                outstr.writeInt(implementationClassPath.size() + implementationModulePath.size());
                for (URL entry : implementationClassPath) {
                    outstr.writeUTF(entry.toString());
                }
                for (URL entry : implementationModulePath) {
                    outstr.writeUTF(entry.toString());
                }
            }
            WorkerConfig config = new WorkerConfig(logLevel, publishProcessInfo, this.gradleUserHomeDir.getAbsolutePath(), (MultiChoiceAddress)serverAddress, workerId, displayName, processBuilder.getWorker());
            OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder((OutputStream)outstr);
            try {
                new WorkerConfigSerializer().write((Encoder)encoder, config);
            }
            finally {
                encoder.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        execSpec.setStandardInput(buffer.getInputStream());
    }

    private List<String> writeOptionsFile(boolean runAsModule, Collection<File> workerMainClassPath, Collection<URL> implementationModulePath, Collection<File> applicationClasspath, Set<File> applicationModulePath, File optionsFile) {
        ArrayList<File> classpath = new ArrayList<File>();
        ArrayList<File> modulePath = new ArrayList<File>();
        if (runAsModule) {
            modulePath.addAll(workerMainClassPath);
        } else {
            classpath.addAll(workerMainClassPath);
        }
        modulePath.addAll(applicationModulePath);
        classpath.addAll(applicationClasspath);
        if (!modulePath.isEmpty() && implementationModulePath != null && !implementationModulePath.isEmpty()) {
            modulePath.addAll(implementationModulePath.stream().map(url -> {
                try {
                    return new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()));
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        if (!modulePath.isEmpty()) {
            argumentList.addAll(Arrays.asList("--module-path", Joiner.on((String)File.pathSeparator).join(modulePath), "--add-modules", "ALL-MODULE-PATH"));
        }
        if (!classpath.isEmpty()) {
            argumentList.addAll(Arrays.asList("-cp", Joiner.on((String)File.pathSeparator).join(classpath)));
        }
        return (List)ArgWriter.argsFileGenerator((File)optionsFile, (InternalTransformer)ArgWriter.javaStyleFactory()).transform(argumentList);
    }
}

