/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ResolveExceptionContextualizer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultArtifactCollection;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.DefaultUnlockedConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.artifacts.transform.DefaultTransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.FreezableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.WrapUtil;

public abstract class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator,
ResettableConfiguration {
    private final ConfigurationResolver resolver;
    private final DependencyMetaDataProvider metaDataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private DefaultDependencySet allDependencies;
    private DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private ResolutionStrategyInternal resolutionStrategy;
    private final FileCollectionFactory fileCollectionFactory;
    private final ResolveExceptionContextualizer exceptionMapper;
    private final Set<MutationValidator> childMutationValidators = new HashSet<MutationValidator>();
    private final MutationValidator parentMutationValidator = this::validateParentMutation;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final Path identityPath;
    private final Path projectPath;
    private final String name;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private Set<ExcludeRule> parsedExcludeRules;
    private final Object observationLock = new Object();
    private volatile ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private boolean dependenciesModified;
    private boolean canBeConsumed;
    private boolean canBeResolved;
    private boolean canBeDeclaredAgainst;
    private final boolean consumptionDeprecated;
    private final boolean resolutionDeprecated;
    private final boolean declarationDeprecated;
    private boolean usageCanBeMutated = true;
    private final ConfigurationRole roleAtCreation;
    private boolean canBeMutated = true;
    private final FreezableAttributeContainer configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final ImmutableAttributesFactory attributesFactory;
    private final ResolutionBackedFileCollection intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final Lazy<List<? extends DependencyMetadata>> syntheticDependencies = Lazy.unsafe().of(this::generateSyntheticDependencies);
    private final AtomicInteger copyCount = new AtomicInteger();
    private List<String> declarationAlternatives = ImmutableList.of();
    private List<String> resolutionAlternatives = ImmutableList.of();
    private final CalculatedModelValue<Optional<ResolverResults>> currentResolveState;
    private ConfigurationInternal consistentResolutionSource;
    private String consistentResolutionReason;
    private TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory;
    private final DefaultConfigurationFactory defaultConfigurationFactory;

    public DefaultConfiguration(DomainObjectContext domainObjectContext, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners, DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, DependencyLockingProvider dependencyLockingProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ImmutableAttributesFactory attributesFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, ResolveExceptionContextualizer exceptionMapper, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, DefaultConfigurationFactory defaultConfigurationFactory, TaskDependencyFactory taskDependencyFactory, ConfigurationRole roleAtCreation, boolean lockUsage) {
        super(taskDependencyFactory);
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.identityPath = domainObjectContext.identityPath(name);
        this.projectPath = domainObjectContext.projectPath(name);
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.metaDataProvider = metaDataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.dependencyResolutionListeners = dependencyResolutionListeners;
        this.buildOperationExecutor = buildOperationExecutor;
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.domainObjectContext = domainObjectContext;
        this.exceptionMapper = exceptionMapper;
        this.displayName = Describables.memoize((Describable)new ConfigurationDescription(this.identityPath));
        this.configurationAttributes = new FreezableAttributeContainer(attributesFactory.mutable(), (Describable)this.displayName);
        this.intrinsicFiles = this.newFileCollection(false, () -> new ArtifactSelectionSpec(this.configurationAttributes.asImmutable(), (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, this.getResolutionStrategy().getSortOrder()));
        this.resolvableDependencies = (ConfigurationResolvableDependencies)instantiator.newInstance(ConfigurationResolvableDependencies.class, new Object[]{this});
        this.ownDependencies = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"dependencies"), this, (DomainObjectSet<Dependency>)this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet((Describable)Describables.of((Object)this.displayName, (Object)"artifacts"), (DomainObjectSet<PublishArtifact>)this.ownArtifacts, fileCollectionFactory, taskDependencyFactory);
        this.outgoing = (DefaultConfigurationPublications)instantiator.newInstance(DefaultConfigurationPublications.class, new Object[]{this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, instantiator, artifactNotationParser, capabilityNotationParser, fileCollectionFactory, attributesFactory, domainObjectCollectionFactory, taskDependencyFactory});
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilder;
        this.currentResolveState = domainObjectContext.getModel().newCalculatedValue(Optional.empty());
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.canBeConsumed = roleAtCreation.isConsumable();
        this.canBeResolved = roleAtCreation.isResolvable();
        this.canBeDeclaredAgainst = roleAtCreation.isDeclarable();
        this.consumptionDeprecated = roleAtCreation.isConsumptionDeprecated();
        this.resolutionDeprecated = roleAtCreation.isResolutionDeprecated();
        this.declarationDeprecated = roleAtCreation.isDeclarationAgainstDeprecated();
        this.usageCanBeMutated = !lockUsage;
        this.roleAtCreation = roleAtCreation;
    }

    private static Action<Void> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Configuration.State getState() {
        Optional currentState = (Optional)this.currentResolveState.get();
        if (!currentState.isPresent()) {
            return Configuration.State.UNRESOLVED;
        }
        ResolverResults resolvedState = (ResolverResults)currentState.get();
        if (resolvedState.getVisitedGraph().hasAnyFailure()) {
            return Configuration.State.RESOLVED_WITH_FAILURES;
        }
        if (resolvedState.isFullyResolved()) {
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        for (Configuration configuration : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection((DomainObjectCollection)configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection((DomainObjectCollection)configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.removeCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            if (!this.extendsFrom.add(configuration)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection((DomainObjectCollection)configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set result = WrapUtil.toLinkedSet((Object[])new Configuration[]{this});
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            result.remove(superConfig);
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.warnOnDeprecatedUsage("defaultDependencies(Action)", ProperMethodUsage.DECLARABLE_AGAINST);
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions = this.defaultDependencyActions.add(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute(dependencies);
            }
        });
        return this;
    }

    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.withDependencyActions = this.withDependencyActions.add(action);
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.defaultDependencyActions.execute((Object)this.dependencies);
        this.withDependencyActions.execute((Object)this.dependencies);
        this.defaultDependencyActions = ImmutableActionSet.empty();
        this.withDependencyActions = ImmutableActionSet.empty();
        for (Configuration superConfig : this.extendsFrom) {
            ((ConfigurationInternal)superConfig).runDependencyActions();
        }
    }

    @Deprecated
    public Set<Configuration> getAll() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)"Calling the Configuration.getAll() method").withAdvice("Use the configurations container to access the set of configurations instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_configuration_get_all")).nagUser();
        return ImmutableSet.copyOf(this.configurationsProvider.getAll());
    }

    public Set<File> resolve() {
        this.warnOnDeprecatedUsage("resolve()", ProperMethodUsage.RESOLVABLE);
        return this.getFiles();
    }

    public Iterator<File> iterator() {
        return this.intrinsicFiles.iterator();
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.intrinsicFiles.visitStructure(visitor);
    }

    protected void appendContents(TreeFormatter formatter) {
        formatter.node("configuration: " + this.identityPath);
    }

    public boolean contains(File file) {
        this.warnOnInvalidInternalAPIUsage("contains(File)", ProperMethodUsage.RESOLVABLE);
        return this.intrinsicFiles.contains(file);
    }

    public boolean isEmpty() {
        return this.intrinsicFiles.isEmpty();
    }

    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    public FileCollection fileCollection(Closure dependencySpecClosure) {
        this.warnOnDeprecatedUsage("fileCollection(Closure)", ProperMethodUsage.RESOLVABLE);
        return this.fileCollection((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpecClosure));
    }

    public FileCollection fileCollection(Dependency ... dependencies) {
        this.warnOnDeprecatedUsage("fileCollection(Dependency...)", ProperMethodUsage.RESOLVABLE);
        Set deps = WrapUtil.toLinkedSet((Object[])dependencies);
        return this.fileCollection((Spec<? super Dependency>)((Spec)deps::contains));
    }

    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        this.assertIsResolvable();
        this.warnOnDeprecatedUsage("fileCollection(Spec)", ProperMethodUsage.RESOLVABLE);
        return new ResolutionBackedFileCollection(new ResolverResultsResolutionResultProvider(false).map(resolverResults -> resolverResults.getLegacyResults().getLegacyVisitedArtifactSet().select(dependencySpec)), false, this.getResolutionHost(), this.taskDependencyFactory);
    }

    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        this.markThisObserved(requestedState);
        this.markParentsObserved(requestedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markThisObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) < 0) {
                this.observedState = requestedState;
            }
        }
    }

    @VisibleForTesting
    protected ConfigurationInternal.InternalState getObservedState() {
        return this.observedState;
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration : this.extendsFrom) {
            ((ConfigurationInternal)configuration).markAsObserved(requestedState);
        }
    }

    public ResolvedConfiguration getResolvedConfiguration() {
        this.warnOnDeprecatedUsage("getResolvedConfiguration()", ProperMethodUsage.RESOLVABLE);
        return new ResolverResultsResolutionResultProvider(false).getValue().getLegacyResults().getResolvedConfiguration();
    }

    private static Boolean isFullyResoled(Optional<ResolverResults> currentState) {
        return currentState.map(ResolverResults::isFullyResolved).orElse(false);
    }

    private ResolutionBackedFileCollection newFileCollection(boolean lenient, Supplier<ArtifactSelectionSpec> spec) {
        return new ResolutionBackedFileCollection(new ResolverResultsResolutionResultProvider(false).map(resolverResults -> resolverResults.getVisitedArtifacts().select((ArtifactSelectionSpec)spec.get())), lenient, this.getResolutionHost(), this.taskDependencyFactory);
    }

    private ResolverResults resolveGraphIfRequired() {
        ResolverResults newState;
        this.assertIsResolvable();
        this.maybeEmitResolutionDeprecation();
        Optional currentState = (Optional)this.currentResolveState.get();
        if (DefaultConfiguration.isFullyResoled(currentState).booleanValue()) {
            return (ResolverResults)currentState.get();
        }
        if (!this.domainObjectContext.getModel().hasMutableState()) {
            if (!this.workerThreadRegistry.isWorkerThread()) {
                throw new IllegalStateException("The configuration " + this.identityPath.toString() + " was resolved from a thread not managed by Gradle.");
            }
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)("Resolution of the configuration " + this.identityPath.toString() + " was attempted from a context different than the project context. Have a look at the documentation to understand why this is a problem and how it can be resolved.")).willBecomeAnErrorInGradle9().withUserManual("viewing_debugging_dependencies", "sub:resolving-unsafe-configuration-resolution-errors")).nagUser();
            newState = (ResolverResults)this.domainObjectContext.getModel().fromMutableState(p -> this.resolveExclusivelyIfRequired());
        } else {
            newState = this.resolveExclusivelyIfRequired();
        }
        return newState;
    }

    private ResolverResults resolveExclusivelyIfRequired() {
        return (ResolverResults)((Optional)this.currentResolveState.update(currentState -> {
            if (DefaultConfiguration.isFullyResoled(currentState).booleanValue()) {
                if (this.dependenciesModified) {
                    throw new InvalidUserDataException(String.format("Attempted to resolve %s that has been resolved previously.", this.getDisplayName()));
                }
                return currentState;
            }
            return Optional.of(this.resolveGraphInBuildOperation());
        })).get();
    }

    private ResolverResults resolveGraphInBuildOperation() {
        return (ResolverResults)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ResolverResults>(){

            public ResolverResults call(BuildOperationContext context) {
                ResolverResults results;
                DefaultConfiguration.this.runDependencyActions();
                DefaultConfiguration.this.preventFromFurtherMutation();
                ResolvableDependenciesInternal incoming = (ResolvableDependenciesInternal)DefaultConfiguration.this.getIncoming();
                DefaultConfiguration.this.performPreResolveActions(incoming);
                try {
                    results = DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this);
                }
                catch (Exception e) {
                    throw DefaultConfiguration.this.exceptionMapper.contextualize(e, DefaultConfiguration.this);
                }
                DefaultConfiguration.this.dependenciesModified = false;
                DefaultConfiguration.this.currentResolveState.set(Optional.of(results));
                DefaultConfiguration.this.markParentsObserved(ConfigurationInternal.InternalState.GRAPH_RESOLVED);
                if (!results.getVisitedGraph().getResolutionFailure().isPresent()) {
                    ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve((ResolvableDependencies)incoming);
                }
                DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                if (DefaultConfiguration.this.resolutionStrategy != null) {
                    DefaultConfiguration.this.resolutionStrategy.maybeDiscardStateRequiredForGraphResolution();
                }
                this.captureBuildOperationResult(context, results);
                return results;
            }

            private void captureBuildOperationResult(BuildOperationContext context, ResolverResults results) {
                results.getVisitedGraph().getResolutionFailure().ifPresent(arg_0 -> ((BuildOperationContext)context).failed(arg_0));
                DefaultResolutionResult resolutionResult = new DefaultResolutionResult(results.getVisitedGraph().getResolutionResult());
                context.setResult((Object)ResolveConfigurationResolutionBuildOperationResult.create(resolutionResult, DefaultConfiguration.this.attributesFactory));
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                Path projectPath = DefaultConfiguration.this.domainObjectContext.getProjectPath();
                String projectPathString = null;
                if (!DefaultConfiguration.this.domainObjectContext.isScript() && projectPath != null) {
                    projectPathString = projectPath.getPath();
                }
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().getPath(), projectPathString, DefaultConfiguration.this.isVisible(), DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getAllRepositories()));
            }
        });
    }

    @Override
    public ConfigurationInternal getConsistentResolutionSource() {
        this.warnOnInvalidInternalAPIUsage("getConsistentResolutionSource()", ProperMethodUsage.RESOLVABLE);
        return this.consistentResolutionSource;
    }

    private Stream<DependencyConstraint> getConsistentResolutionConstraints() {
        if (this.consistentResolutionSource == null) {
            return Stream.empty();
        }
        this.assertThatConsistentResolutionIsPropertyConfigured();
        return this.consistentResolutionSource.getIncoming().getResolutionResult().getAllComponents().stream().map(this::registerConsistentResolutionConstraint).filter(Objects::nonNull);
    }

    private void assertThatConsistentResolutionIsPropertyConfigured() {
        if (!this.consistentResolutionSource.isCanBeResolved()) {
            throw new InvalidUserCodeException("You can't use " + this.consistentResolutionSource + " as a consistent resolution source for " + this + " because it isn't a resolvable configuration.");
        }
        this.assertNoDependencyResolutionConsistencyCycle();
    }

    private void assertNoDependencyResolutionConsistencyCycle() {
        LinkedHashSet<DefaultConfiguration> sources = new LinkedHashSet<DefaultConfiguration>();
        for (ConfigurationInternal src = this; src != null; src = src.getConsistentResolutionSource()) {
            if (sources.add((DefaultConfiguration)src)) continue;
            String cycle = sources.stream().map(Named::getName).collect(Collectors.joining(" -> ")) + " -> " + this.getName();
            throw new InvalidUserDataException("Cycle detected in consistent resolution sources: " + cycle);
        }
    }

    @Nullable
    private DependencyConstraint registerConsistentResolutionConstraint(ResolvedComponentResult result) {
        if (result.getId() instanceof ModuleComponentIdentifier) {
            ModuleVersionIdentifier moduleVersion = result.getModuleVersion();
            DefaultDependencyConstraint constraint = DefaultDependencyConstraint.strictly(moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            constraint.because(this.consistentResolutionReason);
            return constraint;
        }
        return null;
    }

    private void performPreResolveActions(ResolvableDependencies incoming) {
        DependencyResolutionListener dependencyResolutionListener = (DependencyResolutionListener)this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(incoming);
        }
        finally {
            this.insideBeforeResolve = false;
        }
    }

    @Override
    public TransformUpstreamDependenciesResolverFactory getDependenciesResolverFactory() {
        this.warnOnInvalidInternalAPIUsage("getDependenciesResolverFactory()", ProperMethodUsage.RESOLVABLE);
        if (this.dependenciesResolverFactory == null) {
            ResolutionResultProvider<ResolutionResult> resolutionResultProvider = new ResolverResultsResolutionResultProvider(true).map(results -> new DefaultResolutionResult(results.getVisitedGraph().getResolutionResult()));
            this.dependenciesResolverFactory = new DefaultTransformUpstreamDependenciesResolverFactory(this.getIdentity(), resolutionResultProvider, this.domainObjectContext, this.calculatedValueContainerFactory, (attributes, filter) -> {
                ImmutableAttributes fullAttributes = this.attributesFactory.concat(this.configurationAttributes.asImmutable(), attributes);
                return this.newFileCollection(false, () -> new ArtifactSelectionSpec(fullAttributes, (Spec<? super ComponentIdentifier>)filter, false, false, this.getResolutionStrategy().getSortOrder()));
            });
        }
        return this.dependenciesResolverFactory;
    }

    public <T> T callAndResetResolutionState(Factory<T> factory) {
        this.warnOnInvalidInternalAPIUsage("callAndResetResolutionState()", ProperMethodUsage.RESOLVABLE);
        try {
            this.getResolutionStrategy().setKeepStateRequiredForGraphResolution(true);
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.getResolutionStrategy().setKeepStateRequiredForGraphResolution(false);
            this.currentResolveState.set(Optional.empty());
        }
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        this.assertIsResolvable();
        return (ResolverResults)((Optional)this.currentResolveState.update(initial -> {
            if (!initial.isPresent()) {
                try {
                    return Optional.of(this.resolver.resolveBuildDependencies(this));
                }
                catch (Exception e) {
                    throw this.exceptionMapper.contextualize(e, this);
                }
            }
            return initial;
        })).get();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.assertIsResolvable();
        context.add((Object)this.intrinsicFiles);
    }

    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, () -> this.getAllDependencies().withType(ProjectDependency.class), this.taskDependencyFactory, this.projectStateRegistry);
        }
        return new TasksFromDependentProjects(taskName, this.getName(), this.taskDependencyFactory);
    }

    public DependencySet getDependencies() {
        return this.dependencies;
    }

    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    @Override
    public boolean hasDependencies() {
        this.runDependencyActions();
        return !this.getAllDependencies().isEmpty();
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.domainObjectCollectionFactory.newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"all dependencies"), this, (DomainObjectSet<Dependency>)this.inheritedDependencies);
    }

    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"all dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.inheritedDependencyConstraints);
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of((Object)this.displayName, (Object)"all artifacts");
        if (!this.canBeMutated && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
            return;
        }
        if (this.canBeMutated) {
            this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection((DomainObjectCollection)allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.inheritedArtifacts, this.fileCollectionFactory, this.taskDependencyFactory) : new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
    }

    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet<ExcludeRule> result = new LinkedHashSet<ExcludeRule>();
        result.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = new LinkedHashSet<ExcludeRule>();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add((ExcludeRule)parser.parseNotation(excludeRule));
            }
        }
    }

    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Deprecated
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        this.outgoing.collectVariants(visitor);
    }

    @Override
    public boolean isCanBeMutated() {
        return this.canBeMutated;
    }

    public void preventFromFurtherMutation() {
        if (!this.canBeMutated) {
            return;
        }
        this.configurationAttributes.freeze();
        this.outgoing.preventFromFurtherMutation();
        this.preventUsageMutation();
        this.canBeMutated = false;
    }

    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute((Object)this.outgoing);
    }

    public ConfigurationInternal copy() {
        this.warnOnDeprecatedUsage("copy()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy((Set<Dependency>)this.getDependencies(), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive() {
        this.warnOnDeprecatedUsage("copyRecursive()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy((Set<Dependency>)this.getAllDependencies(), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        this.warnOnDeprecatedUsage("copy(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter((Set)this.getDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        this.warnOnDeprecatedUsage("copyRecursive(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter((Set)this.getAllDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        boolean deprecateConsumption = !this.canBeConsumed || this.consumptionDeprecated;
        boolean deprecateResolution = !this.canBeResolved || this.resolutionDeprecated;
        boolean deprecateDeclarationAgainst = !this.canBeDeclaredAgainst || this.declarationDeprecated;
        DefaultConfigurationRole adjustedCurrentUsage = new DefaultConfigurationRole("adjusted current usage with deprecations", true, true, true, deprecateConsumption, deprecateResolution, deprecateDeclarationAgainst);
        DefaultConfiguration copiedConfiguration = this.newConfiguration((ConfigurationRole)adjustedCurrentUsage);
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.declarationAlternatives = this.declarationAlternatives;
        copiedConfiguration.resolutionAlternatives = this.resolutionAlternatives;
        copiedConfiguration.getArtifacts().addAll((Collection)this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast((Object)attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add((Object)((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private DefaultConfiguration newConfiguration(ConfigurationRole role) {
        String newName = this.getNameWithCopySuffix();
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        RootComponentMetadataBuilder rootComponentMetadataBuilder = this.rootComponentMetadataBuilder.withConfigurationsProvider(configurationsProvider);
        Factory childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant((Object)this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        DefaultUnlockedConfiguration copiedConfiguration = this.defaultConfigurationFactory.create(newName, configurationsProvider, (Factory<ResolutionStrategyInternal>)childResolutionStrategy, rootComponentMetadataBuilder, role);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    public Configuration copy(Closure dependencySpec) {
        return this.copy((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = (ResolutionStrategyInternal)this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent() {
        this.warnOnInvalidInternalAPIUsage("toRootComponent()", ProperMethodUsage.RESOLVABLE);
        return this.rootComponentMetadataBuilder.toRootComponent(this.getName());
    }

    @Override
    public List<? extends DependencyMetadata> getSyntheticDependencies() {
        this.warnOnInvalidInternalAPIUsage("getSyntheticDependencies()", ProperMethodUsage.RESOLVABLE);
        return (List)this.syntheticDependencies.get();
    }

    private List<? extends DependencyMetadata> generateSyntheticDependencies() {
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(this.getModule());
        Stream<Object> dependencyLockingConstraintMetadata = Stream.empty();
        if (this.getResolutionStrategy().isDependencyLockingEnabled()) {
            DependencyLockingState dependencyLockingState = this.dependencyLockingProvider.loadLockState(this.name);
            boolean strict = dependencyLockingState.mustValidateLockState();
            dependencyLockingConstraintMetadata = dependencyLockingState.getLockedDependencies().stream().map(lockedDependency -> {
                String lockedVersion = lockedDependency.getVersion();
                DefaultMutableVersionConstraint versionConstraint = strict ? DefaultMutableVersionConstraint.withStrictVersion(lockedVersion) : DefaultMutableVersionConstraint.withVersion(lockedVersion);
                ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(lockedDependency.getGroup(), lockedDependency.getModule()), versionConstraint);
                return new LocalComponentDependencyMetadata((ComponentSelector)selector, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, this.getLockReason(strict, lockedVersion));
            });
        }
        Stream<LocalComponentDependencyMetadata> consistentResolutionConstraintMetadata = this.getConsistentResolutionConstraints().map(dc -> {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dc.getGroup(), dc.getName()), dc.getVersionConstraint());
            return new LocalComponentDependencyMetadata((ComponentSelector)selector, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, dc.getReason());
        });
        return (List)Stream.concat(dependencyLockingConstraintMetadata, consistentResolutionConstraintMetadata).collect(ImmutableList.toImmutableList());
    }

    private String getLockReason(boolean strict, String lockedVersion) {
        if (strict) {
            return "dependency was locked to version '" + lockedVersion + "'";
        }
        return "dependency was locked to version '" + lockedVersion + "' (update/lenient mode)";
    }

    @Override
    public DomainObjectContext getDomainObjectContext() {
        return this.domainObjectContext;
    }

    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getResolutionStrategy());
        return this;
    }

    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute((Object)this.getResolutionStrategy());
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.preventIllegalParentMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        this.preventIllegalMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    private void preventIllegalParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (DefaultConfiguration.isFullyResoled((Optional)this.currentResolveState.get()).booleanValue()) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
    }

    private void preventIllegalMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            this.assertIsDeclarable();
            return;
        }
        if (DefaultConfiguration.isFullyResoled((Optional)this.currentResolveState.get()).booleanValue()) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (this.observedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
        if (type == MutationValidator.MutationType.USAGE) {
            this.assertUsageIsMutable();
        }
    }

    private void markAsModified(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.dependenciesModified = true;
    }

    private void notifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
    }

    private ConfigurationIdentity getIdentity() {
        String name = this.getName();
        String projectPath = this.domainObjectContext.getProjectPath() == null ? null : this.domainObjectContext.getProjectPath().toString();
        String buildPath = this.domainObjectContext.getBuildPath().toString();
        return new DefaultConfigurationIdentity(buildPath, projectPath, name);
    }

    private boolean isProperUsage(boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        for (ProperMethodUsage properUsage : properUsages) {
            if (!properUsage.isProperUsage(this, allowDeprecated)) continue;
            return true;
        }
        return false;
    }

    private void warnOnInvalidInternalAPIUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOnDeprecatedUsage(methodName, true, properUsages);
    }

    private void warnOnDeprecatedUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOnDeprecatedUsage(methodName, false, properUsages);
    }

    private void warnOnDeprecatedUsage(String methodName, boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        if (!this.isProperUsage(allowDeprecated, properUsages)) {
            String msgTemplate = "Calling configuration method '%s' is deprecated for configuration '%s', which has permitted usage(s):\n%s\nThis method is only meant to be called on configurations which allow the %susage(s): '%s'.";
            String currentUsageDesc = UsageDescriber.describeCurrentUsage((DeprecatableConfiguration)this);
            String properUsageDesc = ProperMethodUsage.summarizeProperUsage(properUsages);
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)String.format(msgTemplate, methodName, this.getName(), currentUsageDesc, allowDeprecated ? "" : "(non-deprecated) ", properUsageDesc)).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_configuration_usage")).nagUser();
        }
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    private void assertIsDeclarable() {
        if (!this.canBeDeclaredAgainst) {
            throw new IllegalStateException("Declaring dependencies for configuration '" + this.name + "' is not allowed as it is defined as 'canBeDeclared=false'.");
        }
    }

    protected void assertCanCarryBuildDependencies() {
        this.assertIsResolvable();
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    public Configuration attributes(Action<? super AttributeContainer> action) {
        this.warnOnDeprecatedUsage("attributes(Action)", ProperMethodUsage.CONSUMABLE, ProperMethodUsage.RESOLVABLE);
        action.execute((Object)this.configurationAttributes);
        return this;
    }

    public void preventUsageMutation() {
        this.usageCanBeMutated = false;
    }

    @Override
    public boolean usageCanBeMutated() {
        return this.usageCanBeMutated;
    }

    private void assertUsageIsMutable() {
        if (!this.usageCanBeMutated) {
            if (this.roleAtCreation != ConfigurationRoles.LEGACY) {
                throw new GradleException(String.format("Cannot change the allowed usage of %s, as it was locked upon creation to the role: '%s'.\nThis role permits the following usage:\n%s\nIdeally, each configuration should be used for a single purpose.", this.getDisplayName(), this.roleAtCreation.getName(), this.roleAtCreation.describeUsage()));
            }
            throw new GradleException(String.format("Cannot change the allowed usage of %s, as it has been locked.", this.getDisplayName()));
        }
    }

    private void maybeWarnOnChangingUsage(String usage, boolean current) {
        if (this.isDetachedConfiguration() || this.isInLegacyRole()) {
            return;
        }
        String msgTemplate = "Allowed usage is changing for %s, %s. Ideally, usage should be fixed upon creation.";
        String changingUsage = usage + " was " + !current + " and is now " + current;
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format(msgTemplate, this.getDisplayName(), changingUsage)).withAdvice("Usage should be fixed upon creation.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
    }

    private void maybeWarnOnRedundantUsageActivation(String usage, String method) {
        if (!this.isSpecialCaseOfRedundantUsageActivation()) {
            String msgTemplate = "The %s usage is already allowed on %s.";
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format(msgTemplate, usage, this.getDisplayName())).withAdvice(String.format("Remove the call to %s, it has no effect.", method))).willBeRemovedInGradle9().withUpgradeGuideSection(8, "redundant_configuration_usage_activation")).nagUser();
        }
    }

    private boolean isSpecialCaseOfRedundantUsageActivation() {
        return this.isInLegacyRole() || this.isDetachedConfiguration() || this.isPermittedConfigurationForRedundantActivation();
    }

    private boolean isDetachedConfiguration() {
        return this.configurationsProvider instanceof DetachedConfigurationsProvider;
    }

    private boolean isInLegacyRole() {
        return this.roleAtCreation == ConfigurationRoles.LEGACY;
    }

    private boolean isPermittedConfigurationForRedundantActivation() {
        return this.name.equals("runtimeClasspath") || this.name.equals("testFixturesRuntimeClasspath") || this.name.endsWith("testRuntimeClasspath") || this.name.endsWith("TestRuntimeClasspath");
    }

    public boolean isDeprecatedForConsumption() {
        return this.consumptionDeprecated;
    }

    public boolean isDeprecatedForResolution() {
        return this.resolutionDeprecated;
    }

    public boolean isDeprecatedForDeclarationAgainst() {
        return this.declarationDeprecated;
    }

    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    public void setCanBeConsumed(boolean allowed) {
        this.setCanBeConsumed(allowed, true);
    }

    public void setCanBeConsumed(boolean allowed, boolean warn) {
        if (this.canBeConsumed != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeConsumed = allowed;
            if (warn) {
                this.maybeWarnOnChangingUsage("consumable", allowed);
            }
        } else if (this.canBeConsumed && allowed) {
            this.maybeWarnOnRedundantUsageActivation("consumable", "setCanBeConsumed(true)");
        }
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public void setCanBeResolved(boolean allowed) {
        this.setCanBeResolved(allowed, true);
    }

    public void setCanBeResolved(boolean allowed, boolean warn) {
        if (this.canBeResolved != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeResolved = allowed;
            if (warn) {
                this.maybeWarnOnChangingUsage("resolvable", allowed);
            }
        } else if (this.canBeResolved && allowed) {
            this.maybeWarnOnRedundantUsageActivation("resolvable", "setCanBeResolved(true)");
        }
    }

    public boolean isCanBeDeclared() {
        return this.canBeDeclaredAgainst;
    }

    public void setCanBeDeclared(boolean allowed) {
        this.setCanBeDeclared(allowed, true);
    }

    public void setCanBeDeclared(boolean allowed, boolean warn) {
        if (this.canBeDeclaredAgainst != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeDeclaredAgainst = allowed;
            if (warn) {
                this.maybeWarnOnChangingUsage("declarable", allowed);
            }
        } else if (this.canBeDeclaredAgainst && allowed) {
            this.maybeWarnOnRedundantUsageActivation("declarable", "setCanBeDeclared(true)");
        }
    }

    @Override
    public void setAllowedUsageFromRole(ConfigurationRole role) {
        if (this.isCanBeConsumed() != role.isConsumable()) {
            this.setCanBeConsumed(role.isConsumable(), false);
        }
        if (this.isCanBeResolved() != role.isResolvable()) {
            this.setCanBeResolved(role.isResolvable(), false);
        }
        if (this.isCanBeDeclared() != role.isDeclarable()) {
            this.setCanBeDeclared(role.isDeclarable(), false);
        }
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    public void addDeclarationAlternatives(String ... alternativesForDeclaring) {
        this.declarationAlternatives = ImmutableList.builder().addAll(this.declarationAlternatives).addAll(Arrays.asList(alternativesForDeclaring)).build();
    }

    public void addResolutionAlternatives(String ... alternativesForResolving) {
        this.resolutionAlternatives = ImmutableList.builder().addAll(this.resolutionAlternatives).addAll(Arrays.asList(alternativesForResolving)).build();
    }

    public Configuration shouldResolveConsistentlyWith(Configuration versionsSource) {
        this.warnOnDeprecatedUsage("shouldResolveConsistentlyWith(Configuration)", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = (ConfigurationInternal)versionsSource;
        this.consistentResolutionReason = "version resolved in " + versionsSource + " by consistent resolution";
        return this;
    }

    public Configuration disableConsistentResolution() {
        this.warnOnDeprecatedUsage("disableConsistentResolution()", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = null;
        this.consistentResolutionReason = null;
        return this;
    }

    @Override
    public ConfigurationRole getRoleAtCreation() {
        return this.roleAtCreation;
    }

    @Override
    public ResolutionHost getResolutionHost() {
        return new DefaultResolutionHost();
    }

    private static enum ProperMethodUsage {
        CONSUMABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeConsumed();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForConsumption();
            }
        }
        ,
        RESOLVABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeResolved();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForResolution();
            }
        }
        ,
        DECLARABLE_AGAINST{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeDeclared();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForDeclarationAgainst();
            }
        };


        abstract boolean isAllowed(ConfigurationInternal var1);

        abstract boolean isDeprecated(ConfigurationInternal var1);

        boolean isProperUsage(ConfigurationInternal configuration, boolean allowDeprecated) {
            return this.isAllowed(configuration) && (allowDeprecated || !this.isDeprecated(configuration));
        }

        public static String buildProperName(ProperMethodUsage usage) {
            return WordUtils.capitalizeFully((String)usage.name().replace('_', ' '));
        }

        public static String summarizeProperUsage(ProperMethodUsage ... properUsages) {
            return Arrays.stream(properUsages).map(ProperMethodUsage::buildProperName).collect(Collectors.joining(", "));
        }
    }

    private class DefaultResolutionHost
    implements ResolutionHost {
        private DefaultResolutionHost() {
        }

        @Override
        public String getDisplayName() {
            return DefaultConfiguration.this.getDisplayName();
        }

        @Override
        public DisplayName displayName(String type) {
            return Describables.of((Object)DefaultConfiguration.this, (Object)type);
        }

        @Override
        public Optional<? extends RuntimeException> mapFailure(String type, Collection<Throwable> failures) {
            return Optional.ofNullable(DefaultConfiguration.this.exceptionMapper.mapFailures(failures, DefaultConfiguration.this.getDisplayName(), type));
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    public static class ArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final ImmutableAttributesFactory attributesFactory;
        private final AttributeContainerInternal configurationAttributes;
        private AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter;
        private boolean lenient;
        private boolean reselectVariant;
        private boolean attributesUsed;

        public ArtifactViewConfiguration(ImmutableAttributesFactory attributesFactory, AttributeContainerInternal configurationAttributes) {
            this.attributesFactory = attributesFactory;
            this.configurationAttributes = configurationAttributes;
        }

        public AttributeContainer getAttributes() {
            if (this.viewAttributes == null) {
                this.viewAttributes = this.reselectVariant ? this.attributesFactory.mutable() : this.attributesFactory.mutable(this.configurationAttributes);
                this.attributesUsed = true;
            }
            return this.viewAttributes;
        }

        public ArtifactViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute((Object)this.getAttributes());
            return this;
        }

        public ArtifactViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            this.assertComponentFilterUnset();
            this.componentFilter = componentFilter;
            return this;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        public ArtifactViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public ArtifactViewConfiguration withVariantReselection() {
            this.reselectVariant = true;
            return this;
        }

        private void assertComponentFilterUnset() {
            if (this.componentFilter != null) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
        }

        private Spec<? super ComponentIdentifier> lockComponentFilter() {
            if (this.componentFilter == null) {
                this.componentFilter = Specs.satisfyAll();
            }
            return this.componentFilter;
        }
    }

    public class ConfigurationResolvableDependencies
    implements ResolvableDependenciesInternal {
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        public String getPath() {
            return DefaultConfiguration.this.projectPath.getPath();
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.identityPath + "'";
        }

        public FileCollection getFiles() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.intrinsicFiles;
        }

        public DependencySet getDependencies() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencies();
        }

        public DependencyConstraintSet getDependencyConstraints() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencyConstraints();
        }

        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void beforeResolve(Closure action) {
            this.beforeResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void afterResolve(Closure action) {
            this.afterResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.assertIsResolvable();
            return new DefaultResolutionResult(new ConfigurationResolvingMinimalResolutionResult());
        }

        public ArtifactCollection getArtifacts() {
            return new DefaultArtifactCollection(DefaultConfiguration.this.intrinsicFiles, false, DefaultConfiguration.this.getResolutionHost(), DefaultConfiguration.this.calculatedValueContainerFactory);
        }

        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            ArtifactViewConfiguration config = this.createArtifactViewConfiguration();
            configAction.execute((Object)config);
            return this.createArtifactView(config);
        }

        private ArtifactView createArtifactView(ArtifactViewConfiguration config) {
            AttributeContainerInternal viewAttributes = config.viewAttributes == null ? config.configurationAttributes : config.viewAttributes;
            boolean allowNoMatchingVariants = config.attributesUsed;
            return new ConfigurationArtifactView(viewAttributes, (Spec<? super ComponentIdentifier>)config.lockComponentFilter(), config.lenient, allowNoMatchingVariants, config.reselectVariant);
        }

        private ArtifactViewConfiguration createArtifactViewConfiguration() {
            return (ArtifactViewConfiguration)DefaultConfiguration.this.instantiator.newInstance(ArtifactViewConfiguration.class, new Object[]{DefaultConfiguration.this.attributesFactory, DefaultConfiguration.this.configurationAttributes});
        }

        public AttributeContainer getAttributes() {
            return DefaultConfiguration.this.configurationAttributes;
        }

        @Override
        public ResolutionResultProvider<VisitedGraphResults> getGraphResultsProvider() {
            DefaultConfiguration.this.assertIsResolvable();
            return new ResolverResultsResolutionResultProvider(false).map(ResolverResults::getVisitedGraph);
        }

        private class ConfigurationResolvingMinimalResolutionResult
        implements MinimalResolutionResult {
            private ConfigurationResolvingMinimalResolutionResult() {
            }

            private MinimalResolutionResult getDelegate() {
                VisitedGraphResults graph = ConfigurationResolvableDependencies.this.getGraphResultsProvider().getValue();
                graph.getResolutionFailure().ifPresent(ex -> {
                    throw ex;
                });
                return graph.getResolutionResult();
            }

            @Override
            public Supplier<ResolvedComponentResult> getRootSource() {
                return this.getDelegate().getRootSource();
            }

            @Override
            public ImmutableAttributes getRequestedAttributes() {
                return this.getDelegate().getRequestedAttributes();
            }

            public int hashCode() {
                return this.getDelegate().hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof ConfigurationResolvingMinimalResolutionResult) {
                    return this.getDelegate().equals(((ConfigurationResolvingMinimalResolutionResult)obj).getDelegate());
                }
                return false;
            }
        }

        private class ConfigurationArtifactView
        implements ArtifactView {
            private final AttributeContainerInternal viewAttributes;
            private final Spec<? super ComponentIdentifier> componentFilter;
            private final boolean lenient;
            private final boolean allowNoMatchingVariants;
            private final boolean selectFromAllVariants;

            ConfigurationArtifactView(AttributeContainerInternal viewAttributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants, boolean selectFromAllVariants) {
                this.viewAttributes = viewAttributes;
                this.componentFilter = componentFilter;
                this.lenient = lenient;
                this.allowNoMatchingVariants = allowNoMatchingVariants;
                this.selectFromAllVariants = selectFromAllVariants;
            }

            public AttributeContainer getAttributes() {
                return this.viewAttributes.asImmutable();
            }

            public ArtifactCollection getArtifacts() {
                return new DefaultArtifactCollection(this.getFiles(), this.lenient, DefaultConfiguration.this.getResolutionHost(), DefaultConfiguration.this.calculatedValueContainerFactory);
            }

            public ResolutionBackedFileCollection getFiles() {
                return DefaultConfiguration.this.newFileCollection(this.lenient, () -> new ArtifactSelectionSpec(this.viewAttributes.asImmutable(), this.componentFilter, this.selectFromAllVariants, this.allowNoMatchingVariants, DefaultConfiguration.this.getResolutionStrategy().getSortOrder()));
            }
        }
    }

    private static class DefaultConfigurationIdentity
    implements ConfigurationIdentity {
        private final String buildPath;
        private final String projectPath;
        private final String name;

        public DefaultConfigurationIdentity(String buildPath, @Nullable String projectPath, String name) {
            this.buildPath = buildPath;
            this.projectPath = projectPath;
            this.name = name;
        }

        public String getBuildPath() {
            return this.buildPath;
        }

        @Nullable
        public String getProjectPath() {
            return this.projectPath;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Path path = Path.path((String)this.buildPath);
            if (this.projectPath != null) {
                path = path.append(Path.path((String)this.projectPath));
            }
            path = path.child(this.name);
            return "Configuration '" + path.toString() + "'";
        }
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }

    private class ResolverResultsResolutionResultProvider
    implements ResolutionResultProvider<ResolverResults> {
        private final boolean strict;

        public ResolverResultsResolutionResultProvider(boolean strict) {
            this.strict = strict;
        }

        @Override
        public ResolverResults getTaskDependencyValue() {
            if (this.strict) {
                return (ResolverResults)((Optional)DefaultConfiguration.this.currentResolveState.get()).orElseThrow(() -> new IllegalStateException("Cannot query results until resolution has happened."));
            }
            if (DefaultConfiguration.this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
                return this.getValue();
            }
            return DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired();
        }

        @Override
        public ResolverResults getValue() {
            if (this.strict) {
                Optional currentState = (Optional)DefaultConfiguration.this.currentResolveState.get();
                if (!DefaultConfiguration.isFullyResoled(currentState).booleanValue()) {
                    return DefaultConfiguration.this.resolveExclusivelyIfRequired();
                }
                return (ResolverResults)currentState.get();
            }
            return DefaultConfiguration.this.resolveGraphIfRequired();
        }
    }
}

