/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.AbstractSourceGenerator;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.PluginModel;
import org.gradle.api.internal.catalog.VersionModel;
import org.gradle.api.internal.catalog.problems.DefaultCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ProblemReport;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.RenderingUtils;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.plugin.use.PluginDependency;
import org.gradle.util.internal.TextUtil;

public class LibrariesSourceGenerator
extends AbstractSourceGenerator {
    private static final int MAX_ENTRIES = 30000;
    public static final String ERROR_HEADER = "Cannot generate dependency accessors";
    private final DefaultVersionCatalog config;
    private final InternalProblems problemsService;
    private final Map<String, Integer> classNameCounter = new HashMap<String, Integer>();
    private final Map<ClassNode, String> classNameCache = new HashMap<ClassNode, String>();

    public LibrariesSourceGenerator(Writer writer, DefaultVersionCatalog config, Problems problemsService) {
        super(writer);
        this.config = config;
        this.problemsService = (InternalProblems)problemsService;
    }

    public static void generateSource(Writer writer, DefaultVersionCatalog config, String packageName, String className, Problems problemsService) {
        LibrariesSourceGenerator generator = new LibrariesSourceGenerator(writer, config, problemsService);
        try {
            generator.generateProjectExtensionFactoryClass(packageName, className);
            generator.classNameCounter.clear();
            generator.classNameCache.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void generatePluginsBlockSource(Writer writer, DefaultVersionCatalog config, String packageName, String className, Problems problemsService) {
        LibrariesSourceGenerator generator = new LibrariesSourceGenerator(writer, config, problemsService);
        try {
            generator.generatePluginsBlockFactoryClass(packageName, className);
            generator.classNameCounter.clear();
            generator.classNameCache.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void generateProjectExtensionFactoryClass(String packageName, String className) throws IOException {
        this.generateFactoryClass(packageName, entryPoints -> this.writeEntryPoints(className, (EntryPoints)entryPoints, false));
    }

    private void generatePluginsBlockFactoryClass(String packageName, String className) throws IOException {
        this.generateFactoryClass(packageName, entryPoints -> this.writeEntryPoints(className, (EntryPoints)entryPoints, true));
    }

    private void generateFactoryClass(String packageName, ThrowingConsumer<EntryPoints> entryPointsConsumer) throws IOException {
        this.writeLn("package " + packageName + ";");
        this.writeLn();
        this.addImports();
        this.writeLn();
        String description = Objects.requireNonNull(TextUtil.normaliseLineSeparators((String)this.config.getDescription()));
        this.writeLn("/**");
        for (String descLine : Splitter.on((char)'\n').split((CharSequence)description)) {
            this.writeLn(" * " + descLine);
        }
        List<String> libraries = this.config.getLibraryAliases();
        List<String> bundles = this.config.getBundleAliases();
        List<String> versions = this.config.getVersionAliases();
        List<String> plugins = this.config.getPluginAliases();
        this.performValidation(libraries, bundles, versions, plugins);
        entryPointsConsumer.accept(new EntryPoints(LibrariesSourceGenerator.toClassNode(libraries, LibrariesSourceGenerator.rootNode(AccessorKind.library)), LibrariesSourceGenerator.toClassNode(versions, LibrariesSourceGenerator.rootNode(AccessorKind.version, "versions")).parent, LibrariesSourceGenerator.toClassNode(bundles, LibrariesSourceGenerator.rootNode(AccessorKind.bundle, "bundles")).parent, LibrariesSourceGenerator.toClassNode(plugins, LibrariesSourceGenerator.rootNode(AccessorKind.plugin, "plugins")).parent));
    }

    private void writeEntryPoints(String className, EntryPoints entryPoints, boolean deprecated) throws IOException {
        this.writeLn(" */");
        this.writeLn("@NonNullApi");
        this.writeLn("public class " + className + " extends AbstractExternalDependencyFactory {");
        this.writeLn();
        this.indent(() -> {
            this.writeLn("private final AbstractExternalDependencyFactory owner = this;");
            this.writeSubAccessorFieldsOf(entryPoints.librariesEntryPoint, AccessorKind.library);
            this.writeSubAccessorFieldsOf(entryPoints.versionsEntryPoint, AccessorKind.version);
            this.writeSubAccessorFieldsOf(entryPoints.bundlesEntryPoint, AccessorKind.bundle);
            this.writeSubAccessorFieldsOf(entryPoints.pluginsEntryPoint, AccessorKind.plugin);
            this.writeLn();
            this.writeLn("@Inject");
            this.writeLn("public " + className + "(DefaultVersionCatalog config, ProviderFactory providers, ObjectFactory objects, ImmutableAttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) {");
            this.writeLn("    super(config, providers, objects, attributesFactory, capabilityNotationParser);");
            this.writeLn("}");
            this.writeLn();
            this.writeLibraryAccessors(entryPoints.librariesEntryPoint, deprecated);
            this.writeVersionAccessors(entryPoints.versionsEntryPoint);
            this.writeBundleAccessors(entryPoints.bundlesEntryPoint, deprecated);
            this.writePluginAccessors(entryPoints.pluginsEntryPoint);
            this.writeLibrarySubClasses(entryPoints.librariesEntryPoint, deprecated);
            this.writeVersionSubClasses(entryPoints.versionsEntryPoint);
            this.writeBundleSubClasses(entryPoints.bundlesEntryPoint, deprecated);
            this.writePluginSubClasses(entryPoints.pluginsEntryPoint);
        });
        this.writeLn("}");
    }

    private void addImports() throws IOException {
        this.addImport(NonNullApi.class);
        this.addImport(MinimalExternalModuleDependency.class);
        this.addImport(PluginDependency.class);
        this.addImport(ExternalModuleDependencyBundle.class);
        this.addImport(MutableVersionConstraint.class);
        this.addImport(Provider.class);
        this.addImport(ObjectFactory.class);
        this.addImport(ProviderFactory.class);
        this.addImport(AbstractExternalDependencyFactory.class);
        this.addImport(DefaultVersionCatalog.class);
        this.addImport(Map.class);
        this.addImport(ImmutableAttributesFactory.class);
        this.addImport(CapabilityNotationParser.class);
        this.addImport(Inject.class);
    }

    private void writeLibrarySubClasses(ClassNode classNode, boolean deprecated) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeLibraryAccessorClass(child, deprecated);
            this.writeLibrarySubClasses(child, deprecated);
        }
    }

    private void writeVersionSubClasses(ClassNode classNode) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeVersionAccessorClass(child);
            this.writeVersionSubClasses(child);
        }
    }

    private void writeBundleSubClasses(ClassNode classNode, boolean deprecated) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeBundleAccessorClass(child, deprecated);
            this.writeBundleSubClasses(child, deprecated);
        }
    }

    private void writePluginSubClasses(ClassNode classNode) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writePluginAccessorClass(child);
            this.writePluginSubClasses(child);
        }
    }

    private void writeBundleAccessorClass(ClassNode classNode, boolean deprecated) throws IOException {
        boolean isProvider;
        if (deprecated) {
            this.writeLn("/**");
            this.writeDeprecationJavadocTag(true, false);
            this.writeLn(" */");
            this.writeDeprecationAnnotation(true);
        }
        String interfaces = (isProvider = classNode.isAlsoProvider()) ? " implements BundleNotationSupplier" : "";
        String bundleClassName = this.getClassName(classNode);
        List aliases = classNode.aliases.stream().sorted().collect(Collectors.toList());
        this.writeLn("public static class " + bundleClassName + " extends BundleFactory " + interfaces + "{");
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.bundle);
            this.writeLn();
            this.writeLn("public " + bundleClassName + "(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, ImmutableAttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }");
            this.writeLn();
            if (isProvider) {
                String path = classNode.getFullAlias();
                BundleModel bundle = this.config.getBundle(path);
                List<String> coordinates = bundle.getComponents().stream().map(this.config::getDependencyData).map(LibrariesSourceGenerator::coordinatesDescriptorFor).collect(Collectors.toList());
                this.writeBundle(path, coordinates, bundle.getContext(), true, deprecated);
            }
            for (String alias : aliases) {
                String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
                if (classNode.hasChild(childName)) continue;
                BundleModel bundle = this.config.getBundle(alias);
                List<String> coordinates = bundle.getComponents().stream().map(this.config::getDependencyData).map(LibrariesSourceGenerator::coordinatesDescriptorFor).collect(Collectors.toList());
                this.writeBundle(alias, coordinates, bundle.getContext(), false, deprecated);
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.bundle, deprecated);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private String getClassName(ClassNode classNode) {
        return this.classNameCache.computeIfAbsent(classNode, this::getClassName0);
    }

    private String getClassName0(ClassNode classNode) {
        String name = classNode.getClassName();
        String loweredName = name.toLowerCase();
        if (!this.classNameCounter.containsKey(loweredName)) {
            this.classNameCounter.put(loweredName, 0);
            return name;
        }
        int count = this.classNameCounter.get(loweredName) + 1;
        this.classNameCounter.put(loweredName, count);
        return name + "$" + count;
    }

    private void writePluginAccessorClass(ClassNode classNode) throws IOException {
        boolean isProvider = classNode.isAlsoProvider();
        String interfaces = isProvider ? " implements PluginNotationSupplier" : "";
        String pluginClassName = this.getClassName(classNode);
        List aliases = classNode.aliases.stream().sorted().collect(Collectors.toList());
        this.writeLn("public static class " + pluginClassName + " extends PluginFactory " + interfaces + "{");
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.plugin);
            this.writeLn();
            this.writeLn("public " + pluginClassName + "(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }");
            this.writeLn();
            if (isProvider) {
                String path = classNode.getFullAlias();
                PluginModel plugin = this.config.getPlugin(path);
                this.writePlugin(path, plugin, true);
            }
            for (String alias : aliases) {
                String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
                if (classNode.hasChild(childName)) continue;
                PluginModel plugin = this.config.getPlugin(alias);
                this.writePlugin(alias, plugin, false);
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.plugin);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private void writeLibraryAccessors(ClassNode classNode, boolean deprecated) throws IOException {
        Set dependencies = classNode.aliases;
        for (String alias : dependencies) {
            String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
            if (classNode.hasChild(childName)) continue;
            DependencyModel model = this.config.getDependencyData(alias);
            this.writeDependencyAccessor(alias, model, false, deprecated);
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.library, deprecated);
        }
    }

    private void writeVersionAccessors(ClassNode classNode) throws IOException {
        Set versionsAliases = classNode.aliases;
        for (String alias : versionsAliases) {
            String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
            if (classNode.hasChild(childName)) continue;
            VersionModel model = this.config.getVersion(alias);
            this.writeSingleVersionAccessor(alias, model.getContext(), model.getVersion().getDisplayName(), false);
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.version);
        }
    }

    private void writeBundleAccessors(ClassNode classNode, boolean deprecated) throws IOException {
        Set versionsAliases = classNode.aliases;
        for (String alias : versionsAliases) {
            String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
            if (classNode.hasChild(childName)) continue;
            BundleModel model = this.config.getBundle(alias);
            List<String> coordinates = model.getComponents().stream().map(this.config::getDependencyData).map(LibrariesSourceGenerator::coordinatesDescriptorFor).collect(Collectors.toList());
            this.writeBundle(alias, coordinates, model.getContext(), false, deprecated);
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.bundle, deprecated);
        }
    }

    private void writePluginAccessors(ClassNode classNode) throws IOException {
        Set versionsAliases = classNode.aliases;
        for (String alias : versionsAliases) {
            String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
            if (classNode.hasChild(childName)) continue;
            PluginModel model = this.config.getPlugin(alias);
            this.writePlugin(alias, model, false);
        }
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessor(child, AccessorKind.plugin);
        }
    }

    private void writeSubAccessorFieldFor(ClassNode classNode, AccessorKind kind) throws IOException {
        String className = this.getClassName(classNode);
        this.writeLn("private final " + className + " " + kind.accessorVariableNameFor(className) + " = new " + className + "(" + kind.getConstructorParams() + ");");
    }

    private void writeSubAccessorFieldsOf(ClassNode classNode, AccessorKind kind) throws IOException {
        for (ClassNode child : classNode.getChildren()) {
            this.writeSubAccessorFieldFor(child, kind);
        }
    }

    private void writeLibraryAccessorClass(ClassNode classNode, boolean deprecated) throws IOException {
        boolean isProvider;
        if (deprecated) {
            this.writeLn("/**");
            this.writeDeprecationJavadocTag(true, false);
            this.writeLn(" */");
            this.writeDeprecationAnnotation(true);
        }
        String interfaces = (isProvider = classNode.isAlsoProvider()) ? " implements DependencyNotationSupplier" : "";
        this.writeLn("public static class " + this.getClassName(classNode) + " extends SubDependencyFactory" + interfaces + " {");
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.library);
            this.writeLn();
            this.writeLn("public " + this.getClassName(classNode) + "(AbstractExternalDependencyFactory owner) { super(owner); }");
            this.writeLn();
            if (isProvider) {
                String path = classNode.getFullAlias();
                DependencyModel model = this.config.getDependencyData(path);
                this.writeDependencyAccessor(path, model, true, deprecated);
            }
            for (String alias : classNode.aliases) {
                String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
                if (classNode.hasChild(childName)) continue;
                DependencyModel model = this.config.getDependencyData(alias);
                this.writeDependencyAccessor(alias, model, false, deprecated);
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.library, deprecated);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private void writeVersionAccessorClass(ClassNode classNode) throws IOException {
        boolean isProvider = classNode.isAlsoProvider();
        String interfaces = isProvider ? " implements VersionNotationSupplier" : "";
        String versionsClassName = this.getClassName(classNode);
        Set<String> versionAliases = classNode.getAliases();
        this.writeLn("public static class " + versionsClassName + " extends VersionFactory " + interfaces + " {");
        this.writeLn();
        this.indent(() -> {
            this.writeSubAccessorFieldsOf(classNode, AccessorKind.version);
            this.writeLn("public " + versionsClassName + "(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }");
            this.writeLn();
            if (isProvider) {
                String path = classNode.getFullAlias();
                VersionModel vm = this.config.getVersion(path);
                String context = vm.getContext();
                this.writeSingleVersionAccessor(path, context, vm.getVersion().getDisplayName(), true);
            }
            for (String alias : versionAliases) {
                String childName = LibrariesSourceGenerator.leafNodeForAlias(alias);
                if (classNode.hasChild(childName)) continue;
                VersionModel vm = this.config.getVersion(alias);
                String context = vm.getContext();
                this.writeSingleVersionAccessor(alias, context, vm.getVersion().getDisplayName(), false);
            }
            for (ClassNode child : classNode.getChildren()) {
                this.writeSubAccessor(child, AccessorKind.version);
            }
        });
        this.writeLn("}");
        this.writeLn();
    }

    private void writeSingleVersionAccessor(String versionAlias, @Nullable String context, String version, boolean asProvider) throws IOException {
        this.writeLn("/**");
        this.writeLn(" * Version alias <b>" + versionAlias + "</b> with value <b>" + version + "</b>");
        this.writeLn(" * <p>");
        this.writeLn(" * If the version is a rich version and cannot be represented as a");
        this.writeLn(" * single version string, an empty string is returned.");
        if (context != null) {
            this.writeLn(" * <p>");
            this.writeLn(" * This version was declared in " + LibrariesSourceGenerator.sanitizeUnicodeEscapes(context));
        }
        this.writeLn(" */");
        String methodName = asProvider ? "asProvider" : "get" + LibrariesSourceGenerator.toJavaName(LibrariesSourceGenerator.leafNodeForAlias(versionAlias));
        this.writeLn("public Provider<String> " + methodName + "() { return getVersion(\"" + versionAlias + "\"); }");
        this.writeLn();
    }

    private void performValidation(List<String> libraries, List<String> bundles, List<String> versions, List<String> plugins) {
        this.assertUnique(libraries, "library aliases", "");
        this.assertUnique(bundles, "dependency bundles", "Bundle");
        this.assertUnique(versions, "dependency versions", "Version");
        this.assertUnique(plugins, "plugins", "Plugin");
        int size = libraries.size() + bundles.size() + versions.size() + plugins.size();
        if (size > 30000) {
            throw this.throwVersionCatalogProblemException(this.problemsService.getInternalReporter().create(builder -> LibrariesSourceGenerator.configureVersionCatalogError(builder, this.getProblemPrefix() + "version catalog model contains too many entries (" + size + ").", VersionCatalogProblemId.TOO_MANY_ENTRIES).details("The maximum number of aliases in a catalog is 30000").solution("Reduce the number of aliases defined in this catalog").solution("Split the catalog into multiple catalogs")));
        }
    }

    private RuntimeException throwVersionCatalogProblemException(ProblemReport problem) {
        throw DefaultCatalogProblemBuilder.throwError((InternalProblems)this.problemsService, (String)ERROR_HEADER, (Collection)ImmutableList.of((Object)problem));
    }

    private static InternalProblemSpec configureVersionCatalogError(InternalProblemSpec spec, String message, VersionCatalogProblemId catalogProblemId) {
        return spec.label(message).documentedAt((DocLink)Documentation.userManual((String)"version_catalog_problems", (String)catalogProblemId.name().toLowerCase())).category("dependency-version-catalog", new String[]{TextUtil.screamingSnakeToKebabCase((String)catalogProblemId.name())}).severity(Severity.ERROR);
    }

    private void assertUnique(List<String> names, String prefix, String suffix) {
        List errors = names.stream().collect(Collectors.groupingBy(AbstractSourceGenerator::toJavaName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> {
            String errorValues = (String)((List)e.getValue()).stream().sorted().collect(RenderingUtils.oxfordJoin((String)"and"));
            return this.problemsService.getInternalReporter().create(builder -> LibrariesSourceGenerator.configureVersionCatalogError(builder, this.getProblemPrefix() + prefix + " " + errorValues + " are mapped to the same accessor name get" + (String)e.getKey() + suffix + "().", VersionCatalogProblemId.ACCESSOR_NAME_CLASH).details("A name clash was detected").solution("Use a different alias for " + errorValues));
        }).collect(Collectors.toList());
        DefaultCatalogProblemBuilder.maybeThrowError((InternalProblems)this.problemsService, (String)ERROR_HEADER, errors);
    }

    private String getProblemPrefix() {
        return DefaultCatalogProblemBuilder.getProblemInVersionCatalog((String)this.config.getName()) + ", ";
    }

    private static String coordinatesDescriptorFor(DependencyModel dependencyData) {
        return dependencyData.getGroup() + ":" + dependencyData.getName();
    }

    private void writeDependencyAccessor(String alias, DependencyModel dependency, boolean asProvider, boolean deprecated) throws IOException {
        String name = LibrariesSourceGenerator.leafNodeForAlias(alias);
        this.writeLn("/**");
        this.writeLn(" * Dependency provider for <b>" + name + "</b> with <b>" + LibrariesSourceGenerator.coordinatesDescriptorFor(dependency) + "</b> coordinates and");
        this.writeVersionInformation(dependency.getVersionRef(), dependency.getVersion());
        String context = dependency.getContext();
        if (context != null) {
            this.writeLn(" * <p>");
            this.writeLn(" * This dependency was declared in " + LibrariesSourceGenerator.sanitizeUnicodeEscapes(context));
        }
        this.writeDeprecationJavadocTag(deprecated, true);
        this.writeLn(" */");
        this.writeDeprecationAnnotation(deprecated);
        String methodName = asProvider ? "asProvider" : "get" + LibrariesSourceGenerator.toJavaName(name);
        this.writeLn("public Provider<MinimalExternalModuleDependency> " + methodName + "() {");
        this.writeDeprecationLog(deprecated);
        this.writeLn("    return create(\"" + alias + "\");");
        this.writeLn("}");
        this.writeLn();
    }

    private void writeVersionInformation(@Nullable String versionRef, ImmutableVersionConstraint version) throws IOException {
        if (versionRef != null) {
            this.writeLn(" * with version reference <b>" + versionRef + "</b>");
        } else {
            String versionDisplay = version.getDisplayName();
            if (versionDisplay.isEmpty()) {
                this.writeLn(" * with <b>no version specified</b>");
            } else {
                this.writeLn(" * with version <b>" + versionDisplay + "</b>");
            }
        }
    }

    private static String leafNodeForAlias(String alias) {
        List split = LibrariesSourceGenerator.nameSplitter().splitToList((CharSequence)alias);
        return (String)split.get(split.size() - 1);
    }

    private void writeSubAccessor(ClassNode classNode, AccessorKind kind) throws IOException {
        this.writeSubAccessor(classNode, kind, false);
    }

    private void writeSubAccessor(ClassNode classNode, AccessorKind kind, boolean deprecated) throws IOException {
        String className = this.getClassName(classNode);
        String getter = classNode.name;
        this.writeLn("/**");
        this.writeLn(" * Group of " + kind.getDescription() + " at <b>" + classNode.getPath() + "</b>");
        this.writeDeprecationJavadocTag(deprecated, true);
        this.writeLn(" */");
        this.writeDeprecationAnnotation(deprecated);
        this.writeLn("public " + className + " get" + LibrariesSourceGenerator.toJavaName(getter) + "() {");
        this.writeDeprecationLog(deprecated);
        this.writeLn("    return " + kind.accessorVariableNameFor(className) + ";");
        this.writeLn("}");
        this.writeLn();
    }

    private void writeBundle(String alias, List<String> coordinates, @Nullable String context, boolean asProvider, boolean deprecated) throws IOException {
        this.writeLn("/**");
        if (coordinates.isEmpty()) {
            this.writeLn(" * Dependency bundle provider for <b>" + alias + "</b> which contains no dependencies");
        } else {
            this.writeLn(" * Dependency bundle provider for <b>" + alias + "</b> which contains the following dependencies:");
            this.writeLn(" * <ul>");
            for (String coordinate : coordinates) {
                this.writeLn(" *    <li>" + coordinate + "</li>");
            }
            this.writeLn(" * </ul>");
        }
        if (context != null) {
            this.writeLn(" * <p>");
            this.writeLn(" * This bundle was declared in " + LibrariesSourceGenerator.sanitizeUnicodeEscapes(context));
        }
        this.writeDeprecationJavadocTag(deprecated, true);
        this.writeLn(" */");
        this.writeDeprecationAnnotation(deprecated);
        String methodName = asProvider ? "asProvider" : "get" + LibrariesSourceGenerator.toJavaName(LibrariesSourceGenerator.leafNodeForAlias(alias));
        this.writeLn("public Provider<ExternalModuleDependencyBundle> " + methodName + "() {");
        this.writeDeprecationLog(deprecated);
        this.writeLn("    return createBundle(\"" + alias + "\");");
        this.writeLn("}");
        this.writeLn();
    }

    private void writeDeprecationJavadocTag(boolean deprecated, boolean separate) throws IOException {
        if (deprecated) {
            if (separate) {
                this.writeLn(" *");
            }
            this.writeLn(" * @deprecated Will be removed in Gradle 9.0.");
        }
    }

    private void writeDeprecationAnnotation(boolean deprecated) throws IOException {
        if (deprecated) {
            this.writeLn("@Deprecated");
        }
    }

    private void writeDeprecationLog(boolean deprecated) throws IOException {
        if (deprecated) {
            this.writeLn("    " + DeprecationLogger.class.getName() + ".deprecateBehaviour(\"Accessing libraries or bundles from version catalogs in the plugins block.\").withAdvice(\"Only use versions or plugins from catalogs in the plugins block.\").willBeRemovedInGradle9().withUpgradeGuideSection(8, \"kotlin_dsl_deprecated_catalogs_plugins_block\").nagUser();");
        }
    }

    private void writePlugin(String alias, PluginModel plugin, boolean asProvider) throws IOException {
        this.writeLn("/**");
        this.writeLn(" * Plugin provider for <b>" + alias + "</b> with plugin id <b>" + plugin.getId() + "</b> and");
        this.writeVersionInformation(plugin.getVersionRef(), plugin.getVersion());
        String context = plugin.getContext();
        if (context != null) {
            this.writeLn(" * <p>");
            this.writeLn(" * This plugin was declared in " + LibrariesSourceGenerator.sanitizeUnicodeEscapes(context));
        }
        this.writeLn(" */");
        String methodName = asProvider ? "asProvider" : "get" + LibrariesSourceGenerator.toJavaName(LibrariesSourceGenerator.leafNodeForAlias(alias));
        this.writeLn("public Provider<PluginDependency> " + methodName + "() { return createPlugin(\"" + alias + "\"); }");
        this.writeLn();
    }

    private static String sanitizeUnicodeEscapes(String s) {
        return s.replace("\\u", "\\u005cu");
    }

    private static ClassNode rootNode(AccessorKind kind) {
        return new ClassNode(kind, null, null);
    }

    private static ClassNode rootNode(AccessorKind kind, String nest) {
        ClassNode root = LibrariesSourceGenerator.rootNode(kind);
        ClassNode wrappingNode = root.child(nest);
        wrappingNode.wrapping = true;
        return wrappingNode;
    }

    private static ClassNode toClassNode(List<String> aliases, ClassNode root) {
        for (String alias : aliases) {
            ClassNode current = root;
            List dotted = LibrariesSourceGenerator.nameSplitter().splitToList((CharSequence)alias);
            int last = dotted.size() - 1;
            for (int i = 0; i < last; ++i) {
                current = current.child((String)dotted.get(i));
            }
            current.addAlias(alias);
        }
        return root;
    }

    private static enum AccessorKind {
        library("libraries", "owner"),
        version("versions", "providers, config"),
        bundle("bundles", "objects, providers, config, attributesFactory, capabilityNotationParser"),
        plugin("plugins", "providers, config");

        private final String description;
        private final String constructorParams;
        private final String variablePrefix;

        private AccessorKind(String description, String constructorParams) {
            this.description = description;
            this.constructorParams = constructorParams;
            this.variablePrefix = this.name().charAt(0) + "acc";
        }

        public String getDescription() {
            return this.description;
        }

        public String getClassNameSuffix() {
            return StringUtils.capitalize((String)this.name()) + "Accessors";
        }

        public String getConstructorParams() {
            return this.constructorParams;
        }

        public String accessorVariableNameFor(String className) {
            return this.variablePrefix + "For" + className;
        }
    }

    private static class ClassNode {
        private final ClassNode parent;
        private final AccessorKind kind;
        private final String name;
        private final Map<String, ClassNode> children = new LinkedHashMap<String, ClassNode>();
        private final Set<String> aliases = new LinkedHashSet<String>();
        private final Set<String> leafAliases = new LinkedHashSet<String>();
        public boolean wrapping;

        private ClassNode(AccessorKind kind, @Nullable ClassNode parent, @Nullable String name) {
            this.kind = kind;
            this.parent = parent;
            this.name = name;
        }

        private String getSimpleName() {
            if (this.parent == null || this.wrapping) {
                return "";
            }
            return this.parent.getSimpleName() + StringUtils.capitalize((String)this.name);
        }

        private String getClassName() {
            return this.getSimpleName() + this.kind.getClassNameSuffix();
        }

        ClassNode child(String name) {
            return this.children.computeIfAbsent(name, n -> new ClassNode(this.kind, this, (String)n));
        }

        void addAlias(String alias) {
            this.aliases.add(alias);
            this.leafAliases.add(LibrariesSourceGenerator.leafNodeForAlias(alias));
        }

        public Collection<ClassNode> getChildren() {
            return this.children.values();
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public boolean hasChild(String name) {
            return this.children.containsKey(name);
        }

        String getPath() {
            if (this.parent == null) {
                return "";
            }
            String parentPath = this.parent.getPath();
            return parentPath.isEmpty() ? this.name : parentPath + "." + this.name;
        }

        String getFullAlias() {
            if (this.parent == null || this.wrapping) {
                return "";
            }
            String parentPath = this.parent.getFullAlias();
            return parentPath.isEmpty() ? this.name : parentPath + "." + this.name;
        }

        public boolean isAlsoProvider() {
            return this.parent != null && this.parent.leafAliases.contains(this.name) && this.parent.children.containsKey(this.name);
        }

        public String toString() {
            return "ClassNode{name='" + this.name + '\'' + ", aliases=" + this.aliases + '}';
        }
    }

    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    private static class EntryPoints {
        private final ClassNode librariesEntryPoint;
        private final ClassNode versionsEntryPoint;
        private final ClassNode bundlesEntryPoint;
        private final ClassNode pluginsEntryPoint;

        private EntryPoints(ClassNode librariesEntryPoint, ClassNode versionsEntryPoint, ClassNode bundlesEntryPoint, ClassNode pluginsEntryPoint) {
            this.librariesEntryPoint = librariesEntryPoint;
            this.versionsEntryPoint = versionsEntryPoint;
            this.bundlesEntryPoint = bundlesEntryPoint;
            this.pluginsEntryPoint = pluginsEntryPoint;
        }
    }
}

