/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.plugin.use.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.use.resolve.internal.CorePluginResolver;
import org.gradle.plugin.use.resolve.internal.NoopPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositories;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;

@ServiceScope(value={Scopes.Build.class})
public class PluginResolverFactory {
    private final PluginRegistry pluginRegistry;
    private final DocumentationRegistry documentationRegistry;
    private final ClientInjectedClasspathPluginResolver injectedClasspathPluginResolver;
    private final List<PluginResolverContributor> pluginResolverContributors;

    public PluginResolverFactory(PluginRegistry pluginRegistry, DocumentationRegistry documentationRegistry, ClientInjectedClasspathPluginResolver injectedClasspathPluginResolver, List<PluginResolverContributor> pluginResolverContributors) {
        this.pluginRegistry = pluginRegistry;
        this.documentationRegistry = documentationRegistry;
        this.injectedClasspathPluginResolver = injectedClasspathPluginResolver;
        this.pluginResolverContributors = pluginResolverContributors;
    }

    public PluginResolver create(PluginArtifactRepositories pluginResolveContext) {
        return new CompositePluginResolver(this.createDefaultResolvers(pluginResolveContext));
    }

    private List<PluginResolver> createDefaultResolvers(PluginArtifactRepositories pluginResolveContext) {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(pluginResolveContext, resolvers);
        return resolvers;
    }

    private void addDefaultResolvers(PluginArtifactRepositories pluginResolveContext, List<PluginResolver> resolvers) {
        resolvers.add(new NoopPluginResolver(this.pluginRegistry));
        resolvers.add(new CorePluginResolver(this.documentationRegistry, this.pluginRegistry));
        this.injectedClasspathPluginResolver.collectResolversInto(resolvers);
        this.pluginResolverContributors.forEach(contributor -> contributor.collectResolversInto(resolvers));
        resolvers.add(pluginResolveContext.getPluginResolver());
    }
}

