/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.satellites;

import java.util.List;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.VlSatellite;

public class SatellitesAddValidator implements Validator {

    public boolean supports(Class arg0) {
        return arg0.equals(SatellitesAdd.class);
    }

    public void validate(Object arg0, Errors arg1) {
        SatellitesAdd satellitesAdd = (SatellitesAdd) arg0;

        if (satellitesAdd == null) {
            arg1.rejectValue("name", "satellites.add.error.not-specified");
            return;
        } else {
            if ("".equals(satellitesAdd.getName())) {
                arg1.rejectValue("name", "satellites.add.error.invalidname");
                return;
            }
            IVlData data = satellitesAdd.getData();
            List<VlSatellite> satellites = data.getSatellites();
            if (satellites != null)
            {
                VlSatellite newSatellite = new VlSatellite(satellitesAdd.getName());
                if (satellites.contains(newSatellite)) {
                    arg1.rejectValue("name", "satellites.add.error.existingname");
                    return;
                }
            }
        }
    }

}
