/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class ARGDiscretizedBranchRates
extends AbstractBranchRateModel {
    public static final String DISCRETIZED_BRANCH_RATES = "argDiscretizedBranchRates";
    public static final String DISTRIBUTION = "distribution";
    public static final String NUM_RATE_CATEGORIES = "numRateCategories";
    public static final String SINGLE_ROOT_RATE = "singleRootRate";
    private ParametricDistributionModel distributionModel;
    private ARGModel tree;
    private Parameter rateCategoryParameter;
    private int rootNodeNumber;
    private int storedRootNodeNumber;
    private final int categoryCount;
    private final double step;
    private final double[] rates;
    private boolean ratesKnown = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(ARGModel.class), new ElementRule("distribution", ParametricDistributionModel.class, "The distribution model for rates among branches", false), AttributeRule.newIntegerRule("numRateCategories")};

        @Override
        public String getParserName() {
            return ARGDiscretizedBranchRates.DISCRETIZED_BRANCH_RATES;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            ParametricDistributionModel parametricDistributionModel = (ParametricDistributionModel)((Object)xMLObject.getChild(ARGDiscretizedBranchRates.DISTRIBUTION));
            int n = xMLObject.getIntegerAttribute(ARGDiscretizedBranchRates.NUM_RATE_CATEGORIES);
            Logger.getLogger("dr.evomodel").info("Using discretized relaxed clock model.");
            Logger.getLogger("dr.evomodel").info("  parametric model = " + parametricDistributionModel.getModelName());
            Logger.getLogger("dr.evomodel").info("   rate categories = " + n);
            if (xMLObject.hasAttribute(ARGDiscretizedBranchRates.SINGLE_ROOT_RATE)) {
                Logger.getLogger("dr.evomodel").warning("   WARNING: single root rate is not implemented!");
            }
            return new ARGDiscretizedBranchRates(aRGModel, n, parametricDistributionModel);
        }

        @Override
        public String getParserDescription() {
            return "This element returns an discretized relaxed clock model.The branch rates are drawn from a discretized parametric distribution.";
        }

        @Override
        public Class getReturnType() {
            return ARGDiscretizedBranchRates.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ARGDiscretizedBranchRates(ARGModel aRGModel, int n, ParametricDistributionModel parametricDistributionModel) {
        super(DISCRETIZED_BRANCH_RATES);
        this.tree = aRGModel;
        this.categoryCount = n;
        this.step = 1.0 / (double)this.categoryCount;
        this.rates = new double[this.categoryCount];
        this.distributionModel = parametricDistributionModel;
        this.rateCategoryParameter = this.rateCategoryParameter;
        if (n > aRGModel.getNodeCount() - 1) {
            throw new IllegalArgumentException("The rate category parameter must be less than the length 2*tipCount-1");
        }
        this.ratesKnown = false;
        this.addModel(parametricDistributionModel);
        this.addModel(aRGModel);
        this.storedRootNodeNumber = this.rootNodeNumber = aRGModel.getRoot().getNumber();
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.distributionModel) {
            this.ratesKnown = false;
        } else if (model == this.tree) {
            // empty if block
        }
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
        this.storedRootNodeNumber = this.rootNodeNumber;
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
        this.rootNodeNumber = this.storedRootNodeNumber;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (tree.isRoot(nodeRef)) {
            throw new IllegalArgumentException("root node doesn't have a rate!");
        }
        if (!this.ratesKnown) {
            this.setupRates();
            this.ratesKnown = true;
        }
        int n = (int)tree.getNodeRate(nodeRef);
        return this.rates[n];
    }

    private void setupRates() {
        double d = this.step / 2.0;
        for (int i = 0; i < this.categoryCount; ++i) {
            this.rates[i] = this.distributionModel.quantile(d);
            d += this.step;
        }
    }

    private void shuffleIndices() {
        int n = this.tree.getRoot().getNumber();
        if (this.rootNodeNumber > n) {
            int n2 = (int)Math.round(this.rateCategoryParameter.getParameterValue(n));
            int n3 = Math.min(this.rateCategoryParameter.getDimension() - 1, this.rootNodeNumber);
            for (int i = n; i < n3; ++i) {
                this.rateCategoryParameter.setParameterValue(i, this.rateCategoryParameter.getParameterValue(i + 1));
            }
            this.rateCategoryParameter.setParameterValue(n3, n2);
        } else if (this.rootNodeNumber < n) {
            int n4 = Math.min(this.rateCategoryParameter.getDimension() - 1, n);
            int n5 = (int)Math.round(this.rateCategoryParameter.getParameterValue(n4));
            for (int i = n4; i > this.rootNodeNumber; --i) {
                this.rateCategoryParameter.setParameterValue(i, this.rateCategoryParameter.getParameterValue(i - 1));
            }
            this.rateCategoryParameter.setParameterValue(this.rootNodeNumber, n5);
        }
        this.rootNodeNumber = n;
    }
}

