/*
   NOTE: You need to edit the `libname` command to specify the path to the directory
   where the data file is located. For example: "C:\ipums_directory".
   Edit the `filename` command similarly to include the full path (the directory and the data file name).
*/

libname IPUMS ".";
filename ASCIIDAT "nhgis0730_ts_nominal_state.dat";

data IPUMS.nhgis0730_ts_nominal_state;
infile ASCIIDAT pad missover lrecl=297;

input
  GISJOIN   $ 1-4
  STATE     $ 5-28
  STATEFP   $ 29-30
  STATENH   $ 31-33
  A00AA1790   34-44
  A00AA1800   45-55
  A00AA1810   56-66
  A00AA1820   67-77
  A00AA1830   78-88
  A00AA1840   89-99
  A00AA1850   100-110
  A00AA1860   111-121
  A00AA1870   122-132
  A00AA1880   133-143
  A00AA1890   144-154
  A00AA1900   155-165
  A00AA1910   166-176
  A00AA1920   177-187
  A00AA1930   188-198
  A00AA1940   199-209
  A00AA1950   210-220
  A00AA1960   221-231
  A00AA1970   232-242
  A00AA1980   243-253
  A00AA1990   254-264
  A00AA2000   265-275
  A00AA2010   276-286
  A00AA2020   287-297
;

label
  GISJOIN   = "GIS Join Match Code"
  STATE     = "NHGIS Integrated State Name"
  STATEFP   = "FIPS State Code"
  STATENH   = "NHGIS Integrated State Code"
  A00AA1790 = "1790: Persons: Total"
  A00AA1800 = "1800: Persons: Total"
  A00AA1810 = "1810: Persons: Total"
  A00AA1820 = "1820: Persons: Total"
  A00AA1830 = "1830: Persons: Total"
  A00AA1840 = "1840: Persons: Total"
  A00AA1850 = "1850: Persons: Total"
  A00AA1860 = "1860: Persons: Total"
  A00AA1870 = "1870: Persons: Total"
  A00AA1880 = "1880: Persons: Total"
  A00AA1890 = "1890: Persons: Total"
  A00AA1900 = "1900: Persons: Total"
  A00AA1910 = "1910: Persons: Total"
  A00AA1920 = "1920: Persons: Total"
  A00AA1930 = "1930: Persons: Total"
  A00AA1940 = "1940: Persons: Total"
  A00AA1950 = "1950: Persons: Total"
  A00AA1960 = "1960: Persons: Total"
  A00AA1970 = "1970: Persons: Total"
  A00AA1980 = "1980: Persons: Total"
  A00AA1990 = "1990: Persons: Total"
  A00AA2000 = "2000: Persons: Total"
  A00AA2010 = "2010: Persons: Total"
  A00AA2020 = "2020: Persons: Total"
;

format
  A00AA1790  11.
  A00AA1800  11.
  A00AA1810  11.
  A00AA1820  11.
  A00AA1830  11.
  A00AA1840  11.
  A00AA1850  11.
  A00AA1860  11.
  A00AA1870  11.
  A00AA1880  11.
  A00AA1890  11.
  A00AA1900  11.
  A00AA1910  11.
  A00AA1920  11.
  A00AA1930  11.
  A00AA1940  11.
  A00AA1950  11.
  A00AA1960  11.
  A00AA1970  11.
  A00AA1980  11.
  A00AA1990  11.
  A00AA2000  11.
  A00AA2010  11.
  A00AA2020  11.
;

run;

