/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.globalcardinality;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.globalcardinality.PropFastGCC;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class GlobalCardinality
extends Constraint {
    public GlobalCardinality(IntVar[] vars, int[] values, IntVar[] cards) {
        super("GCC", GlobalCardinality.createProp(vars, values, cards));
    }

    private static Propagator<IntVar> createProp(IntVar[] vars, int[] values, IntVar[] cards) {
        assert (values.length == cards.length);
        TIntIntHashMap map = new TIntIntHashMap();
        int idx = 0;
        for (int v : values) {
            if (!map.containsKey(v)) {
                map.put(v, idx);
                ++idx;
                continue;
            }
            throw new UnsupportedOperationException("ERROR: multiple occurrences of value: " + v);
        }
        return new PropFastGCC(vars, values, map, cards);
    }

    public static Constraint reformulate(IntVar[] vars, IntVar[] card, Model model) {
        ArrayList<Constraint> cstrs = new ArrayList<Constraint>();
        for (int i = 0; i < card.length; ++i) {
            BoolVar[] bs = model.boolVarArray("b_" + i, vars.length);
            for (int j = 0; j < vars.length; ++j) {
                model.reifyXeqC(vars[j], i, bs[j]);
            }
            cstrs.add(model.sum(bs, "=", card[i]));
        }
        return Constraint.merge("reformulatedGCC", cstrs.toArray(new Constraint[0]));
    }
}

