## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  dev = "svg"
)

ggplot2::theme_set(ggplot2::theme_bw())


## ----echo = FALSE-------------------------------------------------------------
DiagrammeR::grViz(diagram = "digraph flowchart {
graph [layout = dot, rankdir = LR,fontname = 'helvetica'];
node [fontname = 'helvetica'];
edge [fontname = 'helvetica',
arrowname = 'vee',
color = 'grey'];

  node [style = filled color = white shape = rectangle]
  node [fillcolor = '#48007B' fontcolor = white]
  a [label = 'gasdata']
  b [label = 'soilphys']
  c [label = 'layers_map']
  h [label = 'cfp_dat']
  m [label = 'cfp_fgres']
  n [label = 'cfp_pfres']
  o [label = 'EFFLUX']
  p [label = 'PRODUCTION']
  s [label = 'cfp_altres']
  
  
  node [fillcolor = '#D58F38' shape = ellipse fontcolor = black]
  d [label = 'cfp_dat()']
  e [label = 'cfp_gasdata()']
  f [label = 'cfp_soilphys()']
  g [label = 'cfp_layers_map()']
  i [label = 'fg_flux()']
  j [label = 'pro_flux()']
  k [label = 'efflux()']
  l [label = 'production()']
  q [label = 'cfp_run_map()']
  r [label = 'alternate()']
  t [label = 'bootstrap_error()']
  
  a -> {e}
  b -> {f}
  c -> {g}
  {e f g} -> d
  d -> h
  h -> {i j}
  i -> m
  j -> n
  {m n} -> {k l r}
  k -> o
  l -> p
  q -> r
  r -> s
  s -> t
   
   subgraph clusterMain {
   graph [rankdir = TB]
   node [style = filled color = white shape = rectangle]
  node [fillcolor = '#48007B' fontcolor = white]
  aaa [label = 'objects']


  node [fillcolor = '#D58F38' shape = oval fontcolor = black]
  bbb [label = 'functions()']
   
}
  
}
 
  ")

