/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.rosuda.deducer.data.ExTable;

public class ColumnHeaderListener
extends MouseAdapter {
    private ExTable table;
    private JPopupMenu menu;

    public ColumnHeaderListener() {
        this(new ExTable());
    }

    public ColumnHeaderListener(ExTable exTable) {
        this.table = exTable;
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    public void remove() {
        this.table.getTableHeader().removeMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = System.getProperty("java.vendor").indexOf("Apple") > -1;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.table.convertColumnIndexToModel(n);
        this.table.selectColumn(n);
        if (mouseEvent.getButton() == 3 && !bl) {
            new ColumnContextMenu(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = System.getProperty("java.vendor").indexOf("Apple") > -1;
        if (mouseEvent.isPopupTrigger() && bl) {
            new ColumnContextMenu(mouseEvent);
        }
    }

    class ColumnContextMenu
    implements ActionListener {
        int vColIndex;
        int mColIndex;

        public ColumnContextMenu(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = ColumnHeaderListener.this.table.getColumnModel();
            this.vColIndex = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            this.mColIndex = ColumnHeaderListener.this.table.convertColumnIndexToModel(this.vColIndex);
            ColumnHeaderListener.this.menu = new JPopupMenu();
            ColumnHeaderListener.this.table.getTableHeader().add(ColumnHeaderListener.this.menu);
            JMenuItem jMenuItem = new JMenuItem("Copy");
            jMenuItem.addActionListener(this);
            ColumnHeaderListener.this.menu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Cut");
            jMenuItem2.addActionListener(this);
            ColumnHeaderListener.this.menu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Paste");
            jMenuItem3.addActionListener(this);
            ColumnHeaderListener.this.menu.add(jMenuItem3);
            ColumnHeaderListener.this.menu.addSeparator();
            JMenuItem jMenuItem4 = new JMenuItem("Insert");
            jMenuItem4.addActionListener(this);
            ColumnHeaderListener.this.menu.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem("Insert New Column");
            jMenuItem5.addActionListener(this);
            ColumnHeaderListener.this.menu.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Remove Column");
            jMenuItem6.addActionListener(this);
            ColumnHeaderListener.this.menu.add(jMenuItem6);
            ColumnHeaderListener.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText() == "Copy") {
                ColumnHeaderListener.this.table.getCopyPasteAdapter().copy();
            } else if (jMenuItem.getText() == "Cut") {
                ColumnHeaderListener.this.table.cutColumn(this.vColIndex);
            } else if (jMenuItem.getText() == "Paste") {
                ColumnHeaderListener.this.table.getCopyPasteAdapter().paste();
            } else if (jMenuItem.getText() == "Insert") {
                ColumnHeaderListener.this.table.insertColumn(this.vColIndex);
            } else if (jMenuItem.getText() == "Insert New Column") {
                ColumnHeaderListener.this.table.insertNewColumn(this.vColIndex);
            } else if (jMenuItem.getText() == "Remove Column") {
                ColumnHeaderListener.this.table.removeColumn(this.vColIndex);
            }
            ColumnHeaderListener.this.menu.setVisible(false);
        }
    }
}

