## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo=FALSE,include=FALSE-------------------------------------------------
library(redlist)
library(kableExtra)
library(dplyr)

## ----eval=FALSE---------------------------------------------------------------
# # Install pak if not available
# if (!requireNamespace("pak", quietly = TRUE)) {
#   install.packages("pak")
# }
# 
# # Then install redlist
# pak::pkg_install("stangandaho/redlist")
# # Load the package
# library(redlist)

## ----eval=FALSE---------------------------------------------------------------
# benin_redlist <- rl_countries(code = "BJ")
# head(benin_redlist)

## ----echo=FALSE---------------------------------------------------------------
benin_redlist <- readRDS("benin_redlist.rds")
head(benin_redlist) %>% 
  kableExtra::kable("html") %>% 
  kableExtra::kable_styling("striped") %>% 
  kableExtra::scroll_box(width = "100%")


## ----eval=FALSE---------------------------------------------------------------
# # Get data from five first pages
# benin_redlist <- rl_countries(code = "BJ", page = 1:5)
# # Get data from two first pages specifically for 2023
# benin_redlist <- rl_countries(code = "BJ", page = 1:5, year_published = 2023)
# # Get all data on Benin
# benin_redlist <- rl_countries(code = "BJ", page = NA)

## ----eval=FALSE---------------------------------------------------------------
# all_species_details <- lapply(benin_redlist$assessments_assessment_id, function(x){
#   rl_assessment_id(id)
# }) %>%
#   dplyr::bind_rows()
# 

