## ----install, eval=FALSE, message=FALSE, warning=FALSE------------------------
# library(devtools)
# install_github("stefanangrick/BIS")  # GitHub
# install.packages("BIS")              # CRAN

## ----loading, eval=FALSE, message=FALSE, warning=FALSE------------------------
# library("BIS")

## ----datasets, eval=FALSE, message=FALSE, warning=FALSE-----------------------
# ds <- get_datasets()
# head(ds, 20)

## ----rates, eval=FALSE, message=FALSE, warning=FALSE--------------------------
# rates <- get_bis(ds$url[ds$id == "WS_CBPOL_csv_flat"])
# head(rates)

## ----plot, eval=FALSE, message=FALSE, warning=FALSE---------------------------
# library("dplyr")
# library("ggplot2")
# library("zoo")
# 
# rates_plot <- subset(rates, ref_area %in% c("US", "XM", "JP", "GB", "CH", "CA"))
# rates_plot <- subset(rates, ref_area %in% c("US: United States",
#                                             "XM: Euro area",
#                                             "JP: Japan",
#                                             "GB: United Kingdom",
#                                             "CH: Switzerland",
#                                             "CA: Canada"))
# rates_plot <- mutate(rates_plot, time_period =
#                        as.Date(as.yearmon(time_period, format = "%Y-%m")))
# 
# ggplot(rates_plot, aes(time_period, obs_value, color = ref_area)) +
#   geom_line(show.legend = FALSE) +
#   facet_wrap(~ref_area) +
#   labs(title = "Central bank policy rates",
#        subtitle = "% per annum", x = NULL, y = NULL)

## ----localcsv, eval=FALSE, message=FALSE, warning=FALSE-----------------------
# df <- read_bis("WS_CBPOL_csv_flat.csv")

## ----localzip, eval=FALSE, message=FALSE, warning=FALSE-----------------------
# df <- read_bis(.unzip_file("WS_CBPOL_csv_flat.zip"))

