/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.clock;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.logging.Logger;

public abstract class RateEvolutionLikelihood
extends AbstractBranchRateModel {
    public static final String RATES = "rates";
    public static final String EPISODIC = "episodic";
    public static final String LOGSPACE = "logspace";
    public static final String ROOTRATE = "rootRate";
    private double logLikelihood;
    private boolean likelihoodKnown = false;
    private final TreeModel treeModel;
    private final TreeParameterModel ratesParameter;
    protected final Parameter rootRateParameter;
    private final boolean isEpisodic;

    public RateEvolutionLikelihood(String string, TreeModel treeModel, Parameter parameter, Parameter parameter2, boolean bl) {
        super(string);
        this.treeModel = treeModel;
        this.addModel(treeModel);
        this.ratesParameter = new TreeParameterModel((MutableTreeModel)treeModel, parameter, false);
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension());
        parameter.addBounds(defaultBounds);
        this.addModel(this.ratesParameter);
        this.rootRateParameter = parameter2;
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter2);
        if (parameter2.getDimension() != 1) {
            throw new IllegalArgumentException("The root rate parameter must be of dimension 1");
        }
        this.isEpisodic = bl;
        Logger.getLogger("dr.evomodel").info("AutoCorrelated Relaxed Clock: " + string + (bl ? " (episodic)." : "."));
    }

    @Override
    public final void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
        if (model == this.ratesParameter) {
            this.fireModelChanged(this, n);
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.getLikelihoodKnown()) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    protected boolean getLikelihoodKnown() {
        return this.likelihoodKnown;
    }

    private double calculateLogLikelihood() {
        NodeRef nodeRef = this.treeModel.getRoot();
        NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.treeModel.getChild(nodeRef, 1);
        return this.calculateLogLikelihood(nodeRef, nodeRef2) + this.calculateLogLikelihood(nodeRef, nodeRef3);
    }

    private double calculateLogLikelihood(NodeRef nodeRef, NodeRef nodeRef2) {
        double d = this.treeModel.getBranchLength(nodeRef2);
        double d2 = this.branchRateChangeLogLikelihood(this.getBranchRate(this.treeModel, nodeRef), this.getBranchRate(this.treeModel, nodeRef2), d);
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef2); ++i) {
            d2 += this.calculateLogLikelihood(nodeRef2, this.treeModel.getChild(nodeRef2, i));
        }
        return d2;
    }

    @Override
    public String toString() {
        return Double.toString(this.getLogLikelihood());
    }

    abstract double branchRateSample(double var1, double var3);

    public void sampleRate(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
        double d = this.treeModel.getBranchLength(nodeRef);
        double d2 = this.branchRateSample(this.getBranchRate(this.treeModel, nodeRef2), d);
        this.treeModel.setNodeRate(nodeRef, d2);
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (tree.isRoot(nodeRef)) {
            return this.rootRateParameter.getParameterValue(0);
        }
        return this.ratesParameter.getNodeValue(tree, nodeRef);
    }

    public boolean isEpisodic() {
        return this.isEpisodic;
    }

    abstract double branchRateChangeLogLikelihood(double var1, double var3, double var5);
}

