/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.decomposition.SparseFloatCholeskyDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.SparseFloatLUDecomposition;
import cern.colt.matrix.tfloat.algo.decomposition.SparseFloatQRDecomposition;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_norm;

public class SparseFloatAlgebra {
    public static final SparseFloatAlgebra DEFAULT = new SparseFloatAlgebra();
    public static final SparseFloatAlgebra ZERO;
    protected FloatProperty property;

    private static float normInfinityRC(SparseRCFloatMatrix2D sparseRCFloatMatrix2D) {
        float f = 0.0f;
        int n = sparseRCFloatMatrix2D.rows();
        int[] nArray = sparseRCFloatMatrix2D.getRowPointers();
        float[] fArray = sparseRCFloatMatrix2D.getValues();
        for (int i = 0; i < n; ++i) {
            float f2 = 0.0f;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                f2 += Math.abs(fArray[j]);
            }
            f = Math.max(f, f2);
        }
        return f;
    }

    public SparseFloatAlgebra() {
        this(FloatProperty.DEFAULT.tolerance());
    }

    public SparseFloatAlgebra(float f) {
        this.setProperty(new FloatProperty(f));
    }

    public SparseFloatCholeskyDecomposition chol(FloatMatrix2D floatMatrix2D, int n) {
        return new SparseFloatCholeskyDecomposition(floatMatrix2D, n);
    }

    public Object clone() {
        return new SparseFloatAlgebra(this.property.tolerance());
    }

    public float det(FloatMatrix2D floatMatrix2D) {
        return this.lu(floatMatrix2D, 0).det();
    }

    public SparseFloatLUDecomposition lu(FloatMatrix2D floatMatrix2D, int n) {
        return new SparseFloatLUDecomposition(floatMatrix2D, n, true);
    }

    public float norm1(FloatMatrix2D floatMatrix2D) {
        FloatProperty.DEFAULT.checkSparse(floatMatrix2D);
        float f = floatMatrix2D instanceof SparseCCFloatMatrix2D ? Scs_norm.cs_norm((Scs_common.Scs)((Scs_common.Scs)floatMatrix2D.elements())) : Scs_norm.cs_norm((Scs_common.Scs)((SparseRCFloatMatrix2D)floatMatrix2D).getColumnCompressed().elements());
        return f;
    }

    public float normInfinity(FloatMatrix2D floatMatrix2D) {
        FloatProperty.DEFAULT.checkSparse(floatMatrix2D);
        float f = floatMatrix2D instanceof SparseRCFloatMatrix2D ? SparseFloatAlgebra.normInfinityRC((SparseRCFloatMatrix2D)floatMatrix2D) : SparseFloatAlgebra.normInfinityRC(((SparseCCFloatMatrix2D)floatMatrix2D).getRowCompressed());
        return f;
    }

    public FloatProperty property() {
        return this.property;
    }

    public SparseFloatQRDecomposition qr(FloatMatrix2D floatMatrix2D, int n) {
        return new SparseFloatQRDecomposition(floatMatrix2D, n);
    }

    public void setProperty(FloatProperty floatProperty) {
        if (this == DEFAULT && floatProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && floatProperty != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = floatProperty;
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(Math.max(floatMatrix2D.rows(), floatMatrix2D.columns()));
        denseFloatMatrix1D.viewPart(0, (int)floatMatrix1D.size()).assign(floatMatrix1D);
        if (floatMatrix2D.rows() == floatMatrix2D.columns()) {
            this.lu(floatMatrix2D, 0).solve(denseFloatMatrix1D);
            return denseFloatMatrix1D;
        }
        this.qr(floatMatrix2D, 0).solve(denseFloatMatrix1D);
        return denseFloatMatrix1D.viewPart(0, floatMatrix2D.columns()).copy();
    }

    static {
        SparseFloatAlgebra.DEFAULT.property = FloatProperty.DEFAULT;
        ZERO = new SparseFloatAlgebra();
        SparseFloatAlgebra.ZERO.property = FloatProperty.ZERO;
    }
}

