/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.misc.monotone.Coordinates;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.classifiers.misc.monotone.DistributionUtils;
import weka.classifiers.misc.monotone.EnumerationIterator;
import weka.classifiers.misc.monotone.NominalLossFunction;
import weka.classifiers.misc.monotone.ZeroOneLossFunction;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public abstract class OSDLCore
extends Classifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -9209888846680062897L;
    public static final int CT_REGRESSION = 0;
    public static final int CT_WEIGHTED_SUM = 1;
    public static final int CT_MAXPROB = 2;
    public static final int CT_MEDIAN = 3;
    public static final int CT_MEDIAN_REAL = 4;
    public static final Tag[] TAGS_CLASSIFICATIONTYPES = new Tag[]{new Tag(0, "REG", "Regression"), new Tag(1, "WSUM", "Weighted Sum"), new Tag(2, "MAX", "Maximum probability"), new Tag(3, "MED", "Median"), new Tag(4, "RMED", "Median without rounding")};
    private int m_ctype = 3;
    private Instances m_train;
    private Map m_estimatedDistributions;
    private Map m_estimatedCumulativeDistributions;
    private double m_s = 0.5;
    private double m_sLower = 0.0;
    private double m_sUpper = 1.0;
    private int m_sNrParts = 10;
    private boolean m_tuneInterpolationParameter = false;
    private boolean m_interpolationParameterValid = false;
    private boolean m_balanced = false;
    private boolean m_weighted = false;
    private Coordinates smallestElement;
    private Coordinates biggestElement;

    public String globalInfo() {
        return "This class is an implementation of the Ordinal Stochastic Dominance Learner.\nFurther information regarding the OSDL-algorithm can be found in:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "For more information about supervised ranking, see\n\n" + "http://users.ugent.be/~slievens/supervised_ranking.php";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "S. Lievens and B. De Baets and K. Cao-Van");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A Probabilistic Framework for the Design of Instance-Based Supervised Ranking Algorithms in an Ordinal Setting");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Annals of Operations Research");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.PHDTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Kim Cao-Van");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Supervised ranking: from semantics to algorithms");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Stijn Lievens");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Studie en implementatie van instantie-gebaseerde algoritmen voor gesuperviseerd rangschikken");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public double classifyInstance(Instance instance) throws Exception {
        try {
            return this.classifyInstance(instance, this.m_s, this.m_ctype);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError((Object)illegalArgumentException);
        }
    }

    private double classifyInstance(Instance instance, double d, int n) throws IllegalArgumentException, IllegalStateException {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Interpolation parameter is not valid " + d);
        }
        DiscreteDistribution discreteDistribution = null;
        discreteDistribution = !this.m_balanced ? this.distributionForInstance(instance, d) : this.distributionForInstanceBalanced(instance, d);
        if (discreteDistribution == null) {
            throw new IllegalStateException("Null distribution predicted");
        }
        double d2 = 0.0;
        switch (n) {
            case 0: 
            case 1: {
                d2 = discreteDistribution.mean();
                if (n != 1) break;
                d2 = Math.round(d2);
                break;
            }
            case 2: {
                d2 = discreteDistribution.modes()[0];
                break;
            }
            case 3: 
            case 4: {
                d2 = discreteDistribution.median();
                if (n != 3) break;
                d2 = Math.round(d2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid classification type!");
            }
        }
        return d2;
    }

    public double[] distributionForInstance(Instance instance) {
        if (this.m_tuneInterpolationParameter && !this.m_interpolationParameterValid) {
            this.tuneInterpolationParameter();
        }
        if (!this.m_balanced) {
            return this.distributionForInstance(instance, this.m_s).toArray();
        }
        return this.distributionForInstanceBalanced(instance, this.m_s).toArray();
    }

    public double[] cumulativeDistributionForInstance(Instance instance) {
        if (this.m_tuneInterpolationParameter && !this.m_interpolationParameterValid) {
            this.tuneInterpolationParameter();
        }
        if (!this.m_balanced) {
            return this.cumulativeDistributionForInstance(instance, this.m_s).toArray();
        }
        return this.cumulativeDistributionForInstanceBalanced(instance, this.m_s).toArray();
    }

    private DiscreteDistribution distributionForInstance(Instance instance, double d) {
        return new DiscreteDistribution(this.cumulativeDistributionForInstance(instance, d));
    }

    private DiscreteDistribution distributionForInstanceBalanced(Instance instance, double d) {
        return new DiscreteDistribution(this.cumulativeDistributionForInstanceBalanced(instance, d));
    }

    private CumulativeDiscreteDistribution cumulativeDistributionForInstance(Instance instance, double d) {
        Coordinates coordinates = new Coordinates(instance);
        int n = instance.numClasses();
        int n2 = 0;
        int n3 = 0;
        if (!this.containsSmallestElement()) {
            n2 = 1;
        }
        if (!this.containsBiggestElement()) {
            n3 = 1;
        }
        CumulativeDiscreteDistribution cumulativeDiscreteDistribution = DistributionUtils.getMinimalCumulativeDiscreteDistribution(n);
        CumulativeDiscreteDistribution cumulativeDiscreteDistribution2 = DistributionUtils.getMaximalCumulativeDiscreteDistribution(n);
        for (Coordinates coordinates2 : this.m_estimatedCumulativeDistributions.keySet()) {
            CumulativeDiscreteDistribution cumulativeDiscreteDistribution3 = (CumulativeDiscreteDistribution)this.m_estimatedCumulativeDistributions.get(coordinates2);
            if (coordinates2.equals(coordinates)) {
                ++n2;
                cumulativeDiscreteDistribution = DistributionUtils.takeMin(cumulativeDiscreteDistribution, cumulativeDiscreteDistribution3);
                ++n3;
                cumulativeDiscreteDistribution2 = DistributionUtils.takeMax(cumulativeDiscreteDistribution2, cumulativeDiscreteDistribution3);
                continue;
            }
            if (coordinates2.strictlySmaller(coordinates)) {
                ++n2;
                cumulativeDiscreteDistribution = DistributionUtils.takeMin(cumulativeDiscreteDistribution, cumulativeDiscreteDistribution3);
                continue;
            }
            if (!coordinates.strictlySmaller(coordinates2)) continue;
            ++n3;
            cumulativeDiscreteDistribution2 = DistributionUtils.takeMax(cumulativeDiscreteDistribution2, cumulativeDiscreteDistribution3);
        }
        if (this.m_weighted) {
            d = (double)n2 / (double)(n2 + n3);
            if (this.m_Debug) {
                System.err.println("Weighted OSDL: interpolation parameter is s = " + d);
            }
        }
        return DistributionUtils.interpolate(cumulativeDiscreteDistribution, cumulativeDiscreteDistribution2, 1.0 - d);
    }

    private boolean containsSmallestElement() {
        return this.m_estimatedCumulativeDistributions.containsKey(this.smallestElement);
    }

    private boolean containsBiggestElement() {
        return this.m_estimatedCumulativeDistributions.containsKey(this.biggestElement);
    }

    private CumulativeDiscreteDistribution cumulativeDistributionForInstanceBalanced(Instance instance, double d) {
        Coordinates coordinates = new Coordinates(instance);
        int n = instance.numClasses();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        CumulativeDiscreteDistribution cumulativeDiscreteDistribution = DistributionUtils.getMinimalCumulativeDiscreteDistribution(n);
        CumulativeDiscreteDistribution cumulativeDiscreteDistribution2 = DistributionUtils.getMaximalCumulativeDiscreteDistribution(n);
        for (Coordinates coordinates2 : this.m_estimatedCumulativeDistributions.keySet()) {
            DiscreteEstimator discreteEstimator;
            CumulativeDiscreteDistribution cumulativeDiscreteDistribution3 = (CumulativeDiscreteDistribution)this.m_estimatedCumulativeDistributions.get(coordinates2);
            if (coordinates2.equals(coordinates)) {
                discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(coordinates2);
                this.updateN_m(nArray, discreteEstimator);
                this.updateN_M(nArray2, discreteEstimator);
                cumulativeDiscreteDistribution = DistributionUtils.takeMin(cumulativeDiscreteDistribution, cumulativeDiscreteDistribution3);
                cumulativeDiscreteDistribution2 = DistributionUtils.takeMax(cumulativeDiscreteDistribution2, cumulativeDiscreteDistribution3);
                continue;
            }
            if (coordinates2.strictlySmaller(coordinates)) {
                discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(coordinates2);
                this.updateN_m(nArray, discreteEstimator);
                cumulativeDiscreteDistribution = DistributionUtils.takeMin(cumulativeDiscreteDistribution, cumulativeDiscreteDistribution3);
                continue;
            }
            if (!coordinates.strictlySmaller(coordinates2)) continue;
            discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(coordinates2);
            this.updateN_M(nArray2, discreteEstimator);
            cumulativeDiscreteDistribution2 = DistributionUtils.takeMax(cumulativeDiscreteDistribution2, cumulativeDiscreteDistribution3);
        }
        Object object = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2 = cumulativeDiscreteDistribution.getCumulativeProbability(i);
            double d3 = cumulativeDiscreteDistribution2.getCumulativeProbability(i);
            if (this.m_weighted) {
                if (d2 < d3) {
                    object[i] = ((double)nArray[i] * d2 + (double)nArray2[i] * d3) / (double)(nArray[i] + nArray2[i]);
                    continue;
                }
                if (nArray[i] + nArray2[i] == 0) {
                    object[i] = d * d2 + (1.0 - d) * d3;
                    continue;
                }
                object[i] = ((double)nArray2[i] * d2 + (double)nArray[i] * d3) / (double)(nArray[i] + nArray2[i]);
                continue;
            }
            object[i] = d2 < d3 ? ((double)nArray[i] * d2 + (double)nArray2[i] * d3) / (double)(nArray[i] + nArray2[i]) : d * d2 + (1.0 - d) * d3;
        }
        try {
            return new CumulativeDiscreteDistribution((double[])object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("We tried to create a cumulative discrete distribution from the following array");
            for (int i = 0; i < ((Object)object).length; ++i) {
                System.err.print((double)object[i] + " ");
            }
            System.err.println();
            throw new AssertionError(object);
        }
    }

    private void updateN_m(int[] nArray, DiscreteEstimator discreteEstimator) {
        int[] nArray2 = new int[nArray.length];
        nArray2[0] = (int)discreteEstimator.getSumOfCounts() - (int)discreteEstimator.getCount(0.0);
        nArray[0] = nArray[0] + nArray2[0];
        for (int i = 1; i < nArray.length; ++i) {
            nArray2[i] = nArray2[i - 1] - (int)discreteEstimator.getCount(i);
            int n = i;
            nArray[n] = nArray[n] + nArray2[i];
        }
        if (nArray[nArray.length - 1] != 0) {
            System.err.println("******** Problem with n_m in " + this.m_train.relationName());
            System.err.println("Last argument is non-zero, namely : " + nArray[nArray.length - 1]);
        }
    }

    private void updateN_M(int[] nArray, DiscreteEstimator discreteEstimator) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        nArray2[n - 1] = (int)discreteEstimator.getSumOfCounts();
        int n2 = n - 1;
        nArray[n2] = nArray[n2] + nArray2[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            nArray2[i] = nArray2[i + 1] - (int)discreteEstimator.getCount(i + 1);
            int n3 = i;
            nArray[n3] = nArray[n3] + nArray2[i];
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        Serializable serializable;
        Serializable serializable22;
        this.getCapabilities().testWithFail(instances);
        this.m_train = new Instances(instances);
        this.m_train.deleteWithMissingClass();
        this.m_estimatedDistributions = new HashMap(this.m_train.numInstances() / 2);
        Object object = new EnumerationIterator(instances.enumerateInstances());
        while (object.hasNext()) {
            serializable22 = (Instance)object.next();
            serializable = new Coordinates((Instance)serializable22);
            DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(serializable);
            if (discreteEstimator == null) {
                discreteEstimator = new DiscreteEstimator(instances.numClasses(), 0.0);
            }
            discreteEstimator.addValue(((Instance)serializable22).classValue(), ((Instance)serializable22).weight());
            this.m_estimatedDistributions.put(serializable, discreteEstimator);
        }
        this.m_estimatedCumulativeDistributions = new HashMap(this.m_estimatedDistributions.size() / 2);
        for (Serializable serializable22 : this.m_estimatedDistributions.keySet()) {
            serializable = (DiscreteEstimator)this.m_estimatedDistributions.get(serializable22);
            this.m_estimatedCumulativeDistributions.put(serializable22, new CumulativeDiscreteDistribution((DiscreteEstimator)serializable));
        }
        if (this.m_tuneInterpolationParameter && !this.m_interpolationParameterValid) {
            this.tuneInterpolationParameter();
        }
        object = new double[instances.numAttributes()];
        serializable22 = new Instance(1.0, (double[])object);
        ((Instance)serializable22).setDataset(instances);
        this.smallestElement = new Coordinates((Instance)serializable22);
        if (this.m_Debug) {
            System.err.println("minimal element of data space = " + this.smallestElement);
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (double)(instances.attribute(i).numValues() - 1);
        }
        serializable22 = new Instance(1.0, (double[])object);
        ((Instance)serializable22).setDataset(instances);
        this.biggestElement = new Coordinates((Instance)serializable22);
        if (this.m_Debug) {
            System.err.println("maximal element of data space = " + this.biggestElement);
        }
    }

    public String classificationTypeTipText() {
        return "Sets the way in which a single label will be extracted from the estimated distribution.";
    }

    public void setClassificationType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_CLASSIFICATIONTYPES) {
            this.m_ctype = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getClassificationType() {
        return new SelectedTag(this.m_ctype, TAGS_CLASSIFICATIONTYPES);
    }

    public String tuneInterpolationParameterTipText() {
        return "Whether to tune the interpolation parameter based on the bounds.";
    }

    public void setTuneInterpolationParameter(boolean bl) {
        this.m_tuneInterpolationParameter = bl;
    }

    public boolean getTuneInterpolationParameter() {
        return this.m_tuneInterpolationParameter;
    }

    public String interpolationParameterLowerBoundTipText() {
        return "Sets the lower bound for the interpolation parameter tuning (0 <= x < 1).";
    }

    public void setInterpolationParameterLowerBound(double d) {
        if (d < 0.0 || d >= 1.0 || d > this.getInterpolationParameterUpperBound()) {
            throw new IllegalArgumentException("Illegal lower bound");
        }
        this.m_sLower = d;
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = false;
    }

    public double getInterpolationParameterLowerBound() {
        return this.m_sLower;
    }

    public String interpolationParameterUpperBoundTipText() {
        return "Sets the upper bound for the interpolation parameter tuning (0 < x <= 1).";
    }

    public void setInterpolationParameterUpperBound(double d) {
        if (d <= 0.0 || d > 1.0 || d < this.getInterpolationParameterLowerBound()) {
            throw new IllegalArgumentException("Illegal upper bound");
        }
        this.m_sUpper = d;
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = false;
    }

    public double getInterpolationParameterUpperBound() {
        return this.m_sUpper;
    }

    public void setInterpolationParameterBounds(double d, double d2) throws IllegalArgumentException {
        if (d < 0.0 || d2 > 1.0 || d > d2) {
            throw new IllegalArgumentException("Illegal upper and lower bounds");
        }
        this.m_sLower = d;
        this.m_sUpper = d2;
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = false;
    }

    public String interpolationParameterTipText() {
        return "Sets the value of the interpolation parameter s;Estimated distribution is s * f_min + (1 - s) *  f_max. ";
    }

    public void setInterpolationParameter(double d) throws IllegalArgumentException {
        if (0.0 > d || d > 1.0) {
            throw new IllegalArgumentException("Interpolationparameter exceeds bounds");
        }
        this.m_tuneInterpolationParameter = false;
        this.m_interpolationParameterValid = false;
        this.m_s = d;
    }

    public double getInterpolationParameter() {
        return this.m_s;
    }

    public String numberOfPartsForInterpolationParameterTipText() {
        return "Sets the granularity for tuning the interpolation parameter; For instance if the value is 32 then 33 values for the interpolation are checked.";
    }

    public void setNumberOfPartsForInterpolationParameter(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of parts is negative");
        }
        this.m_tuneInterpolationParameter = true;
        if (this.m_sNrParts != n) {
            this.m_interpolationParameterValid = false;
            this.m_sNrParts = n;
        }
    }

    public int getNumberOfPartsForInterpolationParameter() {
        return this.m_sNrParts;
    }

    public String balancedTipText() {
        return "If true, the balanced version of the OSDL-algorithm is used\nThis means that distinction is made between the normal and reversed preference situation.";
    }

    public void setBalanced(boolean bl) {
        this.m_balanced = bl;
    }

    public boolean getBalanced() {
        return this.m_balanced;
    }

    public String weightedTipText() {
        return "If true, the weighted version of the OSDL-algorithm is used";
    }

    public void setWeighted(boolean bl) {
        this.m_weighted = bl;
    }

    public boolean getWeighted() {
        return this.m_weighted;
    }

    public double getLowerBound() {
        return this.m_sLower;
    }

    public double getUpperBound() {
        return this.m_sUpper;
    }

    public int getNumInstances() {
        return this.m_train.numInstances();
    }

    public double tuneInterpolationParameter() {
        try {
            return this.tuneInterpolationParameter(this.m_sLower, this.m_sUpper, this.m_sNrParts, this.m_ctype);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError((Object)illegalArgumentException);
        }
    }

    public double tuneInterpolationParameter(double d, double d2, int n, int n2) throws IllegalArgumentException {
        this.setInterpolationParameterBounds(d, d2);
        this.setNumberOfPartsForInterpolationParameter(n);
        this.setClassificationType(new SelectedTag(n2, TAGS_CLASSIFICATIONTYPES));
        this.m_s = this.crossValidate(d, d2, n, n2);
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = true;
        return this.m_s;
    }

    public double crossValidate() throws IllegalArgumentException {
        return this.crossValidate(this.m_sLower, this.m_sUpper, this.m_sNrParts, this.m_ctype);
    }

    public double crossValidate(double d, double d2, int n, int n2) throws IllegalArgumentException {
        double[] dArray = new double[n + 1];
        return this.crossValidate(d, d2, n, n2, dArray, new ZeroOneLossFunction());
    }

    public double crossValidate(double d, double d2, int n, int n2, double[] dArray, NominalLossFunction nominalLossFunction) throws IllegalArgumentException {
        Object object;
        if (dArray.length < n + 1) {
            throw new IllegalArgumentException("Length of array is not sufficient");
        }
        if (!this.interpolationParametersValid(d, d2, n)) {
            throw new IllegalArgumentException("Interpolation parameters are not valid");
        }
        if (!this.classificationTypeValid(n2)) {
            throw new IllegalArgumentException("Not a valid classification type " + n2);
        }
        Arrays.fill(dArray, 0, n + 1, 0.0);
        Object object2 = new EnumerationIterator(this.m_train.enumerateInstances());
        while (object2.hasNext()) {
            object = (Instance)object2.next();
            double d3 = ((Instance)object).classValue();
            this.removeInstance((Instance)object);
            double d4 = d;
            double d5 = (d2 - d) / (double)n;
            int n3 = 0;
            while (n3 <= n) {
                try {
                    int n4 = n3;
                    dArray[n4] = dArray[n4] + nominalLossFunction.loss(d3, this.classifyInstance((Instance)object, d4, n2));
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(1);
                }
                ++n3;
                d4 += d5;
            }
            this.addInstance((Instance)object);
        }
        object2 = dArray;
        if (dArray.length > n + 1) {
            object2 = new double[n + 1];
            System.arraycopy(dArray, 0, object2, 0, ((Object)object2).length);
        }
        object = Utils.stableSort((double[])object2);
        Object object3 = 0;
        while (object3 + 1 < ((Object)object2).length && object2[object[object3 + 1]] == object2[object[object3]]) {
            ++object3;
        }
        object3 = object[object3 / 2];
        return d + (double)object3 * (d2 - d) / (double)n;
    }

    private boolean classificationTypeValid(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 4;
    }

    private boolean interpolationParametersValid(double d, double d2, int n) {
        return d >= 0.0 && d2 <= 1.0 && d < d2 && n > 0 || d == d2 && n == 0;
    }

    private void removeInstance(Instance instance) {
        Coordinates coordinates = new Coordinates(instance);
        DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(coordinates);
        discreteEstimator.addValue(instance.classValue(), -instance.weight());
        if (Math.abs(discreteEstimator.getSumOfCounts() - 0.0) < Utils.SMALL) {
            this.m_estimatedDistributions.remove(coordinates);
            this.m_estimatedCumulativeDistributions.remove(coordinates);
        } else {
            this.m_estimatedDistributions.put(coordinates, discreteEstimator);
            this.m_estimatedCumulativeDistributions.put(coordinates, new CumulativeDiscreteDistribution(discreteEstimator));
        }
    }

    private void addInstance(Instance instance) {
        Coordinates coordinates = new Coordinates(instance);
        DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_estimatedDistributions.get(coordinates);
        if (discreteEstimator == null) {
            discreteEstimator = new DiscreteEstimator(instance.dataset().numClasses(), 0.0);
        }
        discreteEstimator.addValue(instance.classValue(), instance.weight());
        this.m_estimatedDistributions.put(coordinates, discreteEstimator);
        this.m_estimatedCumulativeDistributions.put(coordinates, new CumulativeDiscreteDistribution(discreteEstimator));
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String string = "\tSets the classification type to be used.\n\t(Default: " + new SelectedTag(3, TAGS_CLASSIFICATIONTYPES) + ")";
        String string2 = "-C " + Tag.toOptionList(TAGS_CLASSIFICATIONTYPES);
        String string3 = "C";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tUse the balanced version of the Ordinal Stochastic Dominance Learner";
        string2 = "-B";
        string3 = "B";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tUse the weighted version of the Ordinal Stochastic Dominance Learner";
        string2 = "-W";
        string3 = "W";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tSets the value of the interpolation parameter (not with -W/T/P/L/U)\n\t(default: 0.5).";
        string2 = "-S <value of interpolation parameter>";
        string3 = "S";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tTune the interpolation parameter (not with -W/S)\n\t(default: off)";
        string2 = "-T";
        string3 = "T";
        vector.addElement(new Option(string, string3, 0, string2));
        string = "\tLower bound for the interpolation parameter (not with -W/S)\n\t(default: 0)";
        string2 = "-L <Lower bound for interpolation parameter>";
        string3 = "L";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tUpper bound for the interpolation parameter (not with -W/S)\n\t(default: 1)";
        string2 = "-U <Upper bound for interpolation parameter>";
        string3 = "U";
        vector.addElement(new Option(string, string3, 1, string2));
        string = "\tDetermines the step size for tuning the interpolation\n\tparameter, nl. (U-L)/P (not with -W/S)\n\t(default: 10)";
        string2 = "-P <Number of parts>";
        string3 = "P";
        vector.addElement(new Option(string, string3, 1, string2));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setClassificationType(new SelectedTag(string, TAGS_CLASSIFICATIONTYPES));
        } else {
            this.setClassificationType(new SelectedTag(3, TAGS_CLASSIFICATIONTYPES));
        }
        this.setBalanced(Utils.getFlag('B', stringArray));
        if (Utils.getFlag('W', stringArray)) {
            this.m_weighted = true;
            Utils.getOption('T', stringArray);
            Utils.getOption('S', stringArray);
            Utils.getOption('P', stringArray);
            Utils.getOption('L', stringArray);
            Utils.getOption('U', stringArray);
        } else {
            this.m_tuneInterpolationParameter = Utils.getFlag('T', stringArray);
            if (!this.m_tuneInterpolationParameter) {
                Utils.getOption('P', stringArray);
                Utils.getOption('L', stringArray);
                Utils.getOption('U', stringArray);
                string = Utils.getOption('S', stringArray);
                if (string.length() != 0) {
                    this.setInterpolationParameter(Double.parseDouble(string));
                } else {
                    this.setInterpolationParameter(0.5);
                }
            } else {
                Utils.getOption('S', stringArray);
                string = Utils.getOption('L', stringArray);
                double d = this.m_sLower;
                d = string.length() != 0 ? Double.parseDouble(string) : 0.0;
                string = Utils.getOption('U', stringArray);
                double d2 = this.m_sUpper;
                d2 = string.length() != 0 ? Double.parseDouble(string) : 1.0;
                if (this.m_tuneInterpolationParameter) {
                    this.setInterpolationParameterBounds(d, d2);
                }
                if ((string = Utils.getOption('P', stringArray)).length() != 0) {
                    this.setNumberOfPartsForInterpolationParameter(Integer.parseInt(string));
                } else {
                    this.setNumberOfPartsForInterpolationParameter(10);
                }
            }
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add("" + this.getClassificationType());
        if (this.m_balanced) {
            vector.add("-B");
        }
        if (this.m_weighted) {
            vector.add("-W");
        } else if (!this.m_tuneInterpolationParameter) {
            vector.add("-S");
            vector.add(Double.toString(this.m_s));
        } else {
            vector.add("-T");
            vector.add("-L");
            vector.add(Double.toString(this.m_sLower));
            vector.add("-U");
            vector.add(Double.toString(this.m_sUpper));
            vector.add("-P");
            vector.add(Integer.toString(this.m_sNrParts));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_balanced) {
            stringBuffer.append("Balanced OSDL\n=============\n\n");
        } else {
            stringBuffer.append("Ordinary OSDL\n=============\n\n");
        }
        if (this.m_weighted) {
            stringBuffer.append("Weighted variant\n");
        }
        stringBuffer.append("Classification type: " + this.getClassificationType() + "\n");
        if (!this.m_weighted) {
            stringBuffer.append("Interpolation parameter: " + this.m_s + "\n");
            if (this.m_tuneInterpolationParameter) {
                stringBuffer.append("Bounds and stepsize: " + this.m_sLower + " " + this.m_sUpper + " " + this.m_sNrParts + "\n");
                if (!this.m_interpolationParameterValid) {
                    stringBuffer.append("Interpolation parameter is not valid");
                }
            }
        }
        if (this.m_Debug && this.m_estimatedCumulativeDistributions != null) {
            for (Coordinates coordinates : this.m_estimatedCumulativeDistributions.keySet()) {
                CumulativeDiscreteDistribution cumulativeDiscreteDistribution = (CumulativeDiscreteDistribution)this.m_estimatedCumulativeDistributions.get(coordinates);
                stringBuffer.append("[" + coordinates.hashCode() + "] " + coordinates.toString() + " --> " + cumulativeDiscreteDistribution.toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

