/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.Basic;

import java.util.ArrayList;
import java.util.Arrays;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceAttributes;

public class Prototype {
    boolean normalized = false;
    public static final int UNKNOW_INDEX = -1;
    protected int index = -1;
    protected static int[] type;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;
    public static final int NOMINAL = 2;
    protected double[] inputs = null;
    protected double[] outputs = null;

    protected static double normalize(double min, double max, double value) {
        if (value <= min) {
            return 0.0;
        }
        return (value - min) / (max - min);
    }

    public static void setAttributesTypes(InstanceAttributes att) {
        int numAtt = att.getNumAttributes();
        type = new int[numAtt];
        for (int i = 0; i < numAtt; ++i) {
            Attribute a = att.getAttribute(i);
            if (a.getType() == 1) {
                Prototype.type[i] = 0;
                continue;
            }
            if (a.getType() == 2) {
                Prototype.type[i] = 1;
                continue;
            }
            if (a.getType() != 0) continue;
            Prototype.type[i] = 2;
        }
    }

    public static int getTypeOfAttribute(int i) {
        return type[i];
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Prototype() {
        this.inputs = null;
        this.outputs = null;
        this.index = -1;
    }

    public Prototype(int numInput, int numOutput) {
        this.inputs = new double[numInput];
        this.outputs = new double[numOutput];
        this.index = -1;
    }

    public Prototype(double[] inputs, double[] outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.index = -1;
    }

    public Prototype(Instance inst) {
        this.normalized = true;
        this.inputs = inst.getAllInputValues();
        this.outputs = inst.getNormalizedOutputValues();
        this.index = -1;
        int size = this.getInputs().length;
        for (int i = 0; i < size; ++i) {
            double maxi = Attributes.getAttribute(i).getMaxAttribute();
            double mini = Attributes.getAttribute(i).getMinAttribute();
            if (type[i] == 0 || type[i] == 1) {
                this.inputs[i] = Prototype.normalize(mini, maxi, this.inputs[i]);
                if (!(this.inputs[i] < 0.0)) continue;
                this.inputs[i] = 0.0;
                continue;
            }
            if (type[i] != 2) continue;
            maxi = Attributes.getAttribute(i).getNumNominalValues() - 1;
            mini = 0.0;
            this.inputs[i] = Prototype.normalize(mini, maxi, this.inputs[i]);
        }
    }

    public Prototype(Prototype original) {
        this.inputs = Arrays.copyOf(original.inputs, original.inputs.length);
        this.outputs = Arrays.copyOf(original.outputs, original.outputs.length);
        this.index = original.index;
        this.normalized = original.normalized;
    }

    public void set(Prototype original) {
        this.inputs = Arrays.copyOf(original.inputs, original.inputs.length);
        this.outputs = Arrays.copyOf(original.outputs, original.outputs.length);
        this.normalized = original.normalized;
    }

    public double[] getInputs() {
        return this.inputs;
    }

    public double getInput(int i) {
        return this.inputs[i];
    }

    public void setInput(int i, double valor) {
        this.inputs[i] = valor;
    }

    public double[] getOutputs() {
        return this.inputs;
    }

    public double getOutput(int i) {
        return this.outputs[i];
    }

    public double firstOutput() {
        return this.outputs[0];
    }

    public double label() {
        return this.firstOutput();
    }

    public double assignedClass() {
        return this.firstOutput();
    }

    public int numberOfInputs() {
        return this.inputs.length;
    }

    public void setFirstOutput(double val) {
        this.outputs[0] = val;
    }

    public void setClass(double val) {
        this.setFirstOutput(val);
    }

    public void setLabel(double val) {
        this.setFirstOutput(val);
    }

    public int numberOfOutputs() {
        return this.outputs.length;
    }

    public Prototype mul(Prototype other) {
        int numInputs = this.numberOfInputs();
        double[] _inputs = new double[numInputs];
        int numOutputs = this.numberOfOutputs();
        double[] _outputs = new double[numOutputs];
        if (other.numberOfInputs() == this.numberOfInputs()) {
            for (int i = 0; i < numInputs; ++i) {
                _inputs[i] = other.inputs[i] * this.inputs[i];
            }
        }
        _outputs = Arrays.copyOf(this.outputs, this.outputs.length);
        return new Prototype(_inputs, _outputs);
    }

    public double mulEscalar(Prototype other) {
        int numInputs = this.numberOfInputs();
        double[] _inputs = new double[numInputs];
        double suma = 0.0;
        if (other.numberOfInputs() == this.numberOfInputs()) {
            for (int i = 0; i < numInputs; ++i) {
                suma += other.inputs[i] * this.inputs[i];
            }
        }
        return suma;
    }

    public Prototype mul(double weight) {
        int numInputs = this.numberOfInputs();
        double[] _inputs = new double[numInputs];
        int numOutputs = this.numberOfOutputs();
        double[] _outputs = new double[numOutputs];
        for (int i = 0; i < numInputs; ++i) {
            _inputs[i] = weight * this.inputs[i];
        }
        _outputs = Arrays.copyOf(this.outputs, this.outputs.length);
        return new Prototype(_inputs, _outputs);
    }

    public Prototype sqrt() {
        int numInputs = this.numberOfInputs();
        double[] _inputs = new double[numInputs];
        int numOutputs = this.numberOfOutputs();
        double[] _outputs = new double[numOutputs];
        for (int i = 0; i < numInputs; ++i) {
            _inputs[i] = Math.sqrt(this.inputs[i]);
        }
        _outputs = Arrays.copyOf(this.outputs, this.outputs.length);
        return new Prototype(_inputs, _outputs);
    }

    public double module() {
        double result = 0.0;
        for (int i = 0; i < this.inputs.length; ++i) {
            result += this.inputs[i] * this.inputs[i];
        }
        return Math.sqrt(result);
    }

    public Prototype add(double increment) {
        Prototype p = new Prototype(this);
        for (int i = 0; i < p.inputs.length; ++i) {
            p.setInput(i, p.getInput(i) + increment);
        }
        return p;
    }

    public Prototype add(Prototype other) {
        int numInputs = this.numberOfInputs();
        double[] _inputs = new double[numInputs];
        int numOutputs = this.numberOfOutputs();
        double[] _outputs = new double[numOutputs];
        for (int i = 0; i < numInputs; ++i) {
            _inputs[i] = this.inputs[i] + other.inputs[i];
        }
        _outputs = Arrays.copyOf(this.outputs, this.outputs.length);
        return new Prototype(_inputs, _outputs);
    }

    public Prototype addMul(Prototype other, double weight) {
        return this.add(other).mul(weight);
    }

    public Prototype addDiv(Prototype other, double divisor) {
        double weight = 1.0 / divisor;
        return this.addMul(other, weight);
    }

    public Prototype avg(Prototype other) {
        return this.addMul(other, 0.5);
    }

    public static Prototype avg(Prototype p1, Prototype p2) {
        return p1.avg(p2);
    }

    public static Prototype avg(Prototype p1, double w1, Prototype p2, double w2) {
        Prototype averaged = new Prototype(p1);
        double denominator = 1.0 / (w1 + w2);
        int numInputs = p1.numberOfInputs();
        int i = 0;
        while (i < numInputs) {
            averaged.inputs[i] = w1 * p1.inputs[i] + w2 * p2.inputs[i];
            int n = i++;
            averaged.inputs[n] = averaged.inputs[n] * denominator;
        }
        return averaged;
    }

    public Prototype sub(Prototype other) {
        int numInputs = this.numberOfInputs();
        double[] _inputs = new double[numInputs];
        int numOutputs = this.numberOfOutputs();
        double[] _outputs = new double[numOutputs];
        for (int i = 0; i < numInputs; ++i) {
            _inputs[i] = this.inputs[i] - other.inputs[i];
        }
        _outputs = Arrays.copyOf(this.outputs, this.outputs.length);
        return new Prototype(_inputs, _outputs);
    }

    public Prototype subMul(Prototype other, double weight) {
        return this.sub(other).mul(weight);
    }

    public String toString() {
        int i;
        String result = "";
        int nInputs = this.numberOfInputs();
        int nOutputs = this.numberOfOutputs();
        for (i = 0; i < nInputs; ++i) {
            result = result + this.inputs[i] + " ";
        }
        for (i = 0; i < nOutputs; ++i) {
            result = result + this.outputs[i] + " ";
        }
        return result;
    }

    protected static double round(double value) {
        String s = Double.toString(value);
        String[] comma = s.split("\\.");
        if (comma.length > 1) {
            if (comma[1].indexOf("E") < 0) {
                int pos1 = comma[1].indexOf("0000");
                int pos2 = comma[1].indexOf("9999");
                if (pos1 >= 0) {
                    comma[1] = comma[1].substring(0, pos1);
                    if (comma[1].length() == 0) {
                        comma[1] = "0";
                    }
                } else if (pos2 >= 0) {
                    comma[1] = comma[1].substring(0, pos2);
                    if (comma[1].length() == 0) {
                        comma[1] = "0";
                        int redondo = Integer.parseInt(comma[0]);
                        comma[0] = String.valueOf(++redondo);
                    } else {
                        long redondo = Long.parseLong(comma[1].substring(comma[1].length() - 1));
                        comma[1] = comma[1].substring(0, comma[1].length() - 1) + String.valueOf(++redondo);
                    }
                }
            }
            return Double.valueOf(comma[0] + "." + comma[1]);
        }
        return Double.valueOf(comma[0]);
    }

    public Prototype denormalize() {
        int i;
        int nInputs = this.numberOfInputs();
        int nOutputs = this.numberOfOutputs();
        double[] max_inputs = new double[nInputs];
        double[] min_inputs = new double[nInputs];
        double[] new_inputs = new double[nInputs];
        double[] new_outputs = new double[nOutputs];
        for (i = 0; i < nInputs; ++i) {
            max_inputs[i] = Attributes.getInputAttribute(i).getMaxAttribute();
            min_inputs[i] = Attributes.getInputAttribute(i).getMinAttribute();
        }
        for (i = 0; i < nInputs; ++i) {
            double value = this.inputs[i] * (max_inputs[i] - min_inputs[i]) + min_inputs[i];
            if (type[i] == 1) {
                new_inputs[i] = value;
            }
            if (type[i] == 0) {
                new_inputs[i] = Prototype.round(1.0 * this.inputs[i] * (max_inputs[i] - min_inputs[i]) + min_inputs[i]);
                new_inputs[i] = Math.round(new_inputs[i]);
            }
            if (type[i] != 2) continue;
            double maxi = Attributes.getAttribute(i).getNumNominalValues() - 1;
            double mini = 0.0;
            new_inputs[i] = this.inputs[i] * (maxi - mini) + mini;
        }
        new_outputs = Arrays.copyOf(this.outputs, this.outputs.length);
        return new Prototype(new_inputs, new_outputs);
    }

    public String getInputAsNominal(int i) {
        int indexOfNominalAttr = 0;
        if (this.normalized) {
            double maxInput_i = Attributes.getInputAttribute(i).getNumNominalValues() - 1;
            double minInput_i = 0.0;
            indexOfNominalAttr = (int)Prototype.normalize(minInput_i, maxInput_i, this.inputs[i]);
        } else {
            indexOfNominalAttr = (int)Math.round(this.inputs[i]);
        }
        return Attributes.getInputAttribute(i).getNominalValue(indexOfNominalAttr);
    }

    public String getOutputAsNominal(int i) {
        int _index = (int)Math.round(this.outputs[i]);
        return Attributes.getOutputAttribute(i).getNominalValue(_index);
    }

    public static ArrayList<Double> possibleValuesOfOutput() {
        Attribute[] a = Attributes.getOutputAttributes();
        if (a[0].getType() == 0) {
            int _size = a[0].getNominalValuesList().size();
            ArrayList<Double> v = new ArrayList<Double>();
            for (int i = 0; i < _size; ++i) {
                v.add(Double.valueOf(i));
            }
            return v;
        }
        ArrayList<Double> v = new ArrayList<Double>();
        double max = a[0].getMaxAttribute();
        double min = a[0].getMinAttribute();
        System.out.println("el atributo NO es nominal");
        v.add(min);
        v.add(max);
        return v;
    }

    public boolean equals(Prototype other) {
        return Arrays.equals(this.inputs, other.inputs) && Arrays.equals(this.outputs, other.outputs);
    }

    public boolean equalsInputs(Prototype other) {
        return Arrays.equals(this.inputs, other.inputs);
    }

    public void applyThresholds() {
        int nInputs = this.numberOfInputs();
        for (int i = 0; i < nInputs; ++i) {
            if (this.inputs[i] > 1.0) {
                this.inputs[i] = 1.0;
                continue;
            }
            if (!(this.inputs[i] < 0.0)) continue;
            this.inputs[i] = 0.0;
        }
    }

    public void makeNull() {
        int i;
        int nInputs = this.numberOfInputs();
        int nOutputs = this.numberOfOutputs();
        for (i = 0; i < nInputs; ++i) {
            this.inputs[i] = 0.0;
        }
        for (i = 0; i < nOutputs; ++i) {
            this.outputs[i] = 0.0;
        }
    }

    public void print() {
        System.out.print("\n");
        for (int i = 0; i < this.inputs.length; ++i) {
            System.out.print(this.inputs[i] + "  ");
        }
        System.out.print(this.outputs[0] + "\n");
    }

    public Prototype opposite() {
        Prototype opuesto = new Prototype(this);
        for (int i = 0; i < this.inputs.length; ++i) {
            opuesto.inputs[i] = 1.0 - this.inputs[i];
        }
        return opuesto;
    }

    public Prototype formatear() {
        Prototype formateado = new Prototype(this);
        int nInputs = this.numberOfInputs();
        double[] max_inputs = new double[nInputs];
        double[] max_inputsI = new double[nInputs];
        double[] min_inputsI = new double[nInputs];
        for (int i = 0; i < nInputs; ++i) {
            max_inputs[i] = Attributes.getAttribute(i).getNumNominalValues() - 1;
            max_inputsI[i] = Attributes.getInputAttribute(i).getMaxAttribute();
            min_inputsI[i] = Attributes.getInputAttribute(i).getMinAttribute();
        }
        double coef = 0.0;
        int aux = 0;
        for (int i = 0; i < this.inputs.length; ++i) {
            if (type[i] == 2) {
                coef = 1.0 / max_inputs[i];
                aux = (int)Math.round(1.0 * this.inputs[i] / coef);
                formateado.inputs[i] = (double)aux * coef;
            }
            if (type[i] != 0) continue;
            coef = 1.0 / (max_inputsI[i] - min_inputsI[i]);
            aux = (int)Math.round(1.0 * this.inputs[i] / coef);
            formateado.inputs[i] = (double)aux * coef;
        }
        return formateado;
    }
}

