/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multisyntaxtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.exprtree.IPrimitive;
import net.sourceforge.jclec.multisyntaxtree.MultiSyntaxTreeIndividual;
import net.sourceforge.jclec.multisyntaxtree.MultiSyntaxTreeSpecies;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class MultiSyntaxTreeIndividualSpecies
extends MultiSyntaxTreeSpecies
implements IConfigure {
    private static final long serialVersionUID = -5659464424179862147L;

    public void setNumberOfSyntaxTrees(int numberOfSyntaxTrees) {
        this.genotypeSchema = new SyntaxTreeSchema[numberOfSyntaxTrees];
        int i = 0;
        while (i < numberOfSyntaxTrees) {
            this.genotypeSchema[i] = new SyntaxTreeSchema();
            ++i;
        }
    }

    public void setRootSymbol(int syntaxTreeIndex, String rootSymbolName) {
        this.genotypeSchema[syntaxTreeIndex].setRootSymbol(rootSymbolName);
    }

    public void setTerminals(int syntaxTreeIndex, TerminalNode[] terminals) {
        this.genotypeSchema[syntaxTreeIndex].setTerminals(terminals);
    }

    public void setNonTerminals(int syntaxTreeIndex, NonTerminalNode[] nonTerminals) {
        this.genotypeSchema[syntaxTreeIndex].setNonTerminals(nonTerminals);
    }

    public void setMaxDerivSize(int syntaxTreeIndex, int maxDerivSize) {
        this.genotypeSchema[syntaxTreeIndex].setMaxDerivSize(maxDerivSize);
    }

    public MultiSyntaxTreeIndividual createIndividual() {
        return new MultiSyntaxTreeIndividual();
    }

    @Override
    public MultiSyntaxTreeIndividual createIndividual(SyntaxTree[] genotype) {
        return new MultiSyntaxTreeIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfSyntaxTrees = settings.getInt("[@number-of-trees]", 1);
        this.setNumberOfSyntaxTrees(numberOfSyntaxTrees);
        int i = 0;
        while (i < numberOfSyntaxTrees) {
            String header = "syntax-tree(" + i + ")";
            int numberOfTermSymbols = settings.getList(String.valueOf(header) + ".terminal-symbols.symbol.name").size();
            TerminalNode[] terminals = new TerminalNode[numberOfTermSymbols];
            int j = 0;
            while (j < numberOfTermSymbols) {
                TerminalNode termSymbol = new TerminalNode();
                String symbolName = settings.getString(String.valueOf(header) + ".terminal-symbols.symbol(" + j + ")" + ".name");
                termSymbol.setSymbol(symbolName);
                try {
                    String termSymbolCodeClassname = settings.getString(String.valueOf(header) + ".terminal-symbols.symbol(" + j + ")" + ".code");
                    Class<?> termSymbolCodeClass = Class.forName(termSymbolCodeClassname);
                    IPrimitive symbolCode = (IPrimitive)termSymbolCodeClass.newInstance();
                    termSymbol.setCode(symbolCode);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                terminals[j] = termSymbol;
                ++j;
            }
            this.setTerminals(i, terminals);
            int numberOfNonTermSymbols = settings.getList(String.valueOf(header) + ".non-terminal-symbols.symbol.name").size();
            NonTerminalNode[] nonTermSymbols = new NonTerminalNode[numberOfNonTermSymbols];
            int j2 = 0;
            while (j2 < numberOfNonTermSymbols) {
                NonTerminalNode nonTermSymbol = new NonTerminalNode();
                String symbolName = settings.getString(String.valueOf(header) + ".non-terminal-symbols.symbol(" + j2 + ")" + ".name");
                nonTermSymbol.setSymbol(symbolName);
                String[] symbolProduction = settings.getList(String.valueOf(header) + ".non-terminal-symbols.symbol(" + j2 + ")" + ".production-rule.element").toArray(new String[0]);
                nonTermSymbol.setProduction(symbolProduction);
                nonTermSymbols[j2] = nonTermSymbol;
                ++j2;
            }
            this.setNonTerminals(i, nonTermSymbols);
            String rootSymbol = settings.getString(String.valueOf(header) + ".root-symbol");
            this.setRootSymbol(i, rootSymbol);
            int maxDerivSize = settings.getInt(String.valueOf(header) + ".max-deriv-size");
            this.setMaxDerivSize(i, maxDerivSize);
            ++i;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof MultiSyntaxTreeIndividualSpecies) {
            MultiSyntaxTreeIndividualSpecies cother = (MultiSyntaxTreeIndividualSpecies)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.genotypeSchema, cother.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

