/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.RankedFeatureVector;

public class FeatureCounts
extends RankedFeatureVector {
    static boolean countInstances = true;

    private static double[] calcFeatureCounts(InstanceList instances) {
        int numInstances = instances.size();
        int numClasses = instances.getTargetAlphabet().size();
        int numFeatures = instances.getDataAlphabet().size();
        double[] counts = new double[numFeatures];
        for (int i = 0; i < instances.size(); ++i) {
            Instance inst = (Instance)instances.get(i);
            if (!(inst.getData() instanceof FeatureVector)) {
                throw new IllegalArgumentException("Currently only handles FeatureVector data");
            }
            FeatureVector fv = (FeatureVector)inst.getData();
            if (instances.getInstanceWeight(i) == 0.0) continue;
            for (int j = 0; j < fv.numLocations(); ++j) {
                if (countInstances) {
                    int n = fv.indexAtLocation(j);
                    counts[n] = counts[n] + 1.0;
                    continue;
                }
                int n = fv.indexAtLocation(j);
                counts[n] = counts[n] + fv.valueAtLocation(j);
            }
        }
        return counts;
    }

    public FeatureCounts(InstanceList instances) {
        super(instances.getDataAlphabet(), FeatureCounts.calcFeatureCounts(instances));
    }

    public FeatureCounts(Alphabet vocab, double[] counts) {
        super(vocab, counts);
    }

    public static class Factory
    implements RankedFeatureVector.Factory {
        @Override
        public RankedFeatureVector newRankedFeatureVector(InstanceList instances) {
            return new FeatureCounts(instances);
        }
    }
}

