/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsbase.util.Value;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.swf.DefineBitsJPEG3;
import org.freehep.graphicsio.swf.DefineBitsLossless2;
import org.freehep.graphicsio.swf.DefineFont;
import org.freehep.graphicsio.swf.DefineShape4;
import org.freehep.graphicsio.swf.DefineText;
import org.freehep.graphicsio.swf.DefineText2;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.End;
import org.freehep.graphicsio.swf.FillStyle;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.Gradient;
import org.freehep.graphicsio.swf.LineStyle;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.PlaceObject;
import org.freehep.graphicsio.swf.PlaceObject2;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFPathConstructor;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.graphicsio.swf.ShowFrame;

public class SWFGraphics2D
extends AbstractVectorGraphicsIO
implements SWFConstants {
    private static final int SWF_VERSION = 8;
    private static final String rootKey = SWFGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision$";
    private OutputStream ros;
    private SWFOutputStream os;
    private Value id;
    private Value depth;
    private static final float frameRate = 20.0f;
    private boolean compress = true;
    private LineStyleArray lineStyles;
    private FillStyleArray fillStyles;
    private Color textColor;
    private Shape unwrittenClip = null;
    private AffineTransform clipTransform = null;
    private int clipID;
    private int clipDepthID;
    private int showClipID;
    private int showClipDepthID;
    boolean fillStroke;
    private static final boolean showBounds = false;
    private static final Properties replaceFonts;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public SWFGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public SWFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public SWFGraphics2D(OutputStream os, Dimension size) {
        super(size, true);
        this.init(os);
    }

    public SWFGraphics2D(OutputStream os, Component component) {
        super(component, true);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.initProperties(SWFGraphics2D.getDefaultProperties());
        this.ros = os;
        this.id = new Value().set(1);
        this.depth = new Value().set(1);
        this.textColor = this.getColor();
        this.fillStroke = true;
    }

    protected SWFGraphics2D(SWFGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.os = graphics.os;
        this.id = graphics.id;
        this.depth = graphics.depth;
        this.lineStyles = new LineStyleArray();
        this.lineStyles.add(graphics.lineStyles.get(0));
        if (this.isProperty(CLIP)) {
            this.lineStyles.add(graphics.lineStyles.get(1));
            this.lineStyles.add(graphics.lineStyles.get(2));
        }
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(graphics.fillStyles.get(0));
        this.textColor = graphics.textColor;
        this.fillStroke = graphics.fillStroke;
    }

    public void writeHeader() throws IOException {
        this.os = new SWFOutputStream(new BufferedOutputStream(this.ros), 8, this.getSize(), 20.0f, this.compress);
        String description = this.getCreator() + ":" + this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            description = description + " " + version.substring(1, version.length() - 1);
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        this.os.writeTag(new ShowFrame());
        this.os.writeTag(new End());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new SWFGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        SWFGraphics2D graphics = new SWFGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
        this.popStreamAndWriteClip();
    }

    public void draw(Shape shape) {
        Shape strokedShape = this.getStroke().createStrokedShape(shape);
        if (this.fillStroke) {
            this.fill(new Area(strokedShape));
            return;
        }
        try {
            Rectangle2D bounds = strokedShape.getBounds2D();
            SWFShape swfShape = this.createShape(shape, 1, 0, -1);
            this.os.writeTag(new DefineShape4(this.id.getInt(), bounds, this.fillStyles, this.lineStyles, swfShape));
            this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
            this.id.set(this.id.getInt() + 1);
            this.depth.set(this.depth.getInt() + 1);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            Rectangle2D bounds = new BasicStroke().createStrokedShape(shape).getBounds2D();
            SWFShape swfShape = this.createShape(shape, 0, 1, -1);
            this.os.writeTag(new DefineShape4(this.id.getInt(), bounds, this.fillStyles, this.lineStyles, swfShape));
            this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
            this.id.set(this.id.getInt() + 1);
            this.depth.set(this.depth.getInt() + 1);
            boolean eo = SWFPathConstructor.isEvenOdd((Shape)shape);
            if (!eo) {
                this.writeWarning(this.getClass() + ": cannot fill using non-zero winding rule, used even-odd instead.");
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            this.setFillColor(fillColor);
            this.fill(shape);
            this.setFillColor(this.getColor());
            this.draw(shape);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        int imageID = this.id.getInt();
        this.os.writeTag(this.getImageTag(imageID, image, bkg));
        this.id.set(this.id.getInt() + 1);
        Shape shape = xform.createTransformedShape(new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        AffineTransform imageTransform = new AffineTransform(20.0f, 0.0f, 0.0f, 20.0f, 0.0f, 0.0f);
        xform.concatenate(imageTransform);
        SWFShape imageShape = this.createShape(shape, 0, 0, 1);
        FillStyleArray imageFill = new FillStyleArray();
        imageFill.add(new FillStyle(imageID, false, xform));
        LineStyleArray imageLine = new LineStyleArray();
        Rectangle bounds = shape.getBounds();
        this.os.writeTag(new DefineShape4(this.id.getInt(), bounds, imageFill, imageLine, imageShape));
        this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
        this.id.set(this.id.getInt() + 1);
        this.depth.set(this.depth.getInt() + 1);
    }

    protected void writeString(String string, double x, double y) throws IOException {
        String fontName = this.getFont().getName();
        string = FontEncoder.getEncodedString((String)string, (String)fontName);
        Font font = (fontName = replaceFonts.getProperty(fontName, null)) == null ? this.getFont() : new Font(fontName, this.getFont().getStyle(), this.getFont().getSize());
        Font font1024 = font.deriveFont(51.2f);
        GlyphVector glyphs = font1024.createGlyphVector(this.getFontRenderContext(), string);
        Rectangle2D bounds = font.createGlyphVector(this.getFontRenderContext(), string).getVisualBounds();
        bounds.setRect(bounds.getX() + x, bounds.getY() + y, bounds.getWidth(), bounds.getHeight());
        int fontID = this.id.getInt();
        DefineFont swfFont = new DefineFont(fontID);
        this.id.set(this.id.getInt() + 1);
        Vector<DefineText.Record> text = new Vector<DefineText.Record>();
        DefineText.RecordType1 record1 = new DefineText.RecordType1(fontID, this.textColor, (int)(x * 20.0), (int)(y * 20.0), (int)(font.getSize2D() * 20.0f));
        DefineText.RecordType0 record0 = new DefineText.RecordType0();
        text.add(record1);
        text.add(record0);
        int textID = this.id.getInt();
        DefineText2 swfText = new DefineText2(textID, bounds, new AffineTransform(), text);
        this.id.set(this.id.getInt() + 1);
        for (int i = 0; i < glyphs.getNumGlyphs(); ++i) {
            swfFont.add(this.createShape(glyphs.getGlyphOutline(i), -1, 1, -1));
            record0.add(new DefineText.GlyphEntry(i, 0));
        }
        this.os.writeTag(swfFont);
        this.os.writeTag(swfText);
        this.os.writeTag(new PlaceObject2(textID, this.depth.getInt(), this.getTransform()));
        this.depth.set(this.depth.getInt() + 1);
    }

    protected void writeTransform(AffineTransform t) throws IOException {
    }

    protected void writeSetTransform(AffineTransform t) throws IOException {
    }

    protected void writeSetClip(Shape s) throws IOException {
        this.writeClip(s);
    }

    protected void writeClip(Shape s) throws IOException {
        this.popStreamAndWriteClip();
        this.unwrittenClip = s;
        AffineTransform affineTransform = this.clipTransform = this.unwrittenClip != null ? new AffineTransform(this.getTransform()) : null;
        if (this.unwrittenClip != null) {
            this.clipID = this.id.getInt();
            this.id.set(this.id.getInt() + 1);
            this.clipDepthID = this.depth.getInt();
            this.depth.set(this.depth.getInt() + 1);
            if (this.isProperty(CLIP)) {
                this.showClipID = this.id.getInt();
                this.id.set(this.id.getInt() + 1);
                this.showClipDepthID = this.depth.getInt();
                this.depth.set(this.depth.getInt() + 1);
            }
            this.os.pushBuffer();
        } else {
            this.clipID = 0;
            this.clipDepthID = 0;
            if (this.isProperty(CLIP)) {
                this.showClipID = 0;
                this.showClipDepthID = 0;
            }
        }
    }

    protected void writeStroke(Stroke stroke) throws IOException {
        this.fillStroke = true;
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            this.setPen(bs, this.getColor());
            if (bs.getLineWidth() == 0.0f) {
                this.fillStroke = false;
            }
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color p) throws IOException {
        this.setPen((BasicStroke)this.getStroke(), p);
        this.setFillColor(p);
        this.textColor = PrintColor.createPrintColor((Color)p);
    }

    protected void writePaint(GradientPaint p) throws IOException {
        Gradient[] gradient = new Gradient[]{new Gradient(0, p.getColor1()), new Gradient(255, p.getColor2())};
        double x0 = p.getPoint1().getX();
        double y0 = p.getPoint1().getY();
        double dx = p.getPoint2().getX() - x0;
        double dy = p.getPoint2().getY() - y0;
        double scale = p.getPoint1().distance(p.getPoint2()) * 20.0 / 32768.0;
        double angle = Math.atan2(dy, dx);
        AffineTransform transform = new AffineTransform(scale, 0.0, 0.0, scale, dx / 2.0 + x0, dy / 2.0 + y0);
        transform.rotate(angle);
        int spreadMode = p.isCyclic() ? 1 : 0;
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(gradient, 16, spreadMode, 0, 0.0f, transform));
        this.textColor = PrintColor.mixColor((Color)p.getColor1(), (Color)p.getColor2());
    }

    protected void writePaint(TexturePaint p) throws IOException {
        BufferedImage image = p.getImage();
        int imageID = this.id.getInt();
        this.os.writeTag(this.getImageTag(imageID, image, null));
        this.id.set(this.id.getInt() + 1);
        Rectangle2D a = p.getAnchorRect();
        double sx = a.getWidth() / (double)image.getWidth();
        double sy = a.getHeight() / (double)image.getHeight();
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(imageID, true, new AffineTransform(sx * 20.0, 0.0, 0.0, sy * 20.0, a.getX(), a.getY())));
        this.textColor = PrintColor.black;
    }

    protected void writePaint(Paint p) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + p.getClass());
        this.writePaint(Color.BLACK);
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "SWFGraphics2D";
    }

    SWFShape createShape(Shape shape, int stroke, int fill0, int fill1) throws IOException {
        AffineTransform t = this.getTransform();
        double resolution = 0.5 / (20.0 * Math.min(t.getScaleX(), t.getScaleY()));
        Vector<SWFShape.Record> path = new Vector<SWFShape.Record>();
        SWFPathConstructor pc = new SWFPathConstructor(path, stroke, fill0, fill1, resolution);
        pc.addPath(shape);
        return new SWFShape(path);
    }

    private void setPen(BasicStroke stroke, Color color) throws IOException {
        this.lineStyles = new LineStyleArray();
        this.lineStyles.add(new LineStyle((int)(stroke.getLineWidth() * 20.0f), this.getPrintColor(color)));
        if (this.isProperty(CLIP)) {
            this.lineStyles.add(new LineStyle(20, Color.cyan));
            this.lineStyles.add(new LineStyle(20, Color.orange));
        }
    }

    private void setFillColor(Color color) throws IOException {
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(this.getPrintColor(color)));
    }

    private void popStreamAndWriteClip() throws IOException {
        if (this.unwrittenClip == null) {
            return;
        }
        if (this.clipID == 0 || this.clipDepthID == 0) {
            System.err.println("SWFGraphics2D: internal error, invalid clipID or clipDepthID");
            return;
        }
        this.os.popBuffer();
        Rectangle2D bounds = this.unwrittenClip.getBounds2D();
        SWFShape clipShape = this.createShape(this.unwrittenClip, 0, 1, -1);
        this.os.writeTag(new DefineShape4(this.clipID, bounds, this.fillStyles, this.lineStyles, clipShape));
        int clipDepth = this.depth.getInt() - 1;
        this.os.writeTag(new PlaceObject2(this.clipID, this.clipDepthID, this.clipTransform, clipDepth));
        if (this.isProperty(CLIP)) {
            if (this.showClipID == 0 || this.showClipDepthID == 0) {
                System.err.println("SWFGraphics2D: internal error, invalid showClipID or showClipDepthID");
                return;
            }
            SWFShape swfBounds = this.createShape(bounds, 3, 0, -1);
            this.os.writeTag(new DefineShape4(this.showClipID, bounds, this.fillStyles, this.lineStyles, swfBounds));
            this.os.writeTag(new PlaceObject(this.showClipID, this.showClipDepthID, this.clipTransform));
        }
        this.os.append();
    }

    private SWFTag getImageTag(int imageID, RenderedImage image, Color bkg) throws IOException {
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        DefineBitsLossless2 flateTag = null;
        if (writeAs.equals("ZLIB") || writeAs.equals("Smallest Size")) {
            flateTag = new DefineBitsLossless2(imageID, image, bkg);
        }
        DefineBitsJPEG3 jpgTag = null;
        if (writeAs.equals("JPG") || writeAs.equals("Smallest Size")) {
            jpgTag = new DefineBitsJPEG3(imageID, image, bkg, new Properties());
        }
        DefinitionTag imageTag = writeAs.equals("ZLIB") ? flateTag : (writeAs.equals("JPG") ? jpgTag : ((double)jpgTag.getLength() < 0.5 * (double)flateTag.getLength() ? jpgTag : flateTag));
        return imageTag;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(CLIP, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        replaceFonts = new Properties();
        replaceFonts.setProperty("Symbol", "Serif");
        replaceFonts.setProperty("ZapfDingbats", "Serif");
    }
}

