/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.Arrays;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.MoleculeHashGenerator;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.hash.Xorshift;
import org.openscience.cdk.interfaces.IAtomContainer;

final class BasicMoleculeHashGenerator
implements MoleculeHashGenerator {
    private final AtomHashGenerator generator;
    private final Pseudorandom pseudorandom;

    public BasicMoleculeHashGenerator(AtomHashGenerator generator) {
        this(generator, new Xorshift());
    }

    BasicMoleculeHashGenerator(AtomHashGenerator generator, Pseudorandom pseudorandom) {
        if (generator == null) {
            throw new NullPointerException("no AtomHashGenerator provided");
        }
        if (pseudorandom == null) {
            throw new NullPointerException("no Pseudorandom number generator provided");
        }
        this.generator = generator;
        this.pseudorandom = pseudorandom;
    }

    public long generate(IAtomContainer container) {
        long[] hashes = this.generator.generate(container);
        long[] rotated = new long[hashes.length];
        Arrays.sort(hashes);
        long hash = Integer.MAX_VALUE;
        for (int i = 0; i < hashes.length; ++i) {
            if (i > 0 && hashes[i] == hashes[i - 1]) {
                rotated[i] = this.pseudorandom.next(rotated[i - 1]);
                hash ^= rotated[i];
                continue;
            }
            rotated[i] = hashes[i];
            hash ^= rotated[i];
        }
        return hash;
    }
}

