/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.util.BitSetUtils;

public class KBestSGSetBitSetBased
implements KBestSGSet {
    private int epsilon = 0;
    private double sgMinQualityLimit = Double.NEGATIVE_INFINITY;
    private int maxSGCount = Integer.MAX_VALUE;
    private DataRecordIteration dataRecordIteration;
    private PriorityQueue<SG> sgList;
    private HashMap<SG, BitSet> negativesMap;
    private HashMap<SG, BitSet> positivesMap;
    private double maxQuality;
    private String name;

    public KBestSGSetBitSetBased(int maxSGCount, double minQualityLimit) {
        Comparator<SG> comparator = new Comparator<SG>(){

            @Override
            public int compare(SG o1, SG o2) {
                return Double.compare(o1.getQuality(), o2.getQuality());
            }
        };
        this.maxQuality = 0.0;
        this.sgList = new PriorityQueue<SG>(maxSGCount + 1, comparator);
        this.negativesMap = new HashMap();
        this.positivesMap = new HashMap();
        this.maxSGCount = maxSGCount;
        this.sgMinQualityLimit = minQualityLimit;
        this.setEpsilon(0);
    }

    @Override
    public void add(SG subgroup) {
        if (this.isInKBestQualityRange(subgroup.getQuality())) {
            this.addByReplacingWorstSG(subgroup);
        }
    }

    @Override
    public void addAll(Iterable<SG> subgroups) {
        for (SG sg : subgroups) {
            this.add(sg);
        }
    }

    @Override
    public void addByReplacingWorstSG(SG betterSG) {
        if (this.dataRecordIteration == null) {
            throw new IllegalArgumentException("not implemented yet. Must generate hashed BitSets here!");
        }
        BitSet allBitSet = BitSetUtils.generateBitSet(betterSG, this.dataRecordIteration);
        BitSet posBitSet = BitSetUtils.generatePositives(betterSG, this.dataRecordIteration);
        this.addByReplacingWorstSG(betterSG, allBitSet, posBitSet);
    }

    public void addByReplacingWorstSG(SG betterSG, BitSet allBitSet, BitSet positivesBitSet) {
        this.sgList.offer(betterSG);
        this.positivesMap.put(betterSG, positivesBitSet);
        BitSet fpBitSet = (BitSet)allBitSet.clone();
        fpBitSet.andNot(positivesBitSet);
        this.negativesMap.put(betterSG, fpBitSet);
        this.maxQuality = Math.max(this.maxQuality, betterSG.getQuality());
        if (this.sgList.size() > this.maxSGCount) {
            this.sgList.poll();
        }
    }

    @Override
    public boolean contains(SG otherSG) {
        return this.sgList.contains(otherSG);
    }

    public DataRecordIteration getDataRecordIteration() {
        return this.dataRecordIteration;
    }

    public int getEpsilon() {
        return this.epsilon;
    }

    @Override
    public int getMaxSGCount() {
        return this.maxSGCount;
    }

    @Override
    public double getMaxSGQuality() {
        return this.maxQuality;
    }

    @Override
    public double getMaxSubgroupSize() {
        double result = -1.0;
        for (SG sg : this.sgList) {
            result = Math.max(result, sg.getStatistics().getSubgroupSize());
        }
        return result;
    }

    @Override
    public double getMinSGQuality() {
        if (this.sgList.isEmpty()) {
            return this.getSGMinQualityLimit();
        }
        return this.sgList.peek().getQuality();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getQualitySum() {
        double quality = 0.0;
        for (SG sg : this) {
            quality += sg.getQuality();
        }
        return quality;
    }

    @Override
    public double getSGMinQualityLimit() {
        return this.sgMinQualityLimit;
    }

    @Override
    public boolean isInKBestQualityRange(double quality) {
        if (quality >= this.getSGMinQualityLimit()) {
            if (this.sgList.size() < this.getMaxSGCount()) {
                return true;
            }
            return quality > this.getMinSGQuality();
        }
        return false;
    }

    public boolean isSGStrictlyIrrelevant(SG sg) {
        BitSet allBitSet = BitSetUtils.generateBitSet(sg, this.dataRecordIteration);
        BitSet positives = BitSetUtils.generatePositives(sg, this.dataRecordIteration);
        return this.isSGStrictlyIrrelevant(allBitSet, positives);
    }

    public boolean isSGStrictlyIrrelevant(BitSet bitSetAll, BitSet bitSetPositives) {
        for (SG refSG : this.sgList) {
            if (!this.isSGStrictlyIrrelevant(bitSetAll, bitSetPositives, refSG)) continue;
            return true;
        }
        return false;
    }

    private boolean isSGStrictlyIrrelevant(BitSet bitSetAll, BitSet bitSetPositives, SG referenceSG) {
        BitSet tpsOnlyInNew = (BitSet)bitSetPositives.clone();
        BitSet positivesReference = this.positivesMap.get(referenceSG);
        if (positivesReference == null) {
            throw new IllegalArgumentException();
        }
        tpsOnlyInNew.andNot(positivesReference);
        if (tpsOnlyInNew.cardinality() > this.epsilon) {
            return false;
        }
        BitSet referenceFP = this.negativesMap.get(referenceSG);
        if (referenceFP == null) {
            throw new IllegalArgumentException();
        }
        BitSet newNegatives = (BitSet)bitSetAll.clone();
        newNegatives.andNot(bitSetPositives);
        BitSet fpsOnlyInReference = (BitSet)referenceFP.clone();
        fpsOnlyInReference.andNot(newNegatives);
        return fpsOnlyInReference.cardinality() <= this.epsilon;
    }

    @Override
    public Iterator<SG> iterator() {
        return this.sgList.iterator();
    }

    @Override
    public void remove(SG sg) {
        this.sgList.remove(sg);
    }

    @Override
    public void removeAll(Iterable<SG> sgs) {
        for (SG sg : sgs) {
            this.remove(sg);
        }
    }

    public void setDataRecordIteration(DataRecordIteration dataRecordIteration) {
        this.dataRecordIteration = dataRecordIteration;
    }

    public void setEpsilon(int epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int size() {
        return this.sgList.size();
    }

    @Override
    public List<SG> toSortedList(boolean ascending) {
        ArrayList<SG> result = new ArrayList<SG>(this.sgList);
        final boolean finalInvert = ascending;
        Collections.sort(result, new Comparator<SG>(){

            @Override
            public int compare(SG sg1, SG sg2) {
                int result = Double.compare(sg1.getQuality(), sg2.getQuality());
                return finalInvert ? result : -result;
            }
        });
        return result;
    }

    public void testAndRemoveIrrelevantSubgroupsFromSGSet() {
        LinkedList<SG> sgsToRemove = new LinkedList<SG>();
        for (SG sgReference : this.sgList) {
            for (SG sgTest : this.sgList) {
                if (sgReference.equals(sgTest) || sgsToRemove.contains(sgTest) || sgReference.getQuality() < sgTest.getQuality()) continue;
                BitSet positives = this.positivesMap.get(sgTest);
                BitSet allInstances = (BitSet)this.negativesMap.get(sgTest).clone();
                allInstances.or(positives);
                if (!this.isSGStrictlyIrrelevant(allInstances, positives, sgReference)) continue;
                sgsToRemove.add(sgTest);
            }
        }
        this.removeAll(sgsToRemove);
    }

    @Override
    public String toComprehensiveString() {
        String result = "SGSet (" + this.getMinSGQuality() + ", " + this.getMaxSGQuality() + ") - subgroups: \n";
        ArrayList<SG> list = new ArrayList<SG>();
        list.addAll(this.sgList);
        Collections.sort(list, this.sgList.comparator());
        for (SG sg : list) {
            result = String.valueOf(result) + "q: (" + sg.getQuality() + ") \t" + sg.getSGDescription() + "\n";
        }
        return result;
    }

    public String toString() {
        return this.toComprehensiveString();
    }

    @Override
    public void initWith(SGSet sgSet) {
        this.sgList.addAll(sgSet.toSortedList(false));
        this.maxQuality = sgSet.getMaxSGQuality();
        if (sgSet instanceof KBestSGSet) {
            KBestSGSet kBestSGSet = (KBestSGSet)sgSet;
            this.maxSGCount = kBestSGSet.getMaxSGCount();
            this.sgMinQualityLimit = kBestSGSet.getSGMinQualityLimit();
        }
    }

    @Override
    public SGSet sortSubgroupsByQualityDescending() {
        List<SG> subgroups = Arrays.asList(this.sgList.toArray(new SG[0]));
        Collections.sort(subgroups, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof SG && o2 instanceof SG) {
                    double q1 = ((SG)o1).getQuality();
                    double q2 = ((SG)o2).getQuality();
                    return -1 * Double.compare(q1, q2);
                }
                throw new RuntimeException("No SG element in SGSet!");
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }

            public int hashCode() {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return 42;
            }
        });
        SGSet result = SGSets.createSGSet();
        result.addAll(subgroups);
        return result;
    }
}

