/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.LatentFactorModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;

public class LFMLoadingsPotentialDerivative
implements GradientWrtParameterProvider {
    LatentFactorModel lfm;

    public LFMLoadingsPotentialDerivative(LatentFactorModel latentFactorModel) {
        this.lfm = latentFactorModel;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.lfm;
    }

    @Override
    public Parameter getParameter() {
        return this.lfm.getLoadings();
    }

    @Override
    public int getDimension() {
        return this.lfm.getLoadings().getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = new double[this.lfm.getLoadings().getDimension()];
        Parameter parameter = this.lfm.getMissingIndicator();
        int n = this.lfm.getFactors().getColumnDimension();
        int n2 = this.lfm.getLoadings().getRowDimension();
        int n3 = this.lfm.getLoadings().getColumnDimension();
        double[] dArray2 = this.lfm.getResidual();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    if (parameter != null && parameter.getParameterValue(k * n2 + j) == 1.0) continue;
                    int n4 = i * n2 + j;
                    dArray[n4] = dArray[n4] + this.lfm.getFactors().getParameterValue(i, k) * this.lfm.getColumnPrecision().getParameterValue(j, j) * dArray2[k * n2 + j];
                }
            }
        }
        return dArray;
    }
}

